/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration;
import software.amazon.awssdk.services.quicksight.model.ArnListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.SessionTag;
import software.amazon.awssdk.services.quicksight.model.SessionTagListCopier;
import software.amazon.awssdk.services.quicksight.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateEmbedUrlForAnonymousUserRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, GenerateEmbedUrlForAnonymousUserRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(GenerateEmbedUrlForAnonymousUserRequest.getter(GenerateEmbedUrlForAnonymousUserRequest::awsAccountId)).setter(GenerateEmbedUrlForAnonymousUserRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SessionLifetimeInMinutes").getter(GenerateEmbedUrlForAnonymousUserRequest.getter(GenerateEmbedUrlForAnonymousUserRequest::sessionLifetimeInMinutes)).setter(GenerateEmbedUrlForAnonymousUserRequest.setter(Builder::sessionLifetimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLifetimeInMinutes").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(GenerateEmbedUrlForAnonymousUserRequest.getter(GenerateEmbedUrlForAnonymousUserRequest::namespace)).setter(GenerateEmbedUrlForAnonymousUserRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<List<SessionTag>> SESSION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SessionTags").getter(GenerateEmbedUrlForAnonymousUserRequest.getter(GenerateEmbedUrlForAnonymousUserRequest::sessionTags)).setter(GenerateEmbedUrlForAnonymousUserRequest.setter(Builder::sessionTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SessionTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedResourceArns").getter(GenerateEmbedUrlForAnonymousUserRequest.getter(GenerateEmbedUrlForAnonymousUserRequest::authorizedResourceArns)).setter(GenerateEmbedUrlForAnonymousUserRequest.setter(Builder::authorizedResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnonymousUserEmbeddingExperienceConfiguration> EXPERIENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperienceConfiguration").getter(GenerateEmbedUrlForAnonymousUserRequest.getter(GenerateEmbedUrlForAnonymousUserRequest::experienceConfiguration)).setter(GenerateEmbedUrlForAnonymousUserRequest.setter(Builder::experienceConfiguration)).constructor(AnonymousUserEmbeddingExperienceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperienceConfiguration").build()}).build();
    private static final SdkField<List<String>> ALLOWED_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedDomains").getter(GenerateEmbedUrlForAnonymousUserRequest.getter(GenerateEmbedUrlForAnonymousUserRequest::allowedDomains)).setter(GenerateEmbedUrlForAnonymousUserRequest.setter(Builder::allowedDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, SESSION_LIFETIME_IN_MINUTES_FIELD, NAMESPACE_FIELD, SESSION_TAGS_FIELD, AUTHORIZED_RESOURCE_ARNS_FIELD, EXPERIENCE_CONFIGURATION_FIELD, ALLOWED_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateEmbedUrlForAnonymousUserRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final Long sessionLifetimeInMinutes;
    private final String namespace;
    private final List<SessionTag> sessionTags;
    private final List<String> authorizedResourceArns;
    private final AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration;
    private final List<String> allowedDomains;

    private GenerateEmbedUrlForAnonymousUserRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.namespace = builder.namespace;
        this.sessionTags = builder.sessionTags;
        this.authorizedResourceArns = builder.authorizedResourceArns;
        this.experienceConfiguration = builder.experienceConfiguration;
        this.allowedDomains = builder.allowedDomains;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final Long sessionLifetimeInMinutes() {
        return this.sessionLifetimeInMinutes;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final boolean hasSessionTags() {
        return this.sessionTags != null && !(this.sessionTags instanceof SdkAutoConstructList);
    }

    public final List<SessionTag> sessionTags() {
        return this.sessionTags;
    }

    public final boolean hasAuthorizedResourceArns() {
        return this.authorizedResourceArns != null && !(this.authorizedResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedResourceArns() {
        return this.authorizedResourceArns;
    }

    public final AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration() {
        return this.experienceConfiguration;
    }

    public final boolean hasAllowedDomains() {
        return this.allowedDomains != null && !(this.allowedDomains instanceof SdkAutoConstructList);
    }

    public final List<String> allowedDomains() {
        return this.allowedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionTags() ? this.sessionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedResourceArns() ? this.authorizedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.experienceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedDomains() ? this.allowedDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateEmbedUrlForAnonymousUserRequest)) {
            return false;
        }
        GenerateEmbedUrlForAnonymousUserRequest other = (GenerateEmbedUrlForAnonymousUserRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes()) && Objects.equals(this.namespace(), other.namespace()) && this.hasSessionTags() == other.hasSessionTags() && Objects.equals(this.sessionTags(), other.sessionTags()) && this.hasAuthorizedResourceArns() == other.hasAuthorizedResourceArns() && Objects.equals(this.authorizedResourceArns(), other.authorizedResourceArns()) && Objects.equals(this.experienceConfiguration(), other.experienceConfiguration()) && this.hasAllowedDomains() == other.hasAllowedDomains() && Objects.equals(this.allowedDomains(), other.allowedDomains());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateEmbedUrlForAnonymousUserRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("SessionLifetimeInMinutes", (Object)this.sessionLifetimeInMinutes()).add("Namespace", (Object)this.namespace()).add("SessionTags", this.hasSessionTags() ? this.sessionTags() : null).add("AuthorizedResourceArns", this.hasAuthorizedResourceArns() ? this.authorizedResourceArns() : null).add("ExperienceConfiguration", (Object)this.experienceConfiguration()).add("AllowedDomains", this.hasAllowedDomains() ? this.allowedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "SessionLifetimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionLifetimeInMinutes()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "SessionTags": {
                return Optional.ofNullable(clazz.cast(this.sessionTags()));
            }
            case "AuthorizedResourceArns": {
                return Optional.ofNullable(clazz.cast(this.authorizedResourceArns()));
            }
            case "ExperienceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.experienceConfiguration()));
            }
            case "AllowedDomains": {
                return Optional.ofNullable(clazz.cast(this.allowedDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("SessionLifetimeInMinutes", SESSION_LIFETIME_IN_MINUTES_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("SessionTags", SESSION_TAGS_FIELD);
        map.put("AuthorizedResourceArns", AUTHORIZED_RESOURCE_ARNS_FIELD);
        map.put("ExperienceConfiguration", EXPERIENCE_CONFIGURATION_FIELD);
        map.put("AllowedDomains", ALLOWED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateEmbedUrlForAnonymousUserRequest, T> g) {
        return obj -> g.apply((GenerateEmbedUrlForAnonymousUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private Long sessionLifetimeInMinutes;
        private String namespace;
        private List<SessionTag> sessionTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> authorizedResourceArns = DefaultSdkAutoConstructList.getInstance();
        private AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration;
        private List<String> allowedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateEmbedUrlForAnonymousUserRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            this.namespace(model.namespace);
            this.sessionTags(model.sessionTags);
            this.authorizedResourceArns(model.authorizedResourceArns);
            this.experienceConfiguration(model.experienceConfiguration);
            this.allowedDomains(model.allowedDomains);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Long getSessionLifetimeInMinutes() {
            return this.sessionLifetimeInMinutes;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final List<SessionTag.Builder> getSessionTags() {
            List<SessionTag.Builder> result = SessionTagListCopier.copyToBuilder(this.sessionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionTags(Collection<SessionTag.BuilderImpl> sessionTags) {
            this.sessionTags = SessionTagListCopier.copyFromBuilder(sessionTags);
        }

        @Override
        public final Builder sessionTags(Collection<SessionTag> sessionTags) {
            this.sessionTags = SessionTagListCopier.copy(sessionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionTags(SessionTag ... sessionTags) {
            this.sessionTags(Arrays.asList(sessionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionTags(Consumer<SessionTag.Builder> ... sessionTags) {
            this.sessionTags(Stream.of(sessionTags).map(c -> (SessionTag)((SessionTag.Builder)SessionTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAuthorizedResourceArns() {
            if (this.authorizedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedResourceArns;
        }

        public final void setAuthorizedResourceArns(Collection<String> authorizedResourceArns) {
            this.authorizedResourceArns = ArnListCopier.copy(authorizedResourceArns);
        }

        @Override
        public final Builder authorizedResourceArns(Collection<String> authorizedResourceArns) {
            this.authorizedResourceArns = ArnListCopier.copy(authorizedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedResourceArns(String ... authorizedResourceArns) {
            this.authorizedResourceArns(Arrays.asList(authorizedResourceArns));
            return this;
        }

        public final AnonymousUserEmbeddingExperienceConfiguration.Builder getExperienceConfiguration() {
            return this.experienceConfiguration != null ? this.experienceConfiguration.toBuilder() : null;
        }

        public final void setExperienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration.BuilderImpl experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration != null ? experienceConfiguration.build() : null;
        }

        @Override
        public final Builder experienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration;
            return this;
        }

        public final Collection<String> getAllowedDomains() {
            if (this.allowedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedDomains;
        }

        public final void setAllowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
        }

        @Override
        public final Builder allowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedDomains(String ... allowedDomains) {
            this.allowedDomains(Arrays.asList(allowedDomains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateEmbedUrlForAnonymousUserRequest build() {
            return new GenerateEmbedUrlForAnonymousUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateEmbedUrlForAnonymousUserRequest> {
        public Builder awsAccountId(String var1);

        public Builder sessionLifetimeInMinutes(Long var1);

        public Builder namespace(String var1);

        public Builder sessionTags(Collection<SessionTag> var1);

        public Builder sessionTags(SessionTag ... var1);

        public Builder sessionTags(Consumer<SessionTag.Builder> ... var1);

        public Builder authorizedResourceArns(Collection<String> var1);

        public Builder authorizedResourceArns(String ... var1);

        public Builder experienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration var1);

        default public Builder experienceConfiguration(Consumer<AnonymousUserEmbeddingExperienceConfiguration.Builder> experienceConfiguration) {
            return this.experienceConfiguration((AnonymousUserEmbeddingExperienceConfiguration)((AnonymousUserEmbeddingExperienceConfiguration.Builder)AnonymousUserEmbeddingExperienceConfiguration.builder().applyMutation(experienceConfiguration)).build());
        }

        public Builder allowedDomains(Collection<String> var1);

        public Builder allowedDomains(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

