/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AxisDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.MissingDataConfiguration;
import software.amazon.awssdk.services.quicksight.model.MissingDataConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineSeriesAxisDisplayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineSeriesAxisDisplayOptions> {
    private static final SdkField<AxisDisplayOptions> AXIS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AxisOptions").getter(LineSeriesAxisDisplayOptions.getter(LineSeriesAxisDisplayOptions::axisOptions)).setter(LineSeriesAxisDisplayOptions.setter(Builder::axisOptions)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisOptions").build()}).build();
    private static final SdkField<List<MissingDataConfiguration>> MISSING_DATA_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MissingDataConfigurations").getter(LineSeriesAxisDisplayOptions.getter(LineSeriesAxisDisplayOptions::missingDataConfigurations)).setter(LineSeriesAxisDisplayOptions.setter(Builder::missingDataConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingDataConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MissingDataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AXIS_OPTIONS_FIELD, MISSING_DATA_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineSeriesAxisDisplayOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AxisDisplayOptions axisOptions;
    private final List<MissingDataConfiguration> missingDataConfigurations;

    private LineSeriesAxisDisplayOptions(BuilderImpl builder) {
        this.axisOptions = builder.axisOptions;
        this.missingDataConfigurations = builder.missingDataConfigurations;
    }

    public final AxisDisplayOptions axisOptions() {
        return this.axisOptions;
    }

    public final boolean hasMissingDataConfigurations() {
        return this.missingDataConfigurations != null && !(this.missingDataConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MissingDataConfiguration> missingDataConfigurations() {
        return this.missingDataConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.axisOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMissingDataConfigurations() ? this.missingDataConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineSeriesAxisDisplayOptions)) {
            return false;
        }
        LineSeriesAxisDisplayOptions other = (LineSeriesAxisDisplayOptions)obj;
        return Objects.equals(this.axisOptions(), other.axisOptions()) && this.hasMissingDataConfigurations() == other.hasMissingDataConfigurations() && Objects.equals(this.missingDataConfigurations(), other.missingDataConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"LineSeriesAxisDisplayOptions").add("AxisOptions", (Object)this.axisOptions()).add("MissingDataConfigurations", this.hasMissingDataConfigurations() ? this.missingDataConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AxisOptions": {
                return Optional.ofNullable(clazz.cast(this.axisOptions()));
            }
            case "MissingDataConfigurations": {
                return Optional.ofNullable(clazz.cast(this.missingDataConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AxisOptions", AXIS_OPTIONS_FIELD);
        map.put("MissingDataConfigurations", MISSING_DATA_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineSeriesAxisDisplayOptions, T> g) {
        return obj -> g.apply((LineSeriesAxisDisplayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AxisDisplayOptions axisOptions;
        private List<MissingDataConfiguration> missingDataConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineSeriesAxisDisplayOptions model) {
            this.axisOptions(model.axisOptions);
            this.missingDataConfigurations(model.missingDataConfigurations);
        }

        public final AxisDisplayOptions.Builder getAxisOptions() {
            return this.axisOptions != null ? this.axisOptions.toBuilder() : null;
        }

        public final void setAxisOptions(AxisDisplayOptions.BuilderImpl axisOptions) {
            this.axisOptions = axisOptions != null ? axisOptions.build() : null;
        }

        @Override
        public final Builder axisOptions(AxisDisplayOptions axisOptions) {
            this.axisOptions = axisOptions;
            return this;
        }

        public final List<MissingDataConfiguration.Builder> getMissingDataConfigurations() {
            List<MissingDataConfiguration.Builder> result = MissingDataConfigurationListCopier.copyToBuilder(this.missingDataConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMissingDataConfigurations(Collection<MissingDataConfiguration.BuilderImpl> missingDataConfigurations) {
            this.missingDataConfigurations = MissingDataConfigurationListCopier.copyFromBuilder(missingDataConfigurations);
        }

        @Override
        public final Builder missingDataConfigurations(Collection<MissingDataConfiguration> missingDataConfigurations) {
            this.missingDataConfigurations = MissingDataConfigurationListCopier.copy(missingDataConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingDataConfigurations(MissingDataConfiguration ... missingDataConfigurations) {
            this.missingDataConfigurations(Arrays.asList(missingDataConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingDataConfigurations(Consumer<MissingDataConfiguration.Builder> ... missingDataConfigurations) {
            this.missingDataConfigurations(Stream.of(missingDataConfigurations).map(c -> (MissingDataConfiguration)((MissingDataConfiguration.Builder)MissingDataConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LineSeriesAxisDisplayOptions build() {
            return new LineSeriesAxisDisplayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineSeriesAxisDisplayOptions> {
        public Builder axisOptions(AxisDisplayOptions var1);

        default public Builder axisOptions(Consumer<AxisDisplayOptions.Builder> axisOptions) {
            return this.axisOptions((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(axisOptions)).build());
        }

        public Builder missingDataConfigurations(Collection<MissingDataConfiguration> var1);

        public Builder missingDataConfigurations(MissingDataConfiguration ... var1);

        public Builder missingDataConfigurations(Consumer<MissingDataConfiguration.Builder> ... var1);
    }
}

