/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary;
import software.amazon.awssdk.services.quicksight.model.ActionConnectorSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActionConnectorsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListActionConnectorsResponse> {
    private static final SdkField<List<ActionConnectorSummary>> ACTION_CONNECTOR_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionConnectorSummaries").getter(ListActionConnectorsResponse.getter(ListActionConnectorsResponse::actionConnectorSummaries)).setter(ListActionConnectorsResponse.setter(Builder::actionConnectorSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnectorSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionConnectorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListActionConnectorsResponse.getter(ListActionConnectorsResponse::nextToken)).setter(ListActionConnectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListActionConnectorsResponse.getter(ListActionConnectorsResponse::requestId)).setter(ListActionConnectorsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListActionConnectorsResponse.getter(ListActionConnectorsResponse::status)).setter(ListActionConnectorsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_CONNECTOR_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListActionConnectorsResponse.memberNameToFieldInitializer();
    private final List<ActionConnectorSummary> actionConnectorSummaries;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private ListActionConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.actionConnectorSummaries = builder.actionConnectorSummaries;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final boolean hasActionConnectorSummaries() {
        return this.actionConnectorSummaries != null && !(this.actionConnectorSummaries instanceof SdkAutoConstructList);
    }

    public final List<ActionConnectorSummary> actionConnectorSummaries() {
        return this.actionConnectorSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionConnectorSummaries() ? this.actionConnectorSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionConnectorsResponse)) {
            return false;
        }
        ListActionConnectorsResponse other = (ListActionConnectorsResponse)((Object)obj);
        return this.hasActionConnectorSummaries() == other.hasActionConnectorSummaries() && Objects.equals(this.actionConnectorSummaries(), other.actionConnectorSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ListActionConnectorsResponse").add("ActionConnectorSummaries", this.hasActionConnectorSummaries() ? this.actionConnectorSummaries() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionConnectorSummaries": {
                return Optional.ofNullable(clazz.cast(this.actionConnectorSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActionConnectorSummaries", ACTION_CONNECTOR_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActionConnectorsResponse, T> g) {
        return obj -> g.apply((ListActionConnectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<ActionConnectorSummary> actionConnectorSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionConnectorsResponse model) {
            super(model);
            this.actionConnectorSummaries(model.actionConnectorSummaries);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final List<ActionConnectorSummary.Builder> getActionConnectorSummaries() {
            List<ActionConnectorSummary.Builder> result = ActionConnectorSummaryListCopier.copyToBuilder(this.actionConnectorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConnectorSummaries(Collection<ActionConnectorSummary.BuilderImpl> actionConnectorSummaries) {
            this.actionConnectorSummaries = ActionConnectorSummaryListCopier.copyFromBuilder(actionConnectorSummaries);
        }

        @Override
        public final Builder actionConnectorSummaries(Collection<ActionConnectorSummary> actionConnectorSummaries) {
            this.actionConnectorSummaries = ActionConnectorSummaryListCopier.copy(actionConnectorSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConnectorSummaries(ActionConnectorSummary ... actionConnectorSummaries) {
            this.actionConnectorSummaries(Arrays.asList(actionConnectorSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConnectorSummaries(Consumer<ActionConnectorSummary.Builder> ... actionConnectorSummaries) {
            this.actionConnectorSummaries(Stream.of(actionConnectorSummaries).map(c -> (ActionConnectorSummary)((ActionConnectorSummary.Builder)ActionConnectorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public ListActionConnectorsResponse build() {
            return new ListActionConnectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActionConnectorsResponse> {
        public Builder actionConnectorSummaries(Collection<ActionConnectorSummary> var1);

        public Builder actionConnectorSummaries(ActionConnectorSummary ... var1);

        public Builder actionConnectorSummaries(Consumer<ActionConnectorSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

