/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AuthorizedTargetsByService;
import software.amazon.awssdk.services.quicksight.model.AuthorizedTargetsByServicesCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityPropagationConfigsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListIdentityPropagationConfigsResponse> {
    private static final SdkField<List<AuthorizedTargetsByService>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(ListIdentityPropagationConfigsResponse.getter(ListIdentityPropagationConfigsResponse::services)).setter(ListIdentityPropagationConfigsResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizedTargetsByService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIdentityPropagationConfigsResponse.getter(ListIdentityPropagationConfigsResponse::nextToken)).setter(ListIdentityPropagationConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListIdentityPropagationConfigsResponse.getter(ListIdentityPropagationConfigsResponse::status)).setter(ListIdentityPropagationConfigsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListIdentityPropagationConfigsResponse.getter(ListIdentityPropagationConfigsResponse::requestId)).setter(ListIdentityPropagationConfigsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIdentityPropagationConfigsResponse.memberNameToFieldInitializer();
    private final List<AuthorizedTargetsByService> services;
    private final String nextToken;
    private final Integer status;
    private final String requestId;

    private ListIdentityPropagationConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<AuthorizedTargetsByService> services() {
        return this.services;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPropagationConfigsResponse)) {
            return false;
        }
        ListIdentityPropagationConfigsResponse other = (ListIdentityPropagationConfigsResponse)((Object)obj);
        return this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"ListIdentityPropagationConfigsResponse").add("Services", this.hasServices() ? this.services() : null).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Services", SERVICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityPropagationConfigsResponse, T> g) {
        return obj -> g.apply((ListIdentityPropagationConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<AuthorizedTargetsByService> services = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPropagationConfigsResponse model) {
            super(model);
            this.services(model.services);
            this.nextToken(model.nextToken);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final List<AuthorizedTargetsByService.Builder> getServices() {
            List<AuthorizedTargetsByService.Builder> result = AuthorizedTargetsByServicesCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<AuthorizedTargetsByService.BuilderImpl> services) {
            this.services = AuthorizedTargetsByServicesCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<AuthorizedTargetsByService> services) {
            this.services = AuthorizedTargetsByServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(AuthorizedTargetsByService ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<AuthorizedTargetsByService.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (AuthorizedTargetsByService)((AuthorizedTargetsByService.Builder)AuthorizedTargetsByService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListIdentityPropagationConfigsResponse build() {
            return new ListIdentityPropagationConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentityPropagationConfigsResponse> {
        public Builder services(Collection<AuthorizedTargetsByService> var1);

        public Builder services(AuthorizedTargetsByService ... var1);

        public Builder services(Consumer<AuthorizedTargetsByService.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

