/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DateTimeDatasetParameterValueListCopier;
import software.amazon.awssdk.services.quicksight.model.DecimalDatasetParameterValueListCopier;
import software.amazon.awssdk.services.quicksight.model.IntegerDatasetParameterValueListCopier;
import software.amazon.awssdk.services.quicksight.model.StringDatasetParameterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewDefaultValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NewDefaultValues> {
    private static final SdkField<List<String>> STRING_STATIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringStaticValues").getter(NewDefaultValues.getter(NewDefaultValues::stringStaticValues)).setter(NewDefaultValues.setter(Builder::stringStaticValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringStaticValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> DECIMAL_STATIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DecimalStaticValues").getter(NewDefaultValues.getter(NewDefaultValues::decimalStaticValues)).setter(NewDefaultValues.setter(Builder::decimalStaticValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalStaticValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Instant>> DATE_TIME_STATIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DateTimeStaticValues").getter(NewDefaultValues.getter(NewDefaultValues::dateTimeStaticValues)).setter(NewDefaultValues.setter(Builder::dateTimeStaticValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeStaticValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> INTEGER_STATIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegerStaticValues").getter(NewDefaultValues.getter(NewDefaultValues::integerStaticValues)).setter(NewDefaultValues.setter(Builder::integerStaticValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerStaticValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_STATIC_VALUES_FIELD, DECIMAL_STATIC_VALUES_FIELD, DATE_TIME_STATIC_VALUES_FIELD, INTEGER_STATIC_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NewDefaultValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> stringStaticValues;
    private final List<Double> decimalStaticValues;
    private final List<Instant> dateTimeStaticValues;
    private final List<Long> integerStaticValues;

    private NewDefaultValues(BuilderImpl builder) {
        this.stringStaticValues = builder.stringStaticValues;
        this.decimalStaticValues = builder.decimalStaticValues;
        this.dateTimeStaticValues = builder.dateTimeStaticValues;
        this.integerStaticValues = builder.integerStaticValues;
    }

    public final boolean hasStringStaticValues() {
        return this.stringStaticValues != null && !(this.stringStaticValues instanceof SdkAutoConstructList);
    }

    public final List<String> stringStaticValues() {
        return this.stringStaticValues;
    }

    public final boolean hasDecimalStaticValues() {
        return this.decimalStaticValues != null && !(this.decimalStaticValues instanceof SdkAutoConstructList);
    }

    public final List<Double> decimalStaticValues() {
        return this.decimalStaticValues;
    }

    public final boolean hasDateTimeStaticValues() {
        return this.dateTimeStaticValues != null && !(this.dateTimeStaticValues instanceof SdkAutoConstructList);
    }

    public final List<Instant> dateTimeStaticValues() {
        return this.dateTimeStaticValues;
    }

    public final boolean hasIntegerStaticValues() {
        return this.integerStaticValues != null && !(this.integerStaticValues instanceof SdkAutoConstructList);
    }

    public final List<Long> integerStaticValues() {
        return this.integerStaticValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringStaticValues() ? this.stringStaticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDecimalStaticValues() ? this.decimalStaticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDateTimeStaticValues() ? this.dateTimeStaticValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerStaticValues() ? this.integerStaticValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewDefaultValues)) {
            return false;
        }
        NewDefaultValues other = (NewDefaultValues)obj;
        return this.hasStringStaticValues() == other.hasStringStaticValues() && Objects.equals(this.stringStaticValues(), other.stringStaticValues()) && this.hasDecimalStaticValues() == other.hasDecimalStaticValues() && Objects.equals(this.decimalStaticValues(), other.decimalStaticValues()) && this.hasDateTimeStaticValues() == other.hasDateTimeStaticValues() && Objects.equals(this.dateTimeStaticValues(), other.dateTimeStaticValues()) && this.hasIntegerStaticValues() == other.hasIntegerStaticValues() && Objects.equals(this.integerStaticValues(), other.integerStaticValues());
    }

    public final String toString() {
        return ToString.builder((String)"NewDefaultValues").add("StringStaticValues", this.hasStringStaticValues() ? this.stringStaticValues() : null).add("DecimalStaticValues", this.hasDecimalStaticValues() ? this.decimalStaticValues() : null).add("DateTimeStaticValues", this.hasDateTimeStaticValues() ? this.dateTimeStaticValues() : null).add("IntegerStaticValues", this.hasIntegerStaticValues() ? this.integerStaticValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringStaticValues": {
                return Optional.ofNullable(clazz.cast(this.stringStaticValues()));
            }
            case "DecimalStaticValues": {
                return Optional.ofNullable(clazz.cast(this.decimalStaticValues()));
            }
            case "DateTimeStaticValues": {
                return Optional.ofNullable(clazz.cast(this.dateTimeStaticValues()));
            }
            case "IntegerStaticValues": {
                return Optional.ofNullable(clazz.cast(this.integerStaticValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringStaticValues", STRING_STATIC_VALUES_FIELD);
        map.put("DecimalStaticValues", DECIMAL_STATIC_VALUES_FIELD);
        map.put("DateTimeStaticValues", DATE_TIME_STATIC_VALUES_FIELD);
        map.put("IntegerStaticValues", INTEGER_STATIC_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NewDefaultValues, T> g) {
        return obj -> g.apply((NewDefaultValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stringStaticValues = DefaultSdkAutoConstructList.getInstance();
        private List<Double> decimalStaticValues = DefaultSdkAutoConstructList.getInstance();
        private List<Instant> dateTimeStaticValues = DefaultSdkAutoConstructList.getInstance();
        private List<Long> integerStaticValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NewDefaultValues model) {
            this.stringStaticValues(model.stringStaticValues);
            this.decimalStaticValues(model.decimalStaticValues);
            this.dateTimeStaticValues(model.dateTimeStaticValues);
            this.integerStaticValues(model.integerStaticValues);
        }

        public final Collection<String> getStringStaticValues() {
            if (this.stringStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringStaticValues;
        }

        public final void setStringStaticValues(Collection<String> stringStaticValues) {
            this.stringStaticValues = StringDatasetParameterValueListCopier.copy(stringStaticValues);
        }

        @Override
        public final Builder stringStaticValues(Collection<String> stringStaticValues) {
            this.stringStaticValues = StringDatasetParameterValueListCopier.copy(stringStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringStaticValues(String ... stringStaticValues) {
            this.stringStaticValues(Arrays.asList(stringStaticValues));
            return this;
        }

        public final Collection<Double> getDecimalStaticValues() {
            if (this.decimalStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.decimalStaticValues;
        }

        public final void setDecimalStaticValues(Collection<Double> decimalStaticValues) {
            this.decimalStaticValues = DecimalDatasetParameterValueListCopier.copy(decimalStaticValues);
        }

        @Override
        public final Builder decimalStaticValues(Collection<Double> decimalStaticValues) {
            this.decimalStaticValues = DecimalDatasetParameterValueListCopier.copy(decimalStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalStaticValues(Double ... decimalStaticValues) {
            this.decimalStaticValues(Arrays.asList(decimalStaticValues));
            return this;
        }

        public final Collection<Instant> getDateTimeStaticValues() {
            if (this.dateTimeStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dateTimeStaticValues;
        }

        public final void setDateTimeStaticValues(Collection<Instant> dateTimeStaticValues) {
            this.dateTimeStaticValues = DateTimeDatasetParameterValueListCopier.copy(dateTimeStaticValues);
        }

        @Override
        public final Builder dateTimeStaticValues(Collection<Instant> dateTimeStaticValues) {
            this.dateTimeStaticValues = DateTimeDatasetParameterValueListCopier.copy(dateTimeStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeStaticValues(Instant ... dateTimeStaticValues) {
            this.dateTimeStaticValues(Arrays.asList(dateTimeStaticValues));
            return this;
        }

        public final Collection<Long> getIntegerStaticValues() {
            if (this.integerStaticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integerStaticValues;
        }

        public final void setIntegerStaticValues(Collection<Long> integerStaticValues) {
            this.integerStaticValues = IntegerDatasetParameterValueListCopier.copy(integerStaticValues);
        }

        @Override
        public final Builder integerStaticValues(Collection<Long> integerStaticValues) {
            this.integerStaticValues = IntegerDatasetParameterValueListCopier.copy(integerStaticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerStaticValues(Long ... integerStaticValues) {
            this.integerStaticValues(Arrays.asList(integerStaticValues));
            return this;
        }

        public NewDefaultValues build() {
            return new NewDefaultValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NewDefaultValues> {
        public Builder stringStaticValues(Collection<String> var1);

        public Builder stringStaticValues(String ... var1);

        public Builder decimalStaticValues(Collection<Double> var1);

        public Builder decimalStaticValues(Double ... var1);

        public Builder dateTimeStaticValues(Collection<Instant> var1);

        public Builder dateTimeStaticValues(Instant ... var1);

        public Builder integerStaticValues(Collection<Long> var1);

        public Builder integerStaticValues(Long ... var1);
    }
}

