/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AuthorizationCodeGrantCredentialsSource;
import software.amazon.awssdk.services.quicksight.model.ReadAuthorizationCodeGrantCredentialsDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadAuthorizationCodeGrantMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadAuthorizationCodeGrantMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseEndpoint").getter(ReadAuthorizationCodeGrantMetadata.getter(ReadAuthorizationCodeGrantMetadata::baseEndpoint)).setter(ReadAuthorizationCodeGrantMetadata.setter(Builder::baseEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectUrl").getter(ReadAuthorizationCodeGrantMetadata.getter(ReadAuthorizationCodeGrantMetadata::redirectUrl)).setter(ReadAuthorizationCodeGrantMetadata.setter(Builder::redirectUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectUrl").build()}).build();
    private static final SdkField<ReadAuthorizationCodeGrantCredentialsDetails> READ_AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReadAuthorizationCodeGrantCredentialsDetails").getter(ReadAuthorizationCodeGrantMetadata.getter(ReadAuthorizationCodeGrantMetadata::readAuthorizationCodeGrantCredentialsDetails)).setter(ReadAuthorizationCodeGrantMetadata.setter(Builder::readAuthorizationCodeGrantCredentialsDetails)).constructor(ReadAuthorizationCodeGrantCredentialsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAuthorizationCodeGrantCredentialsDetails").build()}).build();
    private static final SdkField<String> AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationCodeGrantCredentialsSource").getter(ReadAuthorizationCodeGrantMetadata.getter(ReadAuthorizationCodeGrantMetadata::authorizationCodeGrantCredentialsSourceAsString)).setter(ReadAuthorizationCodeGrantMetadata.setter(Builder::authorizationCodeGrantCredentialsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantCredentialsSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD, REDIRECT_URL_FIELD, READ_AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD, AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReadAuthorizationCodeGrantMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String baseEndpoint;
    private final String redirectUrl;
    private final ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails;
    private final String authorizationCodeGrantCredentialsSource;

    private ReadAuthorizationCodeGrantMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.redirectUrl = builder.redirectUrl;
        this.readAuthorizationCodeGrantCredentialsDetails = builder.readAuthorizationCodeGrantCredentialsDetails;
        this.authorizationCodeGrantCredentialsSource = builder.authorizationCodeGrantCredentialsSource;
    }

    public final String baseEndpoint() {
        return this.baseEndpoint;
    }

    public final String redirectUrl() {
        return this.redirectUrl;
    }

    public final ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails() {
        return this.readAuthorizationCodeGrantCredentialsDetails;
    }

    public final AuthorizationCodeGrantCredentialsSource authorizationCodeGrantCredentialsSource() {
        return AuthorizationCodeGrantCredentialsSource.fromValue(this.authorizationCodeGrantCredentialsSource);
    }

    public final String authorizationCodeGrantCredentialsSourceAsString() {
        return this.authorizationCodeGrantCredentialsSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.readAuthorizationCodeGrantCredentialsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCodeGrantCredentialsSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAuthorizationCodeGrantMetadata)) {
            return false;
        }
        ReadAuthorizationCodeGrantMetadata other = (ReadAuthorizationCodeGrantMetadata)obj;
        return Objects.equals(this.baseEndpoint(), other.baseEndpoint()) && Objects.equals(this.redirectUrl(), other.redirectUrl()) && Objects.equals(this.readAuthorizationCodeGrantCredentialsDetails(), other.readAuthorizationCodeGrantCredentialsDetails()) && Objects.equals(this.authorizationCodeGrantCredentialsSourceAsString(), other.authorizationCodeGrantCredentialsSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReadAuthorizationCodeGrantMetadata").add("BaseEndpoint", (Object)this.baseEndpoint()).add("RedirectUrl", (Object)this.redirectUrl()).add("ReadAuthorizationCodeGrantCredentialsDetails", (Object)this.readAuthorizationCodeGrantCredentialsDetails()).add("AuthorizationCodeGrantCredentialsSource", (Object)this.authorizationCodeGrantCredentialsSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseEndpoint": {
                return Optional.ofNullable(clazz.cast(this.baseEndpoint()));
            }
            case "RedirectUrl": {
                return Optional.ofNullable(clazz.cast(this.redirectUrl()));
            }
            case "ReadAuthorizationCodeGrantCredentialsDetails": {
                return Optional.ofNullable(clazz.cast(this.readAuthorizationCodeGrantCredentialsDetails()));
            }
            case "AuthorizationCodeGrantCredentialsSource": {
                return Optional.ofNullable(clazz.cast(this.authorizationCodeGrantCredentialsSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("RedirectUrl", REDIRECT_URL_FIELD);
        map.put("ReadAuthorizationCodeGrantCredentialsDetails", READ_AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD);
        map.put("AuthorizationCodeGrantCredentialsSource", AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAuthorizationCodeGrantMetadata, T> g) {
        return obj -> g.apply((ReadAuthorizationCodeGrantMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseEndpoint;
        private String redirectUrl;
        private ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails;
        private String authorizationCodeGrantCredentialsSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAuthorizationCodeGrantMetadata model) {
            this.baseEndpoint(model.baseEndpoint);
            this.redirectUrl(model.redirectUrl);
            this.readAuthorizationCodeGrantCredentialsDetails(model.readAuthorizationCodeGrantCredentialsDetails);
            this.authorizationCodeGrantCredentialsSource(model.authorizationCodeGrantCredentialsSource);
        }

        public final String getBaseEndpoint() {
            return this.baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getRedirectUrl() {
            return this.redirectUrl;
        }

        public final void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @Override
        public final Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public final ReadAuthorizationCodeGrantCredentialsDetails.Builder getReadAuthorizationCodeGrantCredentialsDetails() {
            return this.readAuthorizationCodeGrantCredentialsDetails != null ? this.readAuthorizationCodeGrantCredentialsDetails.toBuilder() : null;
        }

        public final void setReadAuthorizationCodeGrantCredentialsDetails(ReadAuthorizationCodeGrantCredentialsDetails.BuilderImpl readAuthorizationCodeGrantCredentialsDetails) {
            this.readAuthorizationCodeGrantCredentialsDetails = readAuthorizationCodeGrantCredentialsDetails != null ? readAuthorizationCodeGrantCredentialsDetails.build() : null;
        }

        @Override
        public final Builder readAuthorizationCodeGrantCredentialsDetails(ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails) {
            this.readAuthorizationCodeGrantCredentialsDetails = readAuthorizationCodeGrantCredentialsDetails;
            return this;
        }

        public final String getAuthorizationCodeGrantCredentialsSource() {
            return this.authorizationCodeGrantCredentialsSource;
        }

        public final void setAuthorizationCodeGrantCredentialsSource(String authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource = authorizationCodeGrantCredentialsSource;
        }

        @Override
        public final Builder authorizationCodeGrantCredentialsSource(String authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource = authorizationCodeGrantCredentialsSource;
            return this;
        }

        @Override
        public final Builder authorizationCodeGrantCredentialsSource(AuthorizationCodeGrantCredentialsSource authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource(authorizationCodeGrantCredentialsSource == null ? null : authorizationCodeGrantCredentialsSource.toString());
            return this;
        }

        public ReadAuthorizationCodeGrantMetadata build() {
            return new ReadAuthorizationCodeGrantMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadAuthorizationCodeGrantMetadata> {
        public Builder baseEndpoint(String var1);

        public Builder redirectUrl(String var1);

        public Builder readAuthorizationCodeGrantCredentialsDetails(ReadAuthorizationCodeGrantCredentialsDetails var1);

        default public Builder readAuthorizationCodeGrantCredentialsDetails(Consumer<ReadAuthorizationCodeGrantCredentialsDetails.Builder> readAuthorizationCodeGrantCredentialsDetails) {
            return this.readAuthorizationCodeGrantCredentialsDetails((ReadAuthorizationCodeGrantCredentialsDetails)((ReadAuthorizationCodeGrantCredentialsDetails.Builder)ReadAuthorizationCodeGrantCredentialsDetails.builder().applyMutation(readAuthorizationCodeGrantCredentialsDetails)).build());
        }

        public Builder authorizationCodeGrantCredentialsSource(String var1);

        public Builder authorizationCodeGrantCredentialsSource(AuthorizationCodeGrantCredentialsSource var1);
    }
}

