/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.RefreshFailureAlertStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshFailureEmailAlert
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshFailureEmailAlert> {
    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertStatus").getter(RefreshFailureEmailAlert.getter(RefreshFailureEmailAlert::alertStatusAsString)).setter(RefreshFailureEmailAlert.setter(Builder::alertStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RefreshFailureEmailAlert.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alertStatus;

    private RefreshFailureEmailAlert(BuilderImpl builder) {
        this.alertStatus = builder.alertStatus;
    }

    public final RefreshFailureAlertStatus alertStatus() {
        return RefreshFailureAlertStatus.fromValue(this.alertStatus);
    }

    public final String alertStatusAsString() {
        return this.alertStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alertStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshFailureEmailAlert)) {
            return false;
        }
        RefreshFailureEmailAlert other = (RefreshFailureEmailAlert)obj;
        return Objects.equals(this.alertStatusAsString(), other.alertStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshFailureEmailAlert").add("AlertStatus", (Object)this.alertStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlertStatus": {
                return Optional.ofNullable(clazz.cast(this.alertStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AlertStatus", ALERT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshFailureEmailAlert, T> g) {
        return obj -> g.apply((RefreshFailureEmailAlert)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alertStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshFailureEmailAlert model) {
            this.alertStatus(model.alertStatus);
        }

        public final String getAlertStatus() {
            return this.alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(RefreshFailureAlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public RefreshFailureEmailAlert build() {
            return new RefreshFailureEmailAlert(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshFailureEmailAlert> {
        public Builder alertStatus(String var1);

        public Builder alertStatus(RefreshFailureAlertStatus var1);
    }
}

