/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.ItemsLimitConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SankeyDiagramSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SankeyDiagramSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> WEIGHT_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WeightSort").getter(SankeyDiagramSortConfiguration.getter(SankeyDiagramSortConfiguration::weightSort)).setter(SankeyDiagramSortConfiguration.setter(Builder::weightSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> SOURCE_ITEMS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceItemsLimit").getter(SankeyDiagramSortConfiguration.getter(SankeyDiagramSortConfiguration::sourceItemsLimit)).setter(SankeyDiagramSortConfiguration.setter(Builder::sourceItemsLimit)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceItemsLimit").build()}).build();
    private static final SdkField<ItemsLimitConfiguration> DESTINATION_ITEMS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationItemsLimit").getter(SankeyDiagramSortConfiguration.getter(SankeyDiagramSortConfiguration::destinationItemsLimit)).setter(SankeyDiagramSortConfiguration.setter(Builder::destinationItemsLimit)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationItemsLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEIGHT_SORT_FIELD, SOURCE_ITEMS_LIMIT_FIELD, DESTINATION_ITEMS_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SankeyDiagramSortConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> weightSort;
    private final ItemsLimitConfiguration sourceItemsLimit;
    private final ItemsLimitConfiguration destinationItemsLimit;

    private SankeyDiagramSortConfiguration(BuilderImpl builder) {
        this.weightSort = builder.weightSort;
        this.sourceItemsLimit = builder.sourceItemsLimit;
        this.destinationItemsLimit = builder.destinationItemsLimit;
    }

    public final boolean hasWeightSort() {
        return this.weightSort != null && !(this.weightSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> weightSort() {
        return this.weightSort;
    }

    public final ItemsLimitConfiguration sourceItemsLimit() {
        return this.sourceItemsLimit;
    }

    public final ItemsLimitConfiguration destinationItemsLimit() {
        return this.destinationItemsLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWeightSort() ? this.weightSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceItemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationItemsLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SankeyDiagramSortConfiguration)) {
            return false;
        }
        SankeyDiagramSortConfiguration other = (SankeyDiagramSortConfiguration)obj;
        return this.hasWeightSort() == other.hasWeightSort() && Objects.equals(this.weightSort(), other.weightSort()) && Objects.equals(this.sourceItemsLimit(), other.sourceItemsLimit()) && Objects.equals(this.destinationItemsLimit(), other.destinationItemsLimit());
    }

    public final String toString() {
        return ToString.builder((String)"SankeyDiagramSortConfiguration").add("WeightSort", this.hasWeightSort() ? this.weightSort() : null).add("SourceItemsLimit", (Object)this.sourceItemsLimit()).add("DestinationItemsLimit", (Object)this.destinationItemsLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WeightSort": {
                return Optional.ofNullable(clazz.cast(this.weightSort()));
            }
            case "SourceItemsLimit": {
                return Optional.ofNullable(clazz.cast(this.sourceItemsLimit()));
            }
            case "DestinationItemsLimit": {
                return Optional.ofNullable(clazz.cast(this.destinationItemsLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WeightSort", WEIGHT_SORT_FIELD);
        map.put("SourceItemsLimit", SOURCE_ITEMS_LIMIT_FIELD);
        map.put("DestinationItemsLimit", DESTINATION_ITEMS_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SankeyDiagramSortConfiguration, T> g) {
        return obj -> g.apply((SankeyDiagramSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> weightSort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration sourceItemsLimit;
        private ItemsLimitConfiguration destinationItemsLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(SankeyDiagramSortConfiguration model) {
            this.weightSort(model.weightSort);
            this.sourceItemsLimit(model.sourceItemsLimit);
            this.destinationItemsLimit(model.destinationItemsLimit);
        }

        public final List<FieldSortOptions.Builder> getWeightSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.weightSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWeightSort(Collection<FieldSortOptions.BuilderImpl> weightSort) {
            this.weightSort = FieldSortOptionsListCopier.copyFromBuilder(weightSort);
        }

        @Override
        public final Builder weightSort(Collection<FieldSortOptions> weightSort) {
            this.weightSort = FieldSortOptionsListCopier.copy(weightSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightSort(FieldSortOptions ... weightSort) {
            this.weightSort(Arrays.asList(weightSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightSort(Consumer<FieldSortOptions.Builder> ... weightSort) {
            this.weightSort(Stream.of(weightSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getSourceItemsLimit() {
            return this.sourceItemsLimit != null ? this.sourceItemsLimit.toBuilder() : null;
        }

        public final void setSourceItemsLimit(ItemsLimitConfiguration.BuilderImpl sourceItemsLimit) {
            this.sourceItemsLimit = sourceItemsLimit != null ? sourceItemsLimit.build() : null;
        }

        @Override
        public final Builder sourceItemsLimit(ItemsLimitConfiguration sourceItemsLimit) {
            this.sourceItemsLimit = sourceItemsLimit;
            return this;
        }

        public final ItemsLimitConfiguration.Builder getDestinationItemsLimit() {
            return this.destinationItemsLimit != null ? this.destinationItemsLimit.toBuilder() : null;
        }

        public final void setDestinationItemsLimit(ItemsLimitConfiguration.BuilderImpl destinationItemsLimit) {
            this.destinationItemsLimit = destinationItemsLimit != null ? destinationItemsLimit.build() : null;
        }

        @Override
        public final Builder destinationItemsLimit(ItemsLimitConfiguration destinationItemsLimit) {
            this.destinationItemsLimit = destinationItemsLimit;
            return this;
        }

        public SankeyDiagramSortConfiguration build() {
            return new SankeyDiagramSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SankeyDiagramSortConfiguration> {
        public Builder weightSort(Collection<FieldSortOptions> var1);

        public Builder weightSort(FieldSortOptions ... var1);

        public Builder weightSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder sourceItemsLimit(ItemsLimitConfiguration var1);

        default public Builder sourceItemsLimit(Consumer<ItemsLimitConfiguration.Builder> sourceItemsLimit) {
            return this.sourceItemsLimit((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(sourceItemsLimit)).build());
        }

        public Builder destinationItemsLimit(ItemsLimitConfiguration var1);

        default public Builder destinationItemsLimit(Consumer<ItemsLimitConfiguration.Builder> destinationItemsLimit) {
            return this.destinationItemsLimit((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(destinationItemsLimit)).build());
        }
    }
}

