/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataColorPalette;
import software.amazon.awssdk.services.quicksight.model.SheetStyle;
import software.amazon.awssdk.services.quicksight.model.Typography;
import software.amazon.awssdk.services.quicksight.model.UIColorPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThemeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThemeConfiguration> {
    private static final SdkField<DataColorPalette> DATA_COLOR_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataColorPalette").getter(ThemeConfiguration.getter(ThemeConfiguration::dataColorPalette)).setter(ThemeConfiguration.setter(Builder::dataColorPalette)).constructor(DataColorPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataColorPalette").build()}).build();
    private static final SdkField<UIColorPalette> UI_COLOR_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UIColorPalette").getter(ThemeConfiguration.getter(ThemeConfiguration::uiColorPalette)).setter(ThemeConfiguration.setter(Builder::uiColorPalette)).constructor(UIColorPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UIColorPalette").build()}).build();
    private static final SdkField<SheetStyle> SHEET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sheet").getter(ThemeConfiguration.getter(ThemeConfiguration::sheet)).setter(ThemeConfiguration.setter(Builder::sheet)).constructor(SheetStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheet").build()}).build();
    private static final SdkField<Typography> TYPOGRAPHY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Typography").getter(ThemeConfiguration.getter(ThemeConfiguration::typography)).setter(ThemeConfiguration.setter(Builder::typography)).constructor(Typography::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Typography").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_COLOR_PALETTE_FIELD, UI_COLOR_PALETTE_FIELD, SHEET_FIELD, TYPOGRAPHY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ThemeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataColorPalette dataColorPalette;
    private final UIColorPalette uiColorPalette;
    private final SheetStyle sheet;
    private final Typography typography;

    private ThemeConfiguration(BuilderImpl builder) {
        this.dataColorPalette = builder.dataColorPalette;
        this.uiColorPalette = builder.uiColorPalette;
        this.sheet = builder.sheet;
        this.typography = builder.typography;
    }

    public final DataColorPalette dataColorPalette() {
        return this.dataColorPalette;
    }

    public final UIColorPalette uiColorPalette() {
        return this.uiColorPalette;
    }

    public final SheetStyle sheet() {
        return this.sheet;
    }

    public final Typography typography() {
        return this.typography;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataColorPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.uiColorPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.sheet());
        hashCode = 31 * hashCode + Objects.hashCode(this.typography());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeConfiguration)) {
            return false;
        }
        ThemeConfiguration other = (ThemeConfiguration)obj;
        return Objects.equals(this.dataColorPalette(), other.dataColorPalette()) && Objects.equals(this.uiColorPalette(), other.uiColorPalette()) && Objects.equals(this.sheet(), other.sheet()) && Objects.equals(this.typography(), other.typography());
    }

    public final String toString() {
        return ToString.builder((String)"ThemeConfiguration").add("DataColorPalette", (Object)this.dataColorPalette()).add("UIColorPalette", (Object)this.uiColorPalette()).add("Sheet", (Object)this.sheet()).add("Typography", (Object)this.typography()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataColorPalette": {
                return Optional.ofNullable(clazz.cast(this.dataColorPalette()));
            }
            case "UIColorPalette": {
                return Optional.ofNullable(clazz.cast(this.uiColorPalette()));
            }
            case "Sheet": {
                return Optional.ofNullable(clazz.cast(this.sheet()));
            }
            case "Typography": {
                return Optional.ofNullable(clazz.cast(this.typography()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataColorPalette", DATA_COLOR_PALETTE_FIELD);
        map.put("UIColorPalette", UI_COLOR_PALETTE_FIELD);
        map.put("Sheet", SHEET_FIELD);
        map.put("Typography", TYPOGRAPHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThemeConfiguration, T> g) {
        return obj -> g.apply((ThemeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataColorPalette dataColorPalette;
        private UIColorPalette uiColorPalette;
        private SheetStyle sheet;
        private Typography typography;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeConfiguration model) {
            this.dataColorPalette(model.dataColorPalette);
            this.uiColorPalette(model.uiColorPalette);
            this.sheet(model.sheet);
            this.typography(model.typography);
        }

        public final DataColorPalette.Builder getDataColorPalette() {
            return this.dataColorPalette != null ? this.dataColorPalette.toBuilder() : null;
        }

        public final void setDataColorPalette(DataColorPalette.BuilderImpl dataColorPalette) {
            this.dataColorPalette = dataColorPalette != null ? dataColorPalette.build() : null;
        }

        @Override
        public final Builder dataColorPalette(DataColorPalette dataColorPalette) {
            this.dataColorPalette = dataColorPalette;
            return this;
        }

        public final UIColorPalette.Builder getUiColorPalette() {
            return this.uiColorPalette != null ? this.uiColorPalette.toBuilder() : null;
        }

        public final void setUiColorPalette(UIColorPalette.BuilderImpl uiColorPalette) {
            this.uiColorPalette = uiColorPalette != null ? uiColorPalette.build() : null;
        }

        @Override
        public final Builder uiColorPalette(UIColorPalette uiColorPalette) {
            this.uiColorPalette = uiColorPalette;
            return this;
        }

        public final SheetStyle.Builder getSheet() {
            return this.sheet != null ? this.sheet.toBuilder() : null;
        }

        public final void setSheet(SheetStyle.BuilderImpl sheet) {
            this.sheet = sheet != null ? sheet.build() : null;
        }

        @Override
        public final Builder sheet(SheetStyle sheet) {
            this.sheet = sheet;
            return this;
        }

        public final Typography.Builder getTypography() {
            return this.typography != null ? this.typography.toBuilder() : null;
        }

        public final void setTypography(Typography.BuilderImpl typography) {
            this.typography = typography != null ? typography.build() : null;
        }

        @Override
        public final Builder typography(Typography typography) {
            this.typography = typography;
            return this;
        }

        public ThemeConfiguration build() {
            return new ThemeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThemeConfiguration> {
        public Builder dataColorPalette(DataColorPalette var1);

        default public Builder dataColorPalette(Consumer<DataColorPalette.Builder> dataColorPalette) {
            return this.dataColorPalette((DataColorPalette)((DataColorPalette.Builder)DataColorPalette.builder().applyMutation(dataColorPalette)).build());
        }

        public Builder uiColorPalette(UIColorPalette var1);

        default public Builder uiColorPalette(Consumer<UIColorPalette.Builder> uiColorPalette) {
            return this.uiColorPalette((UIColorPalette)((UIColorPalette.Builder)UIColorPalette.builder().applyMutation(uiColorPalette)).build());
        }

        public Builder sheet(SheetStyle var1);

        default public Builder sheet(Consumer<SheetStyle.Builder> sheet) {
            return this.sheet((SheetStyle)((SheetStyle.Builder)SheetStyle.builder().applyMutation(sheet)).build());
        }

        public Builder typography(Typography var1);

        default public Builder typography(Consumer<Typography.Builder> typography) {
            return this.typography((Typography)((Typography.Builder)Typography.builder().applyMutation(typography)).build());
        }
    }
}

