/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BorderStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TileStyle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TileStyle> {
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(TileStyle.getter(TileStyle::backgroundColor)).setter(TileStyle.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()}).build();
    private static final SdkField<BorderStyle> BORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Border").getter(TileStyle.getter(TileStyle::border)).setter(TileStyle.setter(Builder::border)).constructor(BorderStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Border").build()}).build();
    private static final SdkField<String> BORDER_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BorderRadius").getter(TileStyle.getter(TileStyle::borderRadius)).setter(TileStyle.setter(Builder::borderRadius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderRadius").build()}).build();
    private static final SdkField<String> PADDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Padding").getter(TileStyle.getter(TileStyle::padding)).setter(TileStyle.setter(Builder::padding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Padding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKGROUND_COLOR_FIELD, BORDER_FIELD, BORDER_RADIUS_FIELD, PADDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TileStyle.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backgroundColor;
    private final BorderStyle border;
    private final String borderRadius;
    private final String padding;

    private TileStyle(BuilderImpl builder) {
        this.backgroundColor = builder.backgroundColor;
        this.border = builder.border;
        this.borderRadius = builder.borderRadius;
        this.padding = builder.padding;
    }

    public final String backgroundColor() {
        return this.backgroundColor;
    }

    public final BorderStyle border() {
        return this.border;
    }

    public final String borderRadius() {
        return this.borderRadius;
    }

    public final String padding() {
        return this.padding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.border());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderRadius());
        hashCode = 31 * hashCode + Objects.hashCode(this.padding());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TileStyle)) {
            return false;
        }
        TileStyle other = (TileStyle)obj;
        return Objects.equals(this.backgroundColor(), other.backgroundColor()) && Objects.equals(this.border(), other.border()) && Objects.equals(this.borderRadius(), other.borderRadius()) && Objects.equals(this.padding(), other.padding());
    }

    public final String toString() {
        return ToString.builder((String)"TileStyle").add("BackgroundColor", (Object)this.backgroundColor()).add("Border", (Object)this.border()).add("BorderRadius", (Object)this.borderRadius()).add("Padding", (Object)this.padding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColor()));
            }
            case "Border": {
                return Optional.ofNullable(clazz.cast(this.border()));
            }
            case "BorderRadius": {
                return Optional.ofNullable(clazz.cast(this.borderRadius()));
            }
            case "Padding": {
                return Optional.ofNullable(clazz.cast(this.padding()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("Border", BORDER_FIELD);
        map.put("BorderRadius", BORDER_RADIUS_FIELD);
        map.put("Padding", PADDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TileStyle, T> g) {
        return obj -> g.apply((TileStyle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backgroundColor;
        private BorderStyle border;
        private String borderRadius;
        private String padding;

        private BuilderImpl() {
        }

        private BuilderImpl(TileStyle model) {
            this.backgroundColor(model.backgroundColor);
            this.border(model.border);
            this.borderRadius(model.borderRadius);
            this.padding(model.padding);
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final BorderStyle.Builder getBorder() {
            return this.border != null ? this.border.toBuilder() : null;
        }

        public final void setBorder(BorderStyle.BuilderImpl border) {
            this.border = border != null ? border.build() : null;
        }

        @Override
        public final Builder border(BorderStyle border) {
            this.border = border;
            return this;
        }

        public final String getBorderRadius() {
            return this.borderRadius;
        }

        public final void setBorderRadius(String borderRadius) {
            this.borderRadius = borderRadius;
        }

        @Override
        public final Builder borderRadius(String borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        public final String getPadding() {
            return this.padding;
        }

        public final void setPadding(String padding) {
            this.padding = padding;
        }

        @Override
        public final Builder padding(String padding) {
            this.padding = padding;
            return this;
        }

        public TileStyle build() {
            return new TileStyle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TileStyle> {
        public Builder backgroundColor(String var1);

        public Builder border(BorderStyle var1);

        default public Builder border(Consumer<BorderStyle.Builder> border) {
            return this.border((BorderStyle)((BorderStyle.Builder)BorderStyle.builder().applyMutation(border)).build());
        }

        public Builder borderRadius(String var1);

        public Builder padding(String var1);
    }
}

