/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnToUnpivot;
import software.amazon.awssdk.services.quicksight.model.ColumnToUnpivotListCopier;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnpivotOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnpivotOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(UnpivotOperation.getter(UnpivotOperation::alias)).setter(UnpivotOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(UnpivotOperation.getter(UnpivotOperation::source)).setter(UnpivotOperation.setter(Builder::source)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<ColumnToUnpivot>> COLUMNS_TO_UNPIVOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnsToUnpivot").getter(UnpivotOperation.getter(UnpivotOperation::columnsToUnpivot)).setter(UnpivotOperation.setter(Builder::columnsToUnpivot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnsToUnpivot").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnToUnpivot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNPIVOTED_LABEL_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnpivotedLabelColumnName").getter(UnpivotOperation.getter(UnpivotOperation::unpivotedLabelColumnName)).setter(UnpivotOperation.setter(Builder::unpivotedLabelColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedLabelColumnName").build()}).build();
    private static final SdkField<String> UNPIVOTED_LABEL_COLUMN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnpivotedLabelColumnId").getter(UnpivotOperation.getter(UnpivotOperation::unpivotedLabelColumnId)).setter(UnpivotOperation.setter(Builder::unpivotedLabelColumnId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedLabelColumnId").build()}).build();
    private static final SdkField<String> UNPIVOTED_VALUE_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnpivotedValueColumnName").getter(UnpivotOperation.getter(UnpivotOperation::unpivotedValueColumnName)).setter(UnpivotOperation.setter(Builder::unpivotedValueColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedValueColumnName").build()}).build();
    private static final SdkField<String> UNPIVOTED_VALUE_COLUMN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnpivotedValueColumnId").getter(UnpivotOperation.getter(UnpivotOperation::unpivotedValueColumnId)).setter(UnpivotOperation.setter(Builder::unpivotedValueColumnId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedValueColumnId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD, COLUMNS_TO_UNPIVOT_FIELD, UNPIVOTED_LABEL_COLUMN_NAME_FIELD, UNPIVOTED_LABEL_COLUMN_ID_FIELD, UNPIVOTED_VALUE_COLUMN_NAME_FIELD, UNPIVOTED_VALUE_COLUMN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnpivotOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource source;
    private final List<ColumnToUnpivot> columnsToUnpivot;
    private final String unpivotedLabelColumnName;
    private final String unpivotedLabelColumnId;
    private final String unpivotedValueColumnName;
    private final String unpivotedValueColumnId;

    private UnpivotOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.columnsToUnpivot = builder.columnsToUnpivot;
        this.unpivotedLabelColumnName = builder.unpivotedLabelColumnName;
        this.unpivotedLabelColumnId = builder.unpivotedLabelColumnId;
        this.unpivotedValueColumnName = builder.unpivotedValueColumnName;
        this.unpivotedValueColumnId = builder.unpivotedValueColumnId;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource source() {
        return this.source;
    }

    public final boolean hasColumnsToUnpivot() {
        return this.columnsToUnpivot != null && !(this.columnsToUnpivot instanceof SdkAutoConstructList);
    }

    public final List<ColumnToUnpivot> columnsToUnpivot() {
        return this.columnsToUnpivot;
    }

    public final String unpivotedLabelColumnName() {
        return this.unpivotedLabelColumnName;
    }

    public final String unpivotedLabelColumnId() {
        return this.unpivotedLabelColumnId;
    }

    public final String unpivotedValueColumnName() {
        return this.unpivotedValueColumnName;
    }

    public final String unpivotedValueColumnId() {
        return this.unpivotedValueColumnId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnsToUnpivot() ? this.columnsToUnpivot() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unpivotedLabelColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.unpivotedLabelColumnId());
        hashCode = 31 * hashCode + Objects.hashCode(this.unpivotedValueColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.unpivotedValueColumnId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnpivotOperation)) {
            return false;
        }
        UnpivotOperation other = (UnpivotOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.source(), other.source()) && this.hasColumnsToUnpivot() == other.hasColumnsToUnpivot() && Objects.equals(this.columnsToUnpivot(), other.columnsToUnpivot()) && Objects.equals(this.unpivotedLabelColumnName(), other.unpivotedLabelColumnName()) && Objects.equals(this.unpivotedLabelColumnId(), other.unpivotedLabelColumnId()) && Objects.equals(this.unpivotedValueColumnName(), other.unpivotedValueColumnName()) && Objects.equals(this.unpivotedValueColumnId(), other.unpivotedValueColumnId());
    }

    public final String toString() {
        return ToString.builder((String)"UnpivotOperation").add("Alias", (Object)this.alias()).add("Source", (Object)this.source()).add("ColumnsToUnpivot", this.hasColumnsToUnpivot() ? this.columnsToUnpivot() : null).add("UnpivotedLabelColumnName", (Object)this.unpivotedLabelColumnName()).add("UnpivotedLabelColumnId", (Object)this.unpivotedLabelColumnId()).add("UnpivotedValueColumnName", (Object)this.unpivotedValueColumnName()).add("UnpivotedValueColumnId", (Object)this.unpivotedValueColumnId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ColumnsToUnpivot": {
                return Optional.ofNullable(clazz.cast(this.columnsToUnpivot()));
            }
            case "UnpivotedLabelColumnName": {
                return Optional.ofNullable(clazz.cast(this.unpivotedLabelColumnName()));
            }
            case "UnpivotedLabelColumnId": {
                return Optional.ofNullable(clazz.cast(this.unpivotedLabelColumnId()));
            }
            case "UnpivotedValueColumnName": {
                return Optional.ofNullable(clazz.cast(this.unpivotedValueColumnName()));
            }
            case "UnpivotedValueColumnId": {
                return Optional.ofNullable(clazz.cast(this.unpivotedValueColumnId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("ColumnsToUnpivot", COLUMNS_TO_UNPIVOT_FIELD);
        map.put("UnpivotedLabelColumnName", UNPIVOTED_LABEL_COLUMN_NAME_FIELD);
        map.put("UnpivotedLabelColumnId", UNPIVOTED_LABEL_COLUMN_ID_FIELD);
        map.put("UnpivotedValueColumnName", UNPIVOTED_VALUE_COLUMN_NAME_FIELD);
        map.put("UnpivotedValueColumnId", UNPIVOTED_VALUE_COLUMN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnpivotOperation, T> g) {
        return obj -> g.apply((UnpivotOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource source;
        private List<ColumnToUnpivot> columnsToUnpivot = DefaultSdkAutoConstructList.getInstance();
        private String unpivotedLabelColumnName;
        private String unpivotedLabelColumnId;
        private String unpivotedValueColumnName;
        private String unpivotedValueColumnId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnpivotOperation model) {
            this.alias(model.alias);
            this.source(model.source);
            this.columnsToUnpivot(model.columnsToUnpivot);
            this.unpivotedLabelColumnName(model.unpivotedLabelColumnName);
            this.unpivotedLabelColumnId(model.unpivotedLabelColumnId);
            this.unpivotedValueColumnName(model.unpivotedValueColumnName);
            this.unpivotedValueColumnId(model.unpivotedValueColumnId);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final List<ColumnToUnpivot.Builder> getColumnsToUnpivot() {
            List<ColumnToUnpivot.Builder> result = ColumnToUnpivotListCopier.copyToBuilder(this.columnsToUnpivot);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnsToUnpivot(Collection<ColumnToUnpivot.BuilderImpl> columnsToUnpivot) {
            this.columnsToUnpivot = ColumnToUnpivotListCopier.copyFromBuilder(columnsToUnpivot);
        }

        @Override
        public final Builder columnsToUnpivot(Collection<ColumnToUnpivot> columnsToUnpivot) {
            this.columnsToUnpivot = ColumnToUnpivotListCopier.copy(columnsToUnpivot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnsToUnpivot(ColumnToUnpivot ... columnsToUnpivot) {
            this.columnsToUnpivot(Arrays.asList(columnsToUnpivot));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnsToUnpivot(Consumer<ColumnToUnpivot.Builder> ... columnsToUnpivot) {
            this.columnsToUnpivot(Stream.of(columnsToUnpivot).map(c -> (ColumnToUnpivot)((ColumnToUnpivot.Builder)ColumnToUnpivot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUnpivotedLabelColumnName() {
            return this.unpivotedLabelColumnName;
        }

        public final void setUnpivotedLabelColumnName(String unpivotedLabelColumnName) {
            this.unpivotedLabelColumnName = unpivotedLabelColumnName;
        }

        @Override
        public final Builder unpivotedLabelColumnName(String unpivotedLabelColumnName) {
            this.unpivotedLabelColumnName = unpivotedLabelColumnName;
            return this;
        }

        public final String getUnpivotedLabelColumnId() {
            return this.unpivotedLabelColumnId;
        }

        public final void setUnpivotedLabelColumnId(String unpivotedLabelColumnId) {
            this.unpivotedLabelColumnId = unpivotedLabelColumnId;
        }

        @Override
        public final Builder unpivotedLabelColumnId(String unpivotedLabelColumnId) {
            this.unpivotedLabelColumnId = unpivotedLabelColumnId;
            return this;
        }

        public final String getUnpivotedValueColumnName() {
            return this.unpivotedValueColumnName;
        }

        public final void setUnpivotedValueColumnName(String unpivotedValueColumnName) {
            this.unpivotedValueColumnName = unpivotedValueColumnName;
        }

        @Override
        public final Builder unpivotedValueColumnName(String unpivotedValueColumnName) {
            this.unpivotedValueColumnName = unpivotedValueColumnName;
            return this;
        }

        public final String getUnpivotedValueColumnId() {
            return this.unpivotedValueColumnId;
        }

        public final void setUnpivotedValueColumnId(String unpivotedValueColumnId) {
            this.unpivotedValueColumnId = unpivotedValueColumnId;
        }

        @Override
        public final Builder unpivotedValueColumnId(String unpivotedValueColumnId) {
            this.unpivotedValueColumnId = unpivotedValueColumnId;
            return this;
        }

        public UnpivotOperation build() {
            return new UnpivotOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnpivotOperation> {
        public Builder alias(String var1);

        public Builder source(TransformOperationSource var1);

        default public Builder source(Consumer<TransformOperationSource.Builder> source) {
            return this.source((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(source)).build());
        }

        public Builder columnsToUnpivot(Collection<ColumnToUnpivot> var1);

        public Builder columnsToUnpivot(ColumnToUnpivot ... var1);

        public Builder columnsToUnpivot(Consumer<ColumnToUnpivot.Builder> ... var1);

        public Builder unpivotedLabelColumnName(String var1);

        public Builder unpivotedLabelColumnId(String var1);

        public Builder unpivotedValueColumnName(String var1);

        public Builder unpivotedValueColumnId(String var1);
    }
}

