/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Visual;

final class VisualListCopier {
    VisualListCopier() {
    }

    static List<Visual> copy(Collection<? extends Visual> visualListParam) {
        Object list;
        if (visualListParam == null || visualListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(visualListParam.size());
            visualListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Visual> copyFromBuilder(Collection<? extends Visual.Builder> visualListParam) {
        Object list;
        if (visualListParam == null || visualListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(visualListParam.size());
            visualListParam.forEach(entry -> {
                Visual member = entry == null ? null : (Visual)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Visual.Builder> copyToBuilder(Collection<? extends Visual> visualListParam) {
        Object list;
        if (visualListParam == null || visualListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(visualListParam.size());
            visualListParam.forEach(entry -> {
                Visual.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

