/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsResponse;

public class ListRoleMembershipsPublisher
implements SdkPublisher<ListRoleMembershipsResponse> {
    private final QuickSightAsyncClient client;
    private final ListRoleMembershipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoleMembershipsPublisher(QuickSightAsyncClient client, ListRoleMembershipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoleMembershipsPublisher(QuickSightAsyncClient client, ListRoleMembershipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoleMembershipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoleMembershipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> membersList() {
        Function<ListRoleMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.membersList() != null) {
                return response.membersList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoleMembershipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoleMembershipsResponseFetcher
    implements AsyncPageFetcher<ListRoleMembershipsResponse> {
        private ListRoleMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoleMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoleMembershipsResponse> nextPage(ListRoleMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListRoleMembershipsPublisher.this.client.listRoleMemberships(ListRoleMembershipsPublisher.this.firstRequest);
            }
            return ListRoleMembershipsPublisher.this.client.listRoleMemberships((ListRoleMembershipsRequest)((Object)ListRoleMembershipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

