/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary;
import software.amazon.awssdk.services.quicksight.model.SearchActionConnectorsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchActionConnectorsResponse;

public class SearchActionConnectorsIterable
implements SdkIterable<SearchActionConnectorsResponse> {
    private final QuickSightClient client;
    private final SearchActionConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchActionConnectorsIterable(QuickSightClient client, SearchActionConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchActionConnectorsResponseFetcher();
    }

    public Iterator<SearchActionConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionConnectorSummary> actionConnectorSummaries() {
        Function<SearchActionConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionConnectorSummaries() != null) {
                return response.actionConnectorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchActionConnectorsResponseFetcher
    implements SyncPageFetcher<SearchActionConnectorsResponse> {
        private SearchActionConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(SearchActionConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchActionConnectorsResponse nextPage(SearchActionConnectorsResponse previousPage) {
            if (previousPage == null) {
                return SearchActionConnectorsIterable.this.client.searchActionConnectors(SearchActionConnectorsIterable.this.firstRequest);
            }
            return SearchActionConnectorsIterable.this.client.searchActionConnectors((SearchActionConnectorsRequest)((Object)SearchActionConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

