/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.ResourceRegionScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNameAndResourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNameAndResourceType> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ServiceNameAndResourceType.getter(ServiceNameAndResourceType::resourceType)).setter(ServiceNameAndResourceType.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(ServiceNameAndResourceType.getter(ServiceNameAndResourceType::serviceName)).setter(ServiceNameAndResourceType.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceRegionScope").getter(ServiceNameAndResourceType.getter(ServiceNameAndResourceType::resourceRegionScopeAsString)).setter(ServiceNameAndResourceType.setter(Builder::resourceRegionScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRegionScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, SERVICE_NAME_FIELD, RESOURCE_REGION_SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String serviceName;
    private final String resourceRegionScope;

    private ServiceNameAndResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.serviceName = builder.serviceName;
        this.resourceRegionScope = builder.resourceRegionScope;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final ResourceRegionScope resourceRegionScope() {
        return ResourceRegionScope.fromValue(this.resourceRegionScope);
    }

    public final String resourceRegionScopeAsString() {
        return this.resourceRegionScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegionScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNameAndResourceType)) {
            return false;
        }
        ServiceNameAndResourceType other = (ServiceNameAndResourceType)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.resourceRegionScopeAsString(), other.resourceRegionScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceNameAndResourceType").add("ResourceType", (Object)this.resourceType()).add("ServiceName", (Object)this.serviceName()).add("ResourceRegionScope", (Object)this.resourceRegionScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "resourceRegionScope": {
                return Optional.ofNullable(clazz.cast(this.resourceRegionScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNameAndResourceType, T> g) {
        return obj -> g.apply((ServiceNameAndResourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String serviceName;
        private String resourceRegionScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNameAndResourceType model) {
            this.resourceType(model.resourceType);
            this.serviceName(model.serviceName);
            this.resourceRegionScope(model.resourceRegionScope);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getResourceRegionScope() {
            return this.resourceRegionScope;
        }

        public final void setResourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
        }

        @Override
        public final Builder resourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
            return this;
        }

        @Override
        public final Builder resourceRegionScope(ResourceRegionScope resourceRegionScope) {
            this.resourceRegionScope(resourceRegionScope == null ? null : resourceRegionScope.toString());
            return this;
        }

        public ServiceNameAndResourceType build() {
            return new ServiceNameAndResourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNameAndResourceType> {
        public Builder resourceType(String var1);

        public Builder serviceName(String var1);

        public Builder resourceRegionScope(String var1);

        public Builder resourceRegionScope(ResourceRegionScope var1);
    }
}

