/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.internal.UserAgentUtils;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;

public class GetResourceShareInvitationsPublisher
implements SdkPublisher<GetResourceShareInvitationsResponse> {
    private final RamAsyncClient client;
    private final GetResourceShareInvitationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourceShareInvitationsPublisher(RamAsyncClient client, GetResourceShareInvitationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourceShareInvitationsPublisher(RamAsyncClient client, GetResourceShareInvitationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourceShareInvitationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourceShareInvitationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetResourceShareInvitationsResponseFetcher
    implements AsyncPageFetcher<GetResourceShareInvitationsResponse> {
        private GetResourceShareInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceShareInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourceShareInvitationsResponse> nextPage(GetResourceShareInvitationsResponse previousPage) {
            if (previousPage == null) {
                return GetResourceShareInvitationsPublisher.this.client.getResourceShareInvitations(GetResourceShareInvitationsPublisher.this.firstRequest);
            }
            return GetResourceShareInvitationsPublisher.this.client.getResourceShareInvitations((GetResourceShareInvitationsRequest)((Object)GetResourceShareInvitationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

