/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceShareAssociationType {
    PRINCIPAL("PRINCIPAL"),
    RESOURCE("RESOURCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceShareAssociationType> VALUE_MAP;
    private final String value;

    private ResourceShareAssociationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceShareAssociationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceShareAssociationType> knownValues() {
        EnumSet<ResourceShareAssociationType> knownValues = EnumSet.allOf(ResourceShareAssociationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceShareAssociationType.class, ResourceShareAssociationType::toString);
    }
}

