/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.rds.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.rds.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentNotFoundException;
import software.amazon.awssdk.services.rds.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.rds.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.rds.model.CertificateNotFoundException;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionException;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CustomAvailabilityZoneNotFoundException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionNotFoundException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterAutomatedBackupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterAutomatedBackupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterBacktrackNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbInstanceAutomatedBackupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceAutomatedBackupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbLogFileNotFoundException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetAlreadyRegisteredException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupNotSupportedException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupNotAllowedException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventsResponse;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.rds.model.DomainNotFoundException;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse;
import software.amazon.awssdk.services.rds.model.Ec2ImagePropertiesNotSupportedException;
import software.amazon.awssdk.services.rds.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.rds.model.ExportTaskAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.ExportTaskNotFoundException;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.GlobalClusterAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.GlobalClusterNotFoundException;
import software.amazon.awssdk.services.rds.model.GlobalClusterQuotaExceededException;
import software.amazon.awssdk.services.rds.model.IamRoleMissingPermissionsException;
import software.amazon.awssdk.services.rds.model.IamRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.rds.model.InsufficientAvailableIPsInSubnetException;
import software.amazon.awssdk.services.rds.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.rds.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InvalidBlueGreenDeploymentStateException;
import software.amazon.awssdk.services.rds.model.InvalidCustomDbEngineVersionStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterAutomatedBackupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterEndpointStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbInstanceAutomatedBackupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbProxyEndpointStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbProxyStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetGroupException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.rds.model.InvalidEventSubscriptionStateException;
import software.amazon.awssdk.services.rds.model.InvalidExportOnlyException;
import software.amazon.awssdk.services.rds.model.InvalidExportSourceStateException;
import software.amazon.awssdk.services.rds.model.InvalidExportTaskStateException;
import software.amazon.awssdk.services.rds.model.InvalidGlobalClusterStateException;
import software.amazon.awssdk.services.rds.model.InvalidOptionGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidRestoreException;
import software.amazon.awssdk.services.rds.model.InvalidS3BucketException;
import software.amazon.awssdk.services.rds.model.InvalidSubnetException;
import software.amazon.awssdk.services.rds.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.rds.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.NetworkTypeNotSupportedException;
import software.amazon.awssdk.services.rds.model.OptionGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.OptionGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.OptionGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.PointInTimeRestoreNotEnabledException;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.ProvisionedIopsNotAvailableInAzException;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse;
import software.amazon.awssdk.services.rds.model.RdsException;
import software.amazon.awssdk.services.rds.model.RebootDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RebootDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceNotFoundException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceQuotaExceededException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstancesOfferingNotFoundException;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.rds.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.rds.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.rds.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.rds.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.rds.model.SourceClusterNotSupportedException;
import software.amazon.awssdk.services.rds.model.SourceDatabaseNotSupportedException;
import software.amazon.awssdk.services.rds.model.SourceNotFoundException;
import software.amazon.awssdk.services.rds.model.StartActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StartActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StartDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StartDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.StartExportTaskRequest;
import software.amazon.awssdk.services.rds.model.StartExportTaskResponse;
import software.amazon.awssdk.services.rds.model.StopActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StopActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StopDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StopDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.rds.model.StorageTypeNotAvailableException;
import software.amazon.awssdk.services.rds.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.rds.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.rds.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.rds.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.rds.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse;
import software.amazon.awssdk.services.rds.transform.AddRoleToDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AddRoleToDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AddSourceIdentifierToSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.AuthorizeDbSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.BacktrackDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CopyOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateBlueGreenDeploymentRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateCustomDbEngineVersionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbInstanceReadReplicaRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbProxyEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbProxyRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.CreateOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteBlueGreenDeploymentRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteCustomDbEngineVersionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterAutomatedBackupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbInstanceAutomatedBackupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbProxyEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbProxyRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeleteOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DeregisterDbProxyTargetsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeBlueGreenDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterAutomatedBackupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterBacktracksRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterEndpointsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbInstanceAutomatedBackupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbLogFilesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxiesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxyEndpointsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxyTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbProxyTargetsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeGlobalClustersRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeOptionGroupOptionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeOptionGroupsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeReservedDbInstancesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeReservedDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeSourceRegionsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DescribeValidDbInstanceModificationsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.DownloadDbLogFilePortionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.FailoverGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyActivityStreamRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyCertificatesRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyCurrentDbClusterCapacityRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyCustomDbEngineVersionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbProxyEndpointRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbProxyRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbProxyTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ModifyOptionGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.PromoteReadReplicaDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.PromoteReadReplicaRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.PurchaseReservedDbInstancesOfferingRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RebootDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RegisterDbProxyTargetsRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveFromGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveRoleFromDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveRoleFromDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveSourceIdentifierFromSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.ResetDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbClusterFromS3RequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbInstanceFromDbSnapshotRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbInstanceFromS3RequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RestoreDbInstanceToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.RevokeDbSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartActivityStreamRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartDbInstanceAutomatedBackupsReplicationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StartExportTaskRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopActivityStreamRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopDbInstanceAutomatedBackupsReplicationRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.StopDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.SwitchoverBlueGreenDeploymentRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.SwitchoverGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.rds.transform.SwitchoverReadReplicaRequestMarshaller;
import software.amazon.awssdk.services.rds.waiters.RdsAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link RdsAsyncClient}.
 *
 * @see RdsAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRdsAsyncClient implements RdsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRdsAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final RdsServiceClientConfiguration serviceClientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultRdsAsyncClient(RdsServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public RdsUtilities utilities() {
        return DefaultRdsUtilities.create(clientConfiguration);
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     * </p>
     *
     * @param addRoleToDbClusterRequest
     * @return A Java Future containing the result of the AddRoleToDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleAlreadyExistsException The specified IAM role Amazon Resource Name (ARN) is already
     *         associated with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterRoleQuotaExceededException You have exceeded the maximum number of IAM roles that can be
     *         associated with the specified DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddRoleToDbClusterResponse> addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRoleToDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRoleToDBCluster");

            HttpResponseHandler<AddRoleToDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddRoleToDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddRoleToDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddRoleToDbClusterRequest, AddRoleToDbClusterResponse>()
                            .withOperationName("AddRoleToDBCluster")
                            .withMarshaller(new AddRoleToDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addRoleToDbClusterRequest));
            CompletableFuture<AddRoleToDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     * </p>
     * <note>
     * <p>
     * To add a role to a DB instance, the status of the DB instance must be <code>available</code>.
     * </p>
     * </note>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param addRoleToDbInstanceRequest
     * @return A Java Future containing the result of the AddRoleToDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceRoleAlreadyExistsException The specified <code>RoleArn</code> or <code>FeatureName</code>
     *         value is already associated with the DB instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceRoleQuotaExceededException You can't associate any more Amazon Web Services Identity and
     *         Access Management (IAM) roles with the DB instance because the quota has been reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddRoleToDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddRoleToDbInstanceResponse> addRoleToDBInstance(
            AddRoleToDbInstanceRequest addRoleToDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRoleToDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRoleToDBInstance");

            HttpResponseHandler<AddRoleToDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddRoleToDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddRoleToDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddRoleToDbInstanceRequest, AddRoleToDbInstanceResponse>()
                            .withOperationName("AddRoleToDBInstance")
                            .withMarshaller(new AddRoleToDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addRoleToDbInstanceRequest));
            CompletableFuture<AddRoleToDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a source identifier to an existing RDS event notification subscription.
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     * @return A Java Future containing the result of the AddSourceIdentifierToSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SourceNotFoundException The requested source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(
            AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addSourceIdentifierToSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddSourceIdentifierToSubscription");

            HttpResponseHandler<AddSourceIdentifierToSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddSourceIdentifierToSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddSourceIdentifierToSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddSourceIdentifierToSubscriptionRequest, AddSourceIdentifierToSubscriptionResponse>()
                            .withOperationName("AddSourceIdentifierToSubscription")
                            .withMarshaller(new AddSourceIdentifierToSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addSourceIdentifierToSubscriptionRequest));
            CompletableFuture<AddSourceIdentifierToSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track
     * cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * </p>
     * <p>
     * For an overview on tagging Amazon RDS resources, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS
     * Resources</a>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddTagsToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource")
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addTagsToResourceRequest));
            CompletableFuture<AddTagsToResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplyPendingMaintenanceAction");

            HttpResponseHandler<ApplyPendingMaintenanceActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ApplyPendingMaintenanceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse>()
                            .withOperationName("ApplyPendingMaintenanceAction")
                            .withMarshaller(new ApplyPendingMaintenanceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(applyPendingMaintenanceActionRequest));
            CompletableFuture<ApplyPendingMaintenanceActionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups
     * can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances.
     * Second, IP ranges are available if the application accessing your database is running on the internet. Required
     * parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
     * EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     * </p>
     * <p>
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB
     * instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB
     * instance in another.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param authorizeDbSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeDBSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR IP range or Amazon EC2 security group is
     *         already authorized for the specified DB security group.</li>
     *         <li>AuthorizationQuotaExceededException The DB security group authorization quota has been reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AuthorizeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeDbSecurityGroupIngressResponse> authorizeDBSecurityGroupIngress(
            AuthorizeDbSecurityGroupIngressRequest authorizeDbSecurityGroupIngressRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                authorizeDbSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeDBSecurityGroupIngress");

            HttpResponseHandler<AuthorizeDbSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeDbSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeDbSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeDbSecurityGroupIngressRequest, AuthorizeDbSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeDBSecurityGroupIngress")
                            .withMarshaller(new AuthorizeDbSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(authorizeDbSecurityGroupIngressRequest));
            CompletableFuture<AuthorizeDbSecurityGroupIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * </p>
     * <p>
     * For more information on backtracking, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param backtrackDbClusterRequest
     * @return A Java Future containing the result of the BacktrackDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.BacktrackDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BacktrackDbClusterResponse> backtrackDBCluster(BacktrackDbClusterRequest backtrackDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, backtrackDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BacktrackDBCluster");

            HttpResponseHandler<BacktrackDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(BacktrackDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<BacktrackDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BacktrackDbClusterRequest, BacktrackDbClusterResponse>()
                            .withOperationName("BacktrackDBCluster")
                            .withMarshaller(new BacktrackDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(backtrackDbClusterRequest));
            CompletableFuture<BacktrackDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has
     * already been written to the S3 bucket isn't removed.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>InvalidExportTaskStateException You can't cancel an export task that has completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelExportTask");

            HttpResponseHandler<CancelExportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelExportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelExportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelExportTaskRequest, CancelExportTaskResponse>()
                            .withOperationName("CancelExportTask")
                            .withMarshaller(new CancelExportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelExportTaskRequest));
            CompletableFuture<CancelExportTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBClusterParameterGroup");

            HttpResponseHandler<CopyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyDbClusterParameterGroupRequest, CopyDbClusterParameterGroupResponse>()
                            .withOperationName("CopyDBClusterParameterGroup")
                            .withMarshaller(new CopyDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copyDbClusterParameterGroupRequest));
            CompletableFuture<CopyDbClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon
     * Web Services Region where you call the <code>CopyDBClusterSnapshot</code> operation is the destination Amazon Web
     * Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot
     * from another Amazon Web Services Region, you must provide the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier
     * for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is
     * the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the presigned URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     * <p>
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region
     * to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBClusterSnapshot");

            HttpResponseHandler<CopyDbClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyDbClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyDbClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyDbClusterSnapshotRequest, CopyDbClusterSnapshotResponse>()
                            .withOperationName("CopyDBClusterSnapshot")
                            .withMarshaller(new CopyDbClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copyDbClusterSnapshotRequest));
            CompletableFuture<CopyDbClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     *
     * @param copyDbParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(
            CopyDbParameterGroupRequest copyDbParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBParameterGroup");

            HttpResponseHandler<CopyDbParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyDbParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyDbParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyDbParameterGroupRequest, CopyDbParameterGroupResponse>()
                            .withOperationName("CopyDBParameterGroup")
                            .withMarshaller(new CopyDbParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copyDbParameterGroupRequest));
            CompletableFuture<CopyDbParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.
     * </p>
     * <p>
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services
     * Region where you call the <code>CopyDBSnapshot</code> operation is the destination Amazon Web Services Region for
     * the DB snapshot copy.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information about copying snapshots, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying
     * a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbSnapshotRequest
     * @return A Java Future containing the result of the CopyDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>CustomAvailabilityZoneNotFoundException <code>CustomAvailabilityZoneId</code> doesn't refer to an
     *         existing custom Availability Zone identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyDbSnapshotResponse> copyDBSnapshot(CopyDbSnapshotRequest copyDbSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBSnapshot");

            HttpResponseHandler<CopyDbSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyDbSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyDbSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyDbSnapshotRequest, CopyDbSnapshotResponse>()
                            .withOperationName("CopyDBSnapshot")
                            .withMarshaller(new CopyDbSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copyDbSnapshotRequest));
            CompletableFuture<CopyDbSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified option group.
     * </p>
     *
     * @param copyOptionGroupRequest
     * @return A Java Future containing the result of the CopyOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptionGroupAlreadyExistsException The option group you are trying to create already exists.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>OptionGroupQuotaExceededException The quota of 20 option groups was exceeded for this Amazon Web
     *         Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyOptionGroupResponse> copyOptionGroup(CopyOptionGroupRequest copyOptionGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyOptionGroup");

            HttpResponseHandler<CopyOptionGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyOptionGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyOptionGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyOptionGroupRequest, CopyOptionGroupResponse>()
                            .withOperationName("CopyOptionGroup")
                            .withMarshaller(new CopyOptionGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copyOptionGroupRequest));
            CompletableFuture<CopyOptionGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a blue/green deployment.
     * </p>
     * <p>
     * A blue/green deployment creates a staging environment that copies the production environment. In a blue/green
     * deployment, the blue environment is the current production environment. The green environment is the staging
     * environment. The staging environment stays in sync with the current production environment using logical
     * replication.
     * </p>
     * <p>
     * You can make changes to the databases in the green environment without affecting production workloads. For
     * example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes
     * in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch
     * over the environments to promote the green environment to be the new production environment. The switchover
     * typically takes under a minute.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createBlueGreenDeploymentRequest
     * @return A Java Future containing the result of the CreateBlueGreenDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SourceDatabaseNotSupportedException The source DB instance isn't supported for a blue/green
     *         deployment.</li>
     *         <li>SourceClusterNotSupportedException The source DB cluster isn't supported for a blue/green deployment.
     *         </li>
     *         <li>BlueGreenDeploymentAlreadyExistsException A blue/green deployment with the specified name already
     *         exists.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBlueGreenDeploymentResponse> createBlueGreenDeployment(
            CreateBlueGreenDeploymentRequest createBlueGreenDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBlueGreenDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBlueGreenDeployment");

            HttpResponseHandler<CreateBlueGreenDeploymentResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateBlueGreenDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateBlueGreenDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBlueGreenDeploymentRequest, CreateBlueGreenDeploymentResponse>()
                            .withOperationName("CreateBlueGreenDeployment")
                            .withMarshaller(new CreateBlueGreenDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBlueGreenDeploymentRequest));
            CompletableFuture<CreateBlueGreenDeploymentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom DB engine version (CEV).
     * </p>
     *
     * @param createCustomDbEngineVersionRequest
     * @return A Java Future containing the result of the CreateCustomDBEngineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomDbEngineVersionAlreadyExistsException A CEV with the specified name already exists.</li>
     *         <li>CustomDbEngineVersionQuotaExceededException You have exceeded your CEV quota.</li>
     *         <li>Ec2ImagePropertiesNotSupportedException The AMI configuration prerequisite has not been met.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>CreateCustomDbEngineVersionException An error occurred while trying to create the CEV.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomDbEngineVersionResponse> createCustomDBEngineVersion(
            CreateCustomDbEngineVersionRequest createCustomDbEngineVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomDbEngineVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomDBEngineVersion");

            HttpResponseHandler<CreateCustomDbEngineVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCustomDbEngineVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCustomDbEngineVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomDbEngineVersionRequest, CreateCustomDbEngineVersionResponse>()
                            .withOperationName("CreateCustomDBEngineVersion")
                            .withMarshaller(new CreateCustomDbEngineVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCustomDbEngineVersionRequest));
            CompletableFuture<CreateCustomDbEngineVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * </p>
     * <p>
     * If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer
     * instance for your DB cluster using the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a>
     * operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you,
     * each in a different Availability Zone.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a
     * read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about
     * Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * You can also use the <code>ReplicationSourceIdentifier</code> parameter to create a Multi-AZ DB cluster read
     * replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB
     * clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterRequest
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException The user already has a DB cluster with the given identifier.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbClusterResponse> createDBCluster(CreateDbClusterRequest createDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBCluster");

            HttpResponseHandler<CreateDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterRequest, CreateDbClusterResponse>()
                            .withOperationName("CreateDBCluster")
                            .withMarshaller(new CreateDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbClusterRequest));
            CompletableFuture<CreateDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createDbClusterEndpointRequest
     * @return A Java Future containing the result of the CreateDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterEndpointQuotaExceededException The cluster already has the maximum number of custom
     *         endpoints.</li>
     *         <li>DbClusterEndpointAlreadyExistsException The specified custom endpoint can't be created because it
     *         already exists.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbClusterEndpointResponse> createDBClusterEndpoint(
            CreateDbClusterEndpointRequest createDbClusterEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterEndpoint");

            HttpResponseHandler<CreateDbClusterEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbClusterEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbClusterEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterEndpointRequest, CreateDbClusterEndpointResponse>()
                            .withOperationName("CreateDBClusterEndpoint")
                            .withMarshaller(new CreateDbClusterEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbClusterEndpointRequest));
            CompletableFuture<CreateDbClusterEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group,
     * you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in
     * the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster
     * without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the DB cluster parameter group is used as the default for a new DB cluster.
     * This is especially important for parameters that are critical when creating the default database for a DB
     * cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code>
     * operation to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterParameterGroup");

            HttpResponseHandler<CreateDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterParameterGroupRequest, CreateDbClusterParameterGroupResponse>()
                            .withOperationName("CreateDBClusterParameterGroup")
                            .withMarshaller(new CreateDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbClusterParameterGroupRequest));
            CompletableFuture<CreateDbClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterSnapshot");

            HttpResponseHandler<CreateDbClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterSnapshotRequest, CreateDbClusterSnapshotResponse>()
                            .withOperationName("CreateDBClusterSnapshot")
                            .withMarshaller(new CreateDbClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbClusterSnapshotRequest));
            CompletableFuture<CreateDbClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <p>
     * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora
     * DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.
     * </p>
     * <p>
     * For more information about creating an RDS DB instance, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html"> Creating an Amazon RDS
     * DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a DB instance in an Aurora DB cluster, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html"> Creating an
     * Amazon Aurora DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbInstanceResponse> createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBInstance");

            HttpResponseHandler<CreateDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbInstanceRequest, CreateDbInstanceResponse>()
                            .withOperationName("CreateDBInstance")
                            .withMarshaller(new CreateDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbInstanceRequest));
            CompletableFuture<CreateDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster.
     * You can create a read replica for a DB instance running MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server. You
     * can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with read replicas</a>
     * and <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica"
     * >Migrating from a Multi-AZ DB cluster to a DB instance using a read replica</a> in the <i>Amazon RDS User
     * Guide</i>.
     * </p>
     * <p>
     * Amazon Aurora doesn't support this operation. To create a DB instance for an Aurora DB cluster, use the
     * <code>CreateDBInstance</code> operation.
     * </p>
     * <p>
     * All read replica DB instances are created with backups disabled. All other attributes (including DB security
     * groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.
     * </p>
     * <important>
     * <p>
     * Your source DB instance or cluster must have backup retention enabled.
     * </p>
     * </important>
     *
     * @param createDbInstanceReadReplicaRequest
     * @return A Java Future containing the result of the CreateDBInstanceReadReplica operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>DbSubnetGroupNotAllowedException The DBSubnetGroup shouldn't be specified while creating read
     *         replicas that lie in the same region as the source instance.</li>
     *         <li>InvalidDbSubnetGroupException The DBSubnetGroup doesn't belong to the same VPC as that of an existing
     *         cross-region read replica of the same source instance.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBInstanceReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbInstanceReadReplicaResponse> createDBInstanceReadReplica(
            CreateDbInstanceReadReplicaRequest createDbInstanceReadReplicaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbInstanceReadReplicaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBInstanceReadReplica");

            HttpResponseHandler<CreateDbInstanceReadReplicaResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbInstanceReadReplicaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbInstanceReadReplicaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbInstanceReadReplicaRequest, CreateDbInstanceReadReplicaResponse>()
                            .withOperationName("CreateDBInstanceReadReplica")
                            .withMarshaller(new CreateDbInstanceReadReplicaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbInstanceReadReplicaRequest));
            CompletableFuture<CreateDbInstanceReadReplicaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <code>ModifyDBParameterGroup</code>. Once you've created a DB parameter group, you need to associate it with your
     * DB instance using <code>ModifyDBInstance</code>. When you associate a new DB parameter group with a running DB
     * instance, you need to reboot the DB instance without failover for the new DB parameter group and associated
     * settings to take effect.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(
            CreateDbParameterGroupRequest createDbParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBParameterGroup");

            HttpResponseHandler<CreateDbParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbParameterGroupRequest, CreateDbParameterGroupResponse>()
                            .withOperationName("CreateDBParameterGroup")
                            .withMarshaller(new CreateDbParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbParameterGroupRequest));
            CompletableFuture<CreateDbParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB proxy.
     * </p>
     *
     * @param createDbProxyRequest
     * @return A Java Future containing the result of the CreateDBProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbProxyAlreadyExistsException The specified proxy name must be unique for all proxies owned by your
     *         Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyQuotaExceededException Your Amazon Web Services account already has the maximum number of
     *         proxies in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbProxyResponse> createDBProxy(CreateDbProxyRequest createDbProxyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBProxy");

            HttpResponseHandler<CreateDbProxyResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbProxyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbProxyRequest, CreateDbProxyResponse>()
                            .withOperationName("CreateDBProxy")
                            .withMarshaller(new CreateDbProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbProxyRequest));
            CompletableFuture<CreateDbProxyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters. You
     * can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy
     * endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     * </p>
     *
     * @param createDbProxyEndpointRequest
     * @return A Java Future containing the result of the CreateDBProxyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointAlreadyExistsException The specified DB proxy endpoint name must be unique for all DB
     *         proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointQuotaExceededException The DB proxy already has the maximum number of endpoints.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbProxyEndpointResponse> createDBProxyEndpoint(
            CreateDbProxyEndpointRequest createDbProxyEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbProxyEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBProxyEndpoint");

            HttpResponseHandler<CreateDbProxyEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbProxyEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbProxyEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbProxyEndpointRequest, CreateDbProxyEndpointResponse>()
                            .withOperationName("CreateDBProxyEndpoint")
                            .withMarshaller(new CreateDbProxyEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbProxyEndpointRequest));
            CompletableFuture<CreateDbProxyEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB security group. DB security groups control access to a DB instance.
     * </p>
     * <p>
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param createDbSecurityGroupRequest
     * @return A Java Future containing the result of the CreateDBSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSecurityGroupAlreadyExistsException A DB security group with the name specified in
     *         <code>DBSecurityGroupName</code> already exists.</li>
     *         <li>DbSecurityGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB security groups.</li>
     *         <li>DbSecurityGroupNotSupportedException A DB security group isn't allowed for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbSecurityGroupResponse> createDBSecurityGroup(
            CreateDbSecurityGroupRequest createDbSecurityGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBSecurityGroup");

            HttpResponseHandler<CreateDbSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbSecurityGroupRequest, CreateDbSecurityGroupResponse>()
                            .withOperationName("CreateDBSecurityGroup")
                            .withMarshaller(new CreateDbSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbSecurityGroupRequest));
            CompletableFuture<CreateDbSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or
     * <code>storage-optimization</code> state.
     * </p>
     *
     * @param createDbSnapshotRequest
     * @return A Java Future containing the result of the CreateDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbSnapshotResponse> createDBSnapshot(CreateDbSnapshotRequest createDbSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBSnapshot");

            HttpResponseHandler<CreateDbSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbSnapshotRequest, CreateDbSnapshotResponse>()
                            .withOperationName("CreateDBSnapshot")
                            .withMarshaller(new CreateDbSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbSnapshotRequest));
            CompletableFuture<CreateDbSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Web Services Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <code>DBSubnetGroupName</code> is already used by an existing DB
     *         subnet group.</li>
     *         <li>DbSubnetGroupQuotaExceededException The request would result in the user exceeding the allowed number
     *         of DB subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException The request would result in the user exceeding the allowed number of
     *         subnets in a DB subnet groups.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBSubnetGroup");

            HttpResponseHandler<CreateDbSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDbSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDbSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDbSubnetGroupRequest, CreateDbSubnetGroupResponse>()
                            .withOperationName("CreateDBSubnetGroup")
                            .withMarshaller(new CreateDbSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDbSubnetGroupRequest));
            CompletableFuture<CreateDbSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN)
     * created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a
     * topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) that you want to be notified of and provide a list
     * of RDS sources (<code>SourceIds</code>) that triggers the events. You can also provide a list of event categories
     * (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify
     * <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> = <code>mydbinstance1</code>,
     * <code>mydbinstance2</code> and <code>EventCategories</code> = <code>Availability</code>, <code>Backup</code>.
     * </p>
     * <p>
     * If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> =
     * <code>db-instance</code> and <code>SourceIds</code> = <code>myDBInstance1</code>, you are notified of all the
     * <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not
     * specify <code>SourceIds</code>, you receive notice of the events for that source type for all your RDS sources.
     * If you don't specify either the SourceType or the <code>SourceIds</code>, you are notified of events generated
     * from all RDS sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about subscribing to an event for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon
     * RDS event notification</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about subscribing to an event for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html"> Subscribing to
     * Amazon RDS event notification</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have reached the maximum number of event subscriptions.</li>
     *         <li>SubscriptionAlreadyExistException The supplied subscription name already exists.</li>
     *         <li>SnsInvalidTopicException SNS has responded that there is a problem with the SNS topic specified.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the SNS topic ARN.</li>
     *         <li>SnsTopicArnNotFoundException The SNS topic ARN does not exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The supplied category does not exist.</li>
     *         <li>SourceNotFoundException The requested source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventSubscription");

            HttpResponseHandler<CreateEventSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateEventSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse>()
                            .withOperationName("CreateEventSubscription")
                            .withMarshaller(new CreateEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEventSubscriptionRequest));
            CompletableFuture<CreateEventSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then create the primary and secondary DB clusters
     * in the global database. Or you can specify an existing Aurora cluster during the create operation, and this
     * cluster becomes the primary cluster of the global database.
     * </p>
     * <note>
     * <p>
     * This operation applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createGlobalClusterRequest
     * @return A Java Future containing the result of the CreateGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterAlreadyExistsException The <code>GlobalClusterIdentifier</code> already exists. Choose a
     *         new global database identifier (unique name) to create a new global database cluster.</li>
     *         <li>GlobalClusterQuotaExceededException The number of global database clusters for this account is
     *         already at the maximum allowed.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGlobalClusterResponse> createGlobalCluster(
            CreateGlobalClusterRequest createGlobalClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGlobalCluster");

            HttpResponseHandler<CreateGlobalClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateGlobalClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateGlobalClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGlobalClusterRequest, CreateGlobalClusterResponse>()
                            .withOperationName("CreateGlobalCluster")
                            .withMarshaller(new CreateGlobalClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGlobalClusterRequest));
            CompletableFuture<CreateGlobalClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new option group. You can create up to 20 option groups.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param createOptionGroupRequest
     * @return A Java Future containing the result of the CreateOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptionGroupAlreadyExistsException The option group you are trying to create already exists.</li>
     *         <li>OptionGroupQuotaExceededException The quota of 20 option groups was exceeded for this Amazon Web
     *         Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOptionGroupResponse> createOptionGroup(CreateOptionGroupRequest createOptionGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOptionGroup");

            HttpResponseHandler<CreateOptionGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateOptionGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateOptionGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOptionGroupRequest, CreateOptionGroupResponse>()
                            .withOperationName("CreateOptionGroup")
                            .withMarshaller(new CreateOptionGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createOptionGroupRequest));
            CompletableFuture<CreateOptionGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a blue/green deployment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param deleteBlueGreenDeploymentRequest
     * @return A Java Future containing the result of the DeleteBlueGreenDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>InvalidBlueGreenDeploymentStateException The blue/green deployment can't be switched over or deleted
     *         because there is an invalid configuration in the green environment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBlueGreenDeploymentResponse> deleteBlueGreenDeployment(
            DeleteBlueGreenDeploymentRequest deleteBlueGreenDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBlueGreenDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBlueGreenDeployment");

            HttpResponseHandler<DeleteBlueGreenDeploymentResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteBlueGreenDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteBlueGreenDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBlueGreenDeploymentRequest, DeleteBlueGreenDeploymentResponse>()
                            .withOperationName("DeleteBlueGreenDeployment")
                            .withMarshaller(new DeleteBlueGreenDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBlueGreenDeploymentRequest));
            CompletableFuture<DeleteBlueGreenDeploymentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The CEV must not be the default for RDS Custom. If it is, change the default before running this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup
     * of your RDS Custom instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Typically, deletion takes a few minutes.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>DeleteCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>DeleteCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">Deleting a
     * CEV</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteCustomDbEngineVersionRequest
     * @return A Java Future containing the result of the DeleteCustomDBEngineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomDbEngineVersionNotFoundException The specified CEV was not found.</li>
     *         <li>InvalidCustomDbEngineVersionStateException You can't delete the CEV.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomDbEngineVersionResponse> deleteCustomDBEngineVersion(
            DeleteCustomDbEngineVersionRequest deleteCustomDbEngineVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomDbEngineVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomDBEngineVersion");

            HttpResponseHandler<DeleteCustomDbEngineVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCustomDbEngineVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCustomDbEngineVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomDbEngineVersionRequest, DeleteCustomDbEngineVersionResponse>()
                            .withOperationName("DeleteCustomDBEngineVersion")
                            .withMarshaller(new DeleteCustomDbEngineVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCustomDbEngineVersionRequest));
            CompletableFuture<DeleteCustomDbEngineVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * If you're deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas
     * are promoted to standalone instances.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterRequest
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>DbClusterAutomatedBackupQuotaExceededException The quota for retained automated backups was exceeded.
     *         This prevents you from retaining any additional automated backups. The retained automated backups quota
     *         is the same as your DB cluster quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBCluster");

            HttpResponseHandler<DeleteDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterRequest, DeleteDbClusterResponse>()
                            .withOperationName("DeleteDBCluster")
                            .withMarshaller(new DeleteDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbClusterRequest));
            CompletableFuture<DeleteDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbClusterResourceId</code> value of the source DB cluster or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     *
     * @param deleteDbClusterAutomatedBackupRequest
     * @return A Java Future containing the result of the DeleteDBClusterAutomatedBackup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterAutomatedBackupStateException The automated backup is in an invalid state. For
     *         example, this automated backup is associated with an active cluster.</li>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbClusterAutomatedBackupResponse> deleteDBClusterAutomatedBackup(
            DeleteDbClusterAutomatedBackupRequest deleteDbClusterAutomatedBackupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDbClusterAutomatedBackupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterAutomatedBackup");

            HttpResponseHandler<DeleteDbClusterAutomatedBackupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbClusterAutomatedBackupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbClusterAutomatedBackupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterAutomatedBackupRequest, DeleteDbClusterAutomatedBackupResponse>()
                            .withOperationName("DeleteDBClusterAutomatedBackup")
                            .withMarshaller(new DeleteDbClusterAutomatedBackupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbClusterAutomatedBackupRequest));
            CompletableFuture<DeleteDbClusterAutomatedBackupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteDbClusterEndpointRequest
     * @return A Java Future containing the result of the DeleteDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterEndpointStateException The requested operation can't be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbClusterEndpointResponse> deleteDBClusterEndpoint(
            DeleteDbClusterEndpointRequest deleteDbClusterEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterEndpoint");

            HttpResponseHandler<DeleteDbClusterEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbClusterEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbClusterEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterEndpointRequest, DeleteDbClusterEndpointResponse>()
                            .withOperationName("DeleteDBClusterEndpoint")
                            .withMarshaller(new DeleteDbClusterEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbClusterEndpointRequest));
            CompletableFuture<DeleteDbClusterEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterParameterGroup");

            HttpResponseHandler<DeleteDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterParameterGroupRequest, DeleteDbClusterParameterGroupResponse>()
                            .withOperationName("DeleteDBClusterParameterGroup")
                            .withMarshaller(new DeleteDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbClusterParameterGroupRequest));
            CompletableFuture<DeleteDbClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterSnapshot");

            HttpResponseHandler<DeleteDbClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterSnapshotRequest, DeleteDbClusterSnapshotResponse>()
                            .withOperationName("DeleteDBClusterSnapshot")
                            .withMarshaller(new DeleteDbClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbClusterSnapshotRequest));
            CompletableFuture<DeleteDbClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that
     * instance are deleted and can't be recovered. However, manual DB snapshots of the DB instance aren't deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot, the status of the Amazon RDS DB instance is <code>deleting</code> until the
     * DB snapshot is created. This operation can't be canceled or reverted after it begins. To monitor the status of
     * this operation, use <code>DescribeDBInstance</code>.
     * </p>
     * <p>
     * When a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when you skip
     * creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.
     * </p>
     * <p>
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of
     * the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first use the <code>PromoteReadReplicaDBCluster</code> operation to promote
     * the DB cluster so that it's no longer a read replica. After the promotion completes, use the
     * <code>DeleteDBInstance</code> operation to delete the final instance in the DB cluster.
     * </p>
     * <important>
     * <p>
     * For RDS Custom DB instances, deleting the DB instance permanently deletes the EC2 instance and the associated EBS
     * volumes. Make sure that you don't terminate or delete these resources before you delete the DB instance.
     * Otherwise, deleting the DB instance and creation of the final snapshot might fail.
     * </p>
     * </important>
     *
     * @param deleteDbInstanceRequest
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbInstanceAutomatedBackupQuotaExceededException The quota for retained automated backups was
     *         exceeded. This prevents you from retaining any additional automated backups. The retained automated
     *         backups quota is the same as your DB instance quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBInstance");

            HttpResponseHandler<DeleteDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbInstanceRequest, DeleteDbInstanceResponse>()
                            .withOperationName("DeleteDBInstance")
                            .withMarshaller(new DeleteDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbInstanceRequest));
            CompletableFuture<DeleteDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     *
     * @param deleteDbInstanceAutomatedBackupRequest
     *        Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.
     * @return A Java Future containing the result of the DeleteDBInstanceAutomatedBackup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceAutomatedBackupStateException The automated backup is in an invalid state. For
     *         example, this automated backup is associated with an active instance.</li>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBInstanceAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbInstanceAutomatedBackupResponse> deleteDBInstanceAutomatedBackup(
            DeleteDbInstanceAutomatedBackupRequest deleteDbInstanceAutomatedBackupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDbInstanceAutomatedBackupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBInstanceAutomatedBackup");

            HttpResponseHandler<DeleteDbInstanceAutomatedBackupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbInstanceAutomatedBackupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbInstanceAutomatedBackupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbInstanceAutomatedBackupRequest, DeleteDbInstanceAutomatedBackupResponse>()
                            .withOperationName("DeleteDBInstanceAutomatedBackup")
                            .withMarshaller(new DeleteDbInstanceAutomatedBackupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbInstanceAutomatedBackupRequest));
            CompletableFuture<DeleteDbInstanceAutomatedBackupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB
     * instances.
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbParameterGroupResponse> deleteDBParameterGroup(
            DeleteDbParameterGroupRequest deleteDbParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBParameterGroup");

            HttpResponseHandler<DeleteDbParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbParameterGroupRequest, DeleteDbParameterGroupResponse>()
                            .withOperationName("DeleteDBParameterGroup")
                            .withMarshaller(new DeleteDbParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbParameterGroupRequest));
            CompletableFuture<DeleteDbParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing DB proxy.
     * </p>
     *
     * @param deleteDbProxyRequest
     * @return A Java Future containing the result of the DeleteDBProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbProxyResponse> deleteDBProxy(DeleteDbProxyRequest deleteDbProxyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBProxy");

            HttpResponseHandler<DeleteDbProxyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbProxyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbProxyRequest, DeleteDbProxyResponse>()
                            .withOperationName("DeleteDBProxy")
                            .withMarshaller(new DeleteDbProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbProxyRequest));
            CompletableFuture<DeleteDbProxyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the endpoint
     * that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only
     * operations, or using a different VPC than the DB proxy's default VPC.
     * </p>
     *
     * @param deleteDbProxyEndpointRequest
     * @return A Java Future containing the result of the DeleteDBProxyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>InvalidDbProxyEndpointStateException You can't perform this operation while the DB proxy endpoint is
     *         in a particular state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbProxyEndpointResponse> deleteDBProxyEndpoint(
            DeleteDbProxyEndpointRequest deleteDbProxyEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbProxyEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBProxyEndpoint");

            HttpResponseHandler<DeleteDbProxyEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbProxyEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbProxyEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbProxyEndpointRequest, DeleteDbProxyEndpointResponse>()
                            .withOperationName("DeleteDBProxyEndpoint")
                            .withMarshaller(new DeleteDbProxyEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbProxyEndpointRequest));
            CompletableFuture<DeleteDbProxyEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a DB security group.
     * </p>
     * <p>
     * The specified DB security group must not be associated with any DB instances.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param deleteDbSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteDBSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbSecurityGroupResponse> deleteDBSecurityGroup(
            DeleteDbSecurityGroupRequest deleteDbSecurityGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBSecurityGroup");

            HttpResponseHandler<DeleteDbSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbSecurityGroupRequest, DeleteDbSecurityGroupResponse>()
                            .withOperationName("DeleteDBSecurityGroup")
                            .withMarshaller(new DeleteDbSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbSecurityGroupRequest));
            CompletableFuture<DeleteDbSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbSnapshotRequest
     * @return A Java Future containing the result of the DeleteDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbSnapshotResponse> deleteDBSnapshot(DeleteDbSnapshotRequest deleteDbSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBSnapshot");

            HttpResponseHandler<DeleteDbSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbSnapshotRequest, DeleteDbSnapshotResponse>()
                            .withOperationName("DeleteDBSnapshot")
                            .withMarshaller(new DeleteDbSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbSnapshotRequest));
            CompletableFuture<DeleteDbSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet isn't in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDbSubnetGroupResponse> deleteDBSubnetGroup(
            DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBSubnetGroup");

            HttpResponseHandler<DeleteDbSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDbSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDbSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDbSubnetGroupRequest, DeleteDbSubnetGroupResponse>()
                            .withOperationName("DeleteDBSubnetGroup")
                            .withMarshaller(new DeleteDbSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDbSubnetGroupRequest));
            CompletableFuture<DeleteDbSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an RDS event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>InvalidEventSubscriptionStateException This error can occur if someone else is modifying a
     *         subscription. You should retry the action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventSubscription");

            HttpResponseHandler<DeleteEventSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteEventSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse>()
                            .withOperationName("DeleteEventSubscription")
                            .withMarshaller(new DeleteEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEventSubscriptionRequest));
            CompletableFuture<DeleteEventSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed
     * first.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteGlobalClusterRequest
     * @return A Java Future containing the result of the DeleteGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGlobalClusterResponse> deleteGlobalCluster(
            DeleteGlobalClusterRequest deleteGlobalClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGlobalCluster");

            HttpResponseHandler<DeleteGlobalClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteGlobalClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteGlobalClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGlobalClusterRequest, DeleteGlobalClusterResponse>()
                            .withOperationName("DeleteGlobalCluster")
                            .withMarshaller(new DeleteGlobalClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGlobalClusterRequest));
            CompletableFuture<DeleteGlobalClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing option group.
     * </p>
     *
     * @param deleteOptionGroupRequest
     * @return A Java Future containing the result of the DeleteOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>InvalidOptionGroupStateException The option group isn't in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOptionGroupResponse> deleteOptionGroup(DeleteOptionGroupRequest deleteOptionGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOptionGroup");

            HttpResponseHandler<DeleteOptionGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteOptionGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteOptionGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOptionGroupRequest, DeleteOptionGroupResponse>()
                            .withOperationName("DeleteOptionGroup")
                            .withMarshaller(new DeleteOptionGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteOptionGroupRequest));
            CompletableFuture<DeleteOptionGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove the association between one or more <code>DBProxyTarget</code> data structures and a
     * <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param deregisterDbProxyTargetsRequest
     * @return A Java Future containing the result of the DeregisterDBProxyTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeregisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterDbProxyTargetsResponse> deregisterDBProxyTargets(
            DeregisterDbProxyTargetsRequest deregisterDbProxyTargetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterDbProxyTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterDBProxyTargets");

            HttpResponseHandler<DeregisterDbProxyTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterDbProxyTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterDbProxyTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterDbProxyTargetsRequest, DeregisterDbProxyTargetsResponse>()
                            .withOperationName("DeregisterDBProxyTargets")
                            .withMarshaller(new DeregisterDbProxyTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterDbProxyTargetsRequest));
            CompletableFuture<DeregisterDbProxyTargetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAttributes");

            HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAccountAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAccountAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes")
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAccountAttributesRequest));
            CompletableFuture<DescribeAccountAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     * @return A Java Future containing the result of the DescribeBlueGreenDeployments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBlueGreenDeploymentsResponse> describeBlueGreenDeployments(
            DescribeBlueGreenDeploymentsRequest describeBlueGreenDeploymentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBlueGreenDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBlueGreenDeployments");

            HttpResponseHandler<DescribeBlueGreenDeploymentsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeBlueGreenDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeBlueGreenDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBlueGreenDeploymentsRequest, DescribeBlueGreenDeploymentsResponse>()
                            .withOperationName("DescribeBlueGreenDeployments")
                            .withMarshaller(new DescribeBlueGreenDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBlueGreenDeploymentsRequest));
            CompletableFuture<DescribeBlueGreenDeploymentsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this Amazon Web Services
     * account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCertificatesResponse> describeCertificates(
            DescribeCertificatesRequest describeCertificatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificates");

            HttpResponseHandler<DescribeCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCertificatesRequest, DescribeCertificatesResponse>()
                            .withOperationName("DescribeCertificates")
                            .withMarshaller(new DescribeCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCertificatesRequest));
            CompletableFuture<DescribeCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays backups for both current and deleted DB clusters. For example, use this operation to find details about
     * automated backups for previously deleted clusters. Current clusters are returned for both the
     * <code>DescribeDBClusterAutomatedBackups</code> and <code>DescribeDBClusters</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @param describeDbClusterAutomatedBackupsRequest
     * @return A Java Future containing the result of the DescribeDBClusterAutomatedBackups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterAutomatedBackupsResponse> describeDBClusterAutomatedBackups(
            DescribeDbClusterAutomatedBackupsRequest describeDbClusterAutomatedBackupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterAutomatedBackupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterAutomatedBackups");

            HttpResponseHandler<DescribeDbClusterAutomatedBackupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterAutomatedBackupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterAutomatedBackupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterAutomatedBackupsRequest, DescribeDbClusterAutomatedBackupsResponse>()
                            .withOperationName("DescribeDBClusterAutomatedBackups")
                            .withMarshaller(new DescribeDbClusterAutomatedBackupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClusterAutomatedBackupsRequest));
            CompletableFuture<DescribeDbClusterAutomatedBackupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterBacktracksRequest
     * @return A Java Future containing the result of the DescribeDBClusterBacktracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterBacktrackNotFoundException <code>BacktrackIdentifier</code> doesn't refer to an existing
     *         backtrack.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterBacktracksResponse> describeDBClusterBacktracks(
            DescribeDbClusterBacktracksRequest describeDbClusterBacktracksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterBacktracksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterBacktracks");

            HttpResponseHandler<DescribeDbClusterBacktracksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterBacktracksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterBacktracksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterBacktracksRequest, DescribeDbClusterBacktracksResponse>()
                            .withOperationName("DescribeDBClusterBacktracks")
                            .withMarshaller(new DescribeDbClusterBacktracksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClusterBacktracksRequest));
            CompletableFuture<DescribeDbClusterBacktracksResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterEndpointsRequest
     * @return A Java Future containing the result of the DescribeDBClusterEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterEndpointsResponse> describeDBClusterEndpoints(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterEndpoints");

            HttpResponseHandler<DescribeDbClusterEndpointsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterEndpointsRequest, DescribeDbClusterEndpointsResponse>()
                            .withOperationName("DescribeDBClusterEndpoints")
                            .withMarshaller(new DescribeDbClusterEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClusterEndpointsRequest));
            CompletableFuture<DescribeDbClusterEndpointsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterParameterGroups");

            HttpResponseHandler<DescribeDbClusterParameterGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterParameterGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParameterGroupsRequest, DescribeDbClusterParameterGroupsResponse>()
                            .withOperationName("DescribeDBClusterParameterGroups")
                            .withMarshaller(new DescribeDbClusterParameterGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClusterParameterGroupsRequest));
            CompletableFuture<DescribeDbClusterParameterGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterParameters");

            HttpResponseHandler<DescribeDbClusterParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParametersRequest, DescribeDbClusterParametersResponse>()
                            .withOperationName("DescribeDBClusterParameters")
                            .withMarshaller(new DescribeDbClusterParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClusterParametersRequest));
            CompletableFuture<DescribeDbClusterParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code>
     * returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of
     * values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or
     * restored by all Amazon Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to
     * make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API
     * action.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterSnapshotAttributes");

            HttpResponseHandler<DescribeDbClusterSnapshotAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotAttributesRequest, DescribeDbClusterSnapshotAttributesResponse>()
                            .withOperationName("DescribeDBClusterSnapshotAttributes")
                            .withMarshaller(new DescribeDbClusterSnapshotAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClusterSnapshotAttributesRequest));
            CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterSnapshots");

            HttpResponseHandler<DescribeDbClusterSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClusterSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>()
                            .withOperationName("DescribeDBClusterSnapshots")
                            .withMarshaller(new DescribeDbClusterSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClusterSnapshotsRequest));
            CompletableFuture<DescribeDbClusterSnapshotsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     *
     * @param describeDbClustersRequest
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbClustersResponse> describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusters");

            HttpResponseHandler<DescribeDbClustersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbClustersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClustersRequest, DescribeDbClustersResponse>()
                            .withOperationName("DescribeDBClusters")
                            .withMarshaller(new DescribeDbClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbClustersRequest));
            CompletableFuture<DescribeDbClustersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the properties of specific versions of DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBEngineVersions");

            HttpResponseHandler<DescribeDbEngineVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbEngineVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbEngineVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbEngineVersionsRequest, DescribeDbEngineVersionsResponse>()
                            .withOperationName("DescribeDBEngineVersions")
                            .withMarshaller(new DescribeDbEngineVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbEngineVersionsRequest));
            CompletableFuture<DescribeDbEngineVersionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return A Java Future containing the result of the DescribeDBInstanceAutomatedBackups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbInstanceAutomatedBackupsResponse> describeDBInstanceAutomatedBackups(
            DescribeDbInstanceAutomatedBackupsRequest describeDbInstanceAutomatedBackupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbInstanceAutomatedBackupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBInstanceAutomatedBackups");

            HttpResponseHandler<DescribeDbInstanceAutomatedBackupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbInstanceAutomatedBackupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbInstanceAutomatedBackupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbInstanceAutomatedBackupsRequest, DescribeDbInstanceAutomatedBackupsResponse>()
                            .withOperationName("DescribeDBInstanceAutomatedBackups")
                            .withMarshaller(new DescribeDbInstanceAutomatedBackupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbInstanceAutomatedBackupsRequest));
            CompletableFuture<DescribeDbInstanceAutomatedBackupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note>
     *
     * @param describeDbInstancesRequest
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            DescribeDbInstancesRequest describeDbInstancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBInstances");

            HttpResponseHandler<DescribeDbInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbInstancesRequest, DescribeDbInstancesResponse>()
                            .withOperationName("DescribeDBInstances")
                            .withMarshaller(new DescribeDbInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbInstancesRequest));
            CompletableFuture<DescribeDbInstancesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param describeDbLogFilesRequest
     * @return A Java Future containing the result of the DescribeDBLogFiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbLogFilesResponse> describeDBLogFiles(DescribeDbLogFilesRequest describeDbLogFilesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbLogFilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBLogFiles");

            HttpResponseHandler<DescribeDbLogFilesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbLogFilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbLogFilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbLogFilesRequest, DescribeDbLogFilesResponse>()
                            .withOperationName("DescribeDBLogFiles")
                            .withMarshaller(new DescribeDbLogFilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbLogFilesRequest));
            CompletableFuture<DescribeDbLogFilesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbParameterGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBParameterGroups");

            HttpResponseHandler<DescribeDbParameterGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbParameterGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbParameterGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbParameterGroupsRequest, DescribeDbParameterGroupsResponse>()
                            .withOperationName("DescribeDBParameterGroups")
                            .withMarshaller(new DescribeDbParameterGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbParameterGroupsRequest));
            CompletableFuture<DescribeDbParameterGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A Java Future containing the result of the DescribeDBParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbParametersResponse> describeDBParameters(
            DescribeDbParametersRequest describeDbParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBParameters");

            HttpResponseHandler<DescribeDbParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbParametersRequest, DescribeDbParametersResponse>()
                            .withOperationName("DescribeDBParameters")
                            .withMarshaller(new DescribeDbParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbParametersRequest));
            CompletableFuture<DescribeDbParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     *
     * @param describeDbProxiesRequest
     * @return A Java Future containing the result of the DescribeDBProxies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbProxiesResponse> describeDBProxies(DescribeDbProxiesRequest describeDbProxiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxies");

            HttpResponseHandler<DescribeDbProxiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbProxiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbProxiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbProxiesRequest, DescribeDbProxiesResponse>()
                            .withOperationName("DescribeDBProxies")
                            .withMarshaller(new DescribeDbProxiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbProxiesRequest));
            CompletableFuture<DescribeDbProxiesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     * @return A Java Future containing the result of the DescribeDBProxyEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbProxyEndpointsResponse> describeDBProxyEndpoints(
            DescribeDbProxyEndpointsRequest describeDbProxyEndpointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxyEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxyEndpoints");

            HttpResponseHandler<DescribeDbProxyEndpointsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbProxyEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbProxyEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbProxyEndpointsRequest, DescribeDbProxyEndpointsResponse>()
                            .withOperationName("DescribeDBProxyEndpoints")
                            .withMarshaller(new DescribeDbProxyEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbProxyEndpointsRequest));
            CompletableFuture<DescribeDbProxyEndpointsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     * @return A Java Future containing the result of the DescribeDBProxyTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbProxyTargetGroupsResponse> describeDBProxyTargetGroups(
            DescribeDbProxyTargetGroupsRequest describeDbProxyTargetGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxyTargetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxyTargetGroups");

            HttpResponseHandler<DescribeDbProxyTargetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbProxyTargetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbProxyTargetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbProxyTargetGroupsRequest, DescribeDbProxyTargetGroupsResponse>()
                            .withOperationName("DescribeDBProxyTargetGroups")
                            .withMarshaller(new DescribeDbProxyTargetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbProxyTargetGroupsRequest));
            CompletableFuture<DescribeDbProxyTargetGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     * @return A Java Future containing the result of the DescribeDBProxyTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbProxyTargetsResponse> describeDBProxyTargets(
            DescribeDbProxyTargetsRequest describeDbProxyTargetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbProxyTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBProxyTargets");

            HttpResponseHandler<DescribeDbProxyTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbProxyTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbProxyTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbProxyTargetsRequest, DescribeDbProxyTargetsResponse>()
                            .withOperationName("DescribeDBProxyTargets")
                            .withMarshaller(new DescribeDbProxyTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbProxyTargetsRequest));
            CompletableFuture<DescribeDbProxyTargetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param describeDbSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeDBSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbSecurityGroupsResponse> describeDBSecurityGroups(
            DescribeDbSecurityGroupsRequest describeDbSecurityGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSecurityGroups");

            HttpResponseHandler<DescribeDbSecurityGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbSecurityGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbSecurityGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSecurityGroupsRequest, DescribeDbSecurityGroupsResponse>()
                            .withOperationName("DescribeDBSecurityGroups")
                            .withMarshaller(new DescribeDbSecurityGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbSecurityGroupsRequest));
            CompletableFuture<DescribeDbSecurityGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code> returns
     * the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to
     * copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon
     * Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make
     * the manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.
     * </p>
     *
     * @param describeDbSnapshotAttributesRequest
     * @return A Java Future containing the result of the DescribeDBSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbSnapshotAttributesResponse> describeDBSnapshotAttributes(
            DescribeDbSnapshotAttributesRequest describeDbSnapshotAttributesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSnapshotAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSnapshotAttributes");

            HttpResponseHandler<DescribeDbSnapshotAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbSnapshotAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbSnapshotAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSnapshotAttributesRequest, DescribeDbSnapshotAttributesResponse>()
                            .withOperationName("DescribeDBSnapshotAttributes")
                            .withMarshaller(new DescribeDbSnapshotAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbSnapshotAttributesRequest));
            CompletableFuture<DescribeDbSnapshotAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     *
     * @param describeDbSnapshotsRequest
     * @return A Java Future containing the result of the DescribeDBSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbSnapshotsResponse> describeDBSnapshots(
            DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSnapshots");

            HttpResponseHandler<DescribeDbSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSnapshotsRequest, DescribeDbSnapshotsResponse>()
                            .withOperationName("DescribeDBSnapshots")
                            .withMarshaller(new DescribeDbSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbSnapshotsRequest));
            CompletableFuture<DescribeDbSnapshotsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSubnetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSubnetGroups");

            HttpResponseHandler<DescribeDbSubnetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDbSubnetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDbSubnetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSubnetGroupsRequest, DescribeDbSubnetGroupsResponse>()
                            .withOperationName("DescribeDBSubnetGroups")
                            .withMarshaller(new DescribeDbSubnetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDbSubnetGroupsRequest));
            CompletableFuture<DescribeDbSubnetGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultClusterParameters");

            HttpResponseHandler<DescribeEngineDefaultClusterParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEngineDefaultClusterParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultClusterParametersRequest, DescribeEngineDefaultClusterParametersResponse>()
                            .withOperationName("DescribeEngineDefaultClusterParameters")
                            .withMarshaller(new DescribeEngineDefaultClusterParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEngineDefaultClusterParametersRequest));
            CompletableFuture<DescribeEngineDefaultClusterParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultParameters");

            HttpResponseHandler<DescribeEngineDefaultParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEngineDefaultParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEngineDefaultParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultParametersRequest, DescribeEngineDefaultParametersResponse>()
                            .withOperationName("DescribeEngineDefaultParameters")
                            .withMarshaller(new DescribeEngineDefaultParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEngineDefaultParametersRequest));
            CompletableFuture<DescribeEngineDefaultParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventCategories");

            HttpResponseHandler<DescribeEventCategoriesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventCategoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventCategoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse>()
                            .withOperationName("DescribeEventCategories")
                            .withMarshaller(new DescribeEventCategoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEventCategoriesRequest));
            CompletableFuture<DescribeEventCategoriesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventSubscriptions");

            HttpResponseHandler<DescribeEventSubscriptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventSubscriptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventSubscriptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse>()
                            .withOperationName("DescribeEventSubscriptions")
                            .withMarshaller(new DescribeEventSubscriptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEventSubscriptionsRequest));
            CompletableFuture<DescribeEventSubscriptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                            .withOperationName("DescribeEvents")
                            .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEventsRequest));
            CompletableFuture<DescribeEventsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            DescribeExportTasksRequest describeExportTasksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExportTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExportTasks");

            HttpResponseHandler<DescribeExportTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeExportTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeExportTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExportTasksRequest, DescribeExportTasksResponse>()
                            .withOperationName("DescribeExportTasks")
                            .withMarshaller(new DescribeExportTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeExportTasksRequest));
            CompletableFuture<DescribeExportTasksResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeGlobalClustersRequest
     * @return A Java Future containing the result of the DescribeGlobalClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGlobalClustersResponse> describeGlobalClusters(
            DescribeGlobalClustersRequest describeGlobalClustersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGlobalClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGlobalClusters");

            HttpResponseHandler<DescribeGlobalClustersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeGlobalClustersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeGlobalClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGlobalClustersRequest, DescribeGlobalClustersResponse>()
                            .withOperationName("DescribeGlobalClusters")
                            .withMarshaller(new DescribeGlobalClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeGlobalClustersRequest));
            CompletableFuture<DescribeGlobalClustersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes all available options.
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     * @return A Java Future containing the result of the DescribeOptionGroupOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOptionGroupOptionsResponse> describeOptionGroupOptions(
            DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptionGroupOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptionGroupOptions");

            HttpResponseHandler<DescribeOptionGroupOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeOptionGroupOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeOptionGroupOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOptionGroupOptionsRequest, DescribeOptionGroupOptionsResponse>()
                            .withOperationName("DescribeOptionGroupOptions")
                            .withMarshaller(new DescribeOptionGroupOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOptionGroupOptionsRequest));
            CompletableFuture<DescribeOptionGroupOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     *
     * @param describeOptionGroupsRequest
     * @return A Java Future containing the result of the DescribeOptionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOptionGroupsResponse> describeOptionGroups(
            DescribeOptionGroupsRequest describeOptionGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptionGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptionGroups");

            HttpResponseHandler<DescribeOptionGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeOptionGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeOptionGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOptionGroupsRequest, DescribeOptionGroupsResponse>()
                            .withOperationName("DescribeOptionGroups")
                            .withMarshaller(new DescribeOptionGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOptionGroupsRequest));
            CompletableFuture<DescribeOptionGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance
     * class.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrderableDBInstanceOptions");

            HttpResponseHandler<DescribeOrderableDbInstanceOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrderableDbInstanceOptionsRequest, DescribeOrderableDbInstanceOptionsResponse>()
                            .withOperationName("DescribeOrderableDBInstanceOptions")
                            .withMarshaller(new DescribeOrderableDbInstanceOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOrderableDbInstanceOptionsRequest));
            CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePendingMaintenanceActions");

            HttpResponseHandler<DescribePendingMaintenanceActionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribePendingMaintenanceActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse>()
                            .withOperationName("DescribePendingMaintenanceActions")
                            .withMarshaller(new DescribePendingMaintenanceActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePendingMaintenanceActionsRequest));
            CompletableFuture<DescribePendingMaintenanceActionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     * @return A Java Future containing the result of the DescribeReservedDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedDbInstanceNotFoundException The specified reserved DB Instance not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedDbInstancesResponse> describeReservedDBInstances(
            DescribeReservedDbInstancesRequest describeReservedDbInstancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservedDbInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedDBInstances");

            HttpResponseHandler<DescribeReservedDbInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedDbInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedDbInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedDbInstancesRequest, DescribeReservedDbInstancesResponse>()
                            .withOperationName("DescribeReservedDBInstances")
                            .withMarshaller(new DescribeReservedDbInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeReservedDbInstancesRequest));
            CompletableFuture<DescribeReservedDbInstancesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     * @return A Java Future containing the result of the DescribeReservedDBInstancesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedDbInstancesOfferingsResponse> describeReservedDBInstancesOfferings(
            DescribeReservedDbInstancesOfferingsRequest describeReservedDbInstancesOfferingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedDbInstancesOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedDBInstancesOfferings");

            HttpResponseHandler<DescribeReservedDbInstancesOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedDbInstancesOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedDbInstancesOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedDbInstancesOfferingsRequest, DescribeReservedDbInstancesOfferingsResponse>()
                            .withOperationName("DescribeReservedDBInstancesOfferings")
                            .withMarshaller(new DescribeReservedDbInstancesOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeReservedDbInstancesOfferingsRequest));
            CompletableFuture<DescribeReservedDbInstancesOfferingsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     *
     * @param describeSourceRegionsRequest
     * @return A Java Future containing the result of the DescribeSourceRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeSourceRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSourceRegionsResponse> describeSourceRegions(
            DescribeSourceRegionsRequest describeSourceRegionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSourceRegionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSourceRegions");

            HttpResponseHandler<DescribeSourceRegionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSourceRegionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSourceRegionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSourceRegionsRequest, DescribeSourceRegionsResponse>()
                            .withOperationName("DescribeSourceRegions")
                            .withMarshaller(new DescribeSourceRegionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSourceRegionsRequest));
            CompletableFuture<DescribeSourceRegionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * You can call <code>DescribeValidDBInstanceModifications</code> to learn what modifications you can make to your
     * DB instance. You can use this information when you call <code>ModifyDBInstance</code>.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     * @return A Java Future containing the result of the DescribeValidDBInstanceModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeValidDBInstanceModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeValidDbInstanceModificationsResponse> describeValidDBInstanceModifications(
            DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeValidDbInstanceModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeValidDBInstanceModifications");

            HttpResponseHandler<DescribeValidDbInstanceModificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeValidDbInstanceModificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeValidDbInstanceModificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeValidDbInstanceModificationsRequest, DescribeValidDbInstanceModificationsResponse>()
                            .withOperationName("DescribeValidDBInstanceModifications")
                            .withMarshaller(new DescribeValidDbInstanceModificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeValidDbInstanceModificationsRequest));
            CompletableFuture<DescribeValidDbInstanceModificationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param downloadDbLogFilePortionRequest
     * @return A Java Future containing the result of the DownloadDBLogFilePortion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbLogFileNotFoundException <code>LogFileName</code> doesn't refer to an existing DB log file.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DownloadDBLogFilePortion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DownloadDbLogFilePortionResponse> downloadDBLogFilePortion(
            DownloadDbLogFilePortionRequest downloadDbLogFilePortionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, downloadDbLogFilePortionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DownloadDBLogFilePortion");

            HttpResponseHandler<DownloadDbLogFilePortionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DownloadDbLogFilePortionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DownloadDbLogFilePortionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DownloadDbLogFilePortionRequest, DownloadDbLogFilePortionResponse>()
                            .withOperationName("DownloadDBLogFilePortion")
                            .withMarshaller(new DownloadDbLogFilePortionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(downloadDbLogFilePortionRequest));
            CompletableFuture<DownloadDbLogFilePortionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in
     * the DB cluster to be the primary DB instance (the cluster writer).
     * </p>
     * <p>
     * For a Multi-AZ DB cluster, failover for a DB cluster promotes one of the readable standby DB instances (read-only
     * instances) in the DB cluster to be the primary DB instance (the cluster writer).
     * </p>
     * <p>
     * An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists, when the primary DB
     * instance fails. A Multi-AZ DB cluster automatically fails over to a readable standby DB instance when the primary
     * DB instance fails.
     * </p>
     * <p>
     * To simulate a failure of a primary instance for testing, you can force a failover. Because each instance in a DB
     * cluster has its own endpoint address, make sure to clean up and re-establish any existing connections that use
     * those endpoint addresses when the failover is complete.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param failoverDbClusterRequest
     * @return A Java Future containing the result of the FailoverDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.FailoverDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<FailoverDbClusterResponse> failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverDBCluster");

            HttpResponseHandler<FailoverDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(FailoverDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<FailoverDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FailoverDbClusterRequest, FailoverDbClusterResponse>()
                            .withOperationName("FailoverDBCluster")
                            .withMarshaller(new FailoverDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(failoverDbClusterRequest));
            CompletableFuture<FailoverDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Promotes the specified secondary DB cluster to be the primary DB cluster in the global database cluster to fail
     * over or switch over a global database. Switchover operations were previously called "managed planned failovers."
     * </p>
     * <note>
     * <p>
     * Although this operation can be used either to fail over or to switch over a global database cluster, its intended
     * use is for global database failover. To switch over a global database cluster, we recommend that you use the
     * <a>SwitchoverGlobalCluster</a> operation instead.
     * </p>
     * </note>
     * <p>
     * How you use this operation depends on whether you are failing over or switching over your global database
     * cluster:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Failing over - Specify the <code>AllowDataLoss</code> parameter and don't specify the <code>Switchover</code>
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Switching over - Specify the <code>Switchover</code> parameter or omit it, but don't specify the
     * <code>AllowDataLoss</code> parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>About failing over and switching over</b>
     * </p>
     * <p>
     * While failing over and switching over a global database cluster both change the primary DB cluster, you use these
     * operations for different reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Failing over</i> - Use this operation to respond to an unplanned event, such as a Regional disaster in the
     * primary Region. Failing over can result in a loss of write transaction data that wasn't replicated to the chosen
     * secondary before the failover event occurred. However, the recovery process that promotes a DB instance on the
     * chosen seconday DB cluster to be the primary writer DB instance guarantees that the data is in a transactionally
     * consistent state.
     * </p>
     * <p>
     * For more information about failing over an Amazon Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-failover.managed-unplanned"
     * >Performing managed failovers for Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Switching over</i> - Use this operation on a healthy global database cluster for planned events, such as
     * Regional rotation or to fail back to the original primary DB cluster after a failover operation. With this
     * operation, there is no data loss.
     * </p>
     * <p>
     * For more information about switching over an Amazon Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover"
     * >Performing switchovers for Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param failoverGlobalClusterRequest
     * @return A Java Future containing the result of the FailoverGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.FailoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<FailoverGlobalClusterResponse> failoverGlobalCluster(
            FailoverGlobalClusterRequest failoverGlobalClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverGlobalCluster");

            HttpResponseHandler<FailoverGlobalClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(FailoverGlobalClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<FailoverGlobalClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FailoverGlobalClusterRequest, FailoverGlobalClusterResponse>()
                            .withOperationName("FailoverGlobalCluster")
                            .withMarshaller(new FailoverGlobalClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(failoverGlobalClusterRequest));
            CompletableFuture<FailoverGlobalClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags on an Amazon RDS resource.
     * </p>
     * <p>
     * For an overview on tagging an Amazon RDS resource, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS
     * Resources</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked
     * policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you
     * can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream
     * isn't required. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html"> Modifying a
     * database activity stream</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation is supported for RDS for Oracle and Microsoft SQL Server.
     * </p>
     *
     * @param modifyActivityStreamRequest
     * @return A Java Future containing the result of the ModifyActivityStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyActivityStreamResponse> modifyActivityStream(
            ModifyActivityStreamRequest modifyActivityStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyActivityStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyActivityStream");

            HttpResponseHandler<ModifyActivityStreamResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyActivityStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyActivityStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyActivityStreamRequest, ModifyActivityStreamResponse>()
                            .withOperationName("ModifyActivityStream")
                            .withMarshaller(new ModifyActivityStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyActivityStreamRequest));
            CompletableFuture<ModifyActivityStreamResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS
     * for new DB instances, or remove the override.
     * </p>
     * <p>
     * By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB instances that is
     * different from the default certificate provided by RDS. You can also use this operation to remove the override,
     * so that new DB instances use the default certificate provided by RDS.
     * </p>
     * <p>
     * You might need to override the default certificate in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You already migrated your applications to support the latest certificate authority (CA) certificate, but the new
     * CA certificate is not yet the RDS default CA certificate for the specified Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS has already moved to a new default CA certificate for the specified Amazon Web Services Region, but you are
     * still in the process of supporting the new CA certificate. In this case, you temporarily need additional time to
     * finish your application changes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param modifyCertificatesRequest
     * @return A Java Future containing the result of the ModifyCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCertificatesResponse> modifyCertificates(ModifyCertificatesRequest modifyCertificatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCertificates");

            HttpResponseHandler<ModifyCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCertificatesRequest, ModifyCertificatesResponse>()
                            .withOperationName("ModifyCertificates")
                            .withMarshaller(new ModifyCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyCertificatesRequest));
            CompletableFuture<ModifyCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
     * </p>
     * <p>
     * Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might
     * not scale fast enough to meet a sudden change in workload, such as a large number of new transactions. Call
     * <code>ModifyCurrentDBClusterCapacity</code> to set the capacity explicitly.
     * </p>
     * <p>
     * After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale the DB cluster based
     * on the cooldown period for scaling up and the cooldown period for scaling down.
     * </p>
     * <p>
     * For more information about Aurora Serverless v1, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
     * Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you call <code>ModifyCurrentDBClusterCapacity</code> with the default <code>TimeoutAction</code>, connections
     * that prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about
     * scaling points, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     * > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * This action only applies to Aurora Serverless v1 DB clusters.
     * </p>
     * </note>
     *
     * @param modifyCurrentDbClusterCapacityRequest
     * @return A Java Future containing the result of the ModifyCurrentDBClusterCapacity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbClusterCapacityException <code>Capacity</code> isn't a valid Aurora Serverless DB cluster
     *         capacity. Valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>,
     *         <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyCurrentDBClusterCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCurrentDbClusterCapacityResponse> modifyCurrentDBClusterCapacity(
            ModifyCurrentDbClusterCapacityRequest modifyCurrentDbClusterCapacityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyCurrentDbClusterCapacityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCurrentDBClusterCapacity");

            HttpResponseHandler<ModifyCurrentDbClusterCapacityResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCurrentDbClusterCapacityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCurrentDbClusterCapacityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCurrentDbClusterCapacityRequest, ModifyCurrentDbClusterCapacityResponse>()
                            .withOperationName("ModifyCurrentDBClusterCapacity")
                            .withMarshaller(new ModifyCurrentDbClusterCapacityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyCurrentDbClusterCapacityRequest));
            CompletableFuture<ModifyCurrentDbClusterCapacityResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling
     * <code>DescribeDBEngineVersions</code>.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>ModifyCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>ModifyCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify">Modifying CEV
     * status</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param modifyCustomDbEngineVersionRequest
     * @return A Java Future containing the result of the ModifyCustomDBEngineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomDbEngineVersionNotFoundException The specified CEV was not found.</li>
     *         <li>InvalidCustomDbEngineVersionStateException You can't delete the CEV.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCustomDbEngineVersionResponse> modifyCustomDBEngineVersion(
            ModifyCustomDbEngineVersionRequest modifyCustomDbEngineVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCustomDbEngineVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCustomDBEngineVersion");

            HttpResponseHandler<ModifyCustomDbEngineVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCustomDbEngineVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCustomDbEngineVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCustomDbEngineVersionRequest, ModifyCustomDbEngineVersionResponse>()
                            .withOperationName("ModifyCustomDBEngineVersion")
                            .withMarshaller(new ModifyCustomDbEngineVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyCustomDbEngineVersionRequest));
            CompletableFuture<ModifyCustomDbEngineVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more
     * settings by specifying these parameters and the new values in the request.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param modifyDbClusterRequest
     * @return A Java Future containing the result of the ModifyDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbClusterAlreadyExistsException The user already has a DB cluster with the given identifier.</li>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>StorageTypeNotAvailableException The <code>aurora-iopt1</code> storage type isn't available, because
     *         you modified the DB cluster to use this storage type less than one month ago.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbClusterResponse> modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBCluster");

            HttpResponseHandler<ModifyDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterRequest, ModifyDbClusterResponse>()
                            .withOperationName("ModifyDBCluster")
                            .withMarshaller(new ModifyDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbClusterRequest));
            CompletableFuture<ModifyDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param modifyDbClusterEndpointRequest
     * @return A Java Future containing the result of the ModifyDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbClusterEndpointStateException The requested operation can't be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbClusterEndpointResponse> modifyDBClusterEndpoint(
            ModifyDbClusterEndpointRequest modifyDbClusterEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterEndpoint");

            HttpResponseHandler<ModifyDbClusterEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbClusterEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbClusterEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterEndpointRequest, ModifyDbClusterEndpointResponse>()
                            .withOperationName("ModifyDBClusterEndpoint")
                            .withMarshaller(new ModifyDbClusterEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbClusterEndpointRequest));
            CompletableFuture<ModifyDbClusterEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS
     * console</a> or the <code>DescribeDBClusterParameters</code> operation to verify that your DB cluster parameter
     * group has been created or modified.
     * </p>
     * <p>
     * If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora applies the update
     * immediately. The cluster restart might interrupt your workload. In that case, your application must reopen any
     * connections and retry any transactions that were active when the parameter changes took effect.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param modifyDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the ModifyDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbClusterParameterGroupResponse> modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterParameterGroup");

            HttpResponseHandler<ModifyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterParameterGroupRequest, ModifyDbClusterParameterGroupResponse>()
                            .withOperationName("ModifyDBClusterParameterGroup")
                            .withMarshaller(new ModifyDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbClusterParameterGroupRequest));
            CompletableFuture<ModifyDbClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify <code>restore</code> as
     * the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon
     * Web Services accounts that are authorized to restore the manual DB cluster snapshot. Use the value
     * <code>all</code> to make the manual DB cluster snapshot public, which means that it can be copied or restored by
     * all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB cluster snapshots that contain private information that
     * you don't want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized
     * Amazon Web Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a
     * value for that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster snapshot, or
     * whether a manual DB cluster snapshot is public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API
     * operation. The accounts are returned as values for the <code>restore</code> attribute.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     * @return A Java Future containing the result of the ModifyDBClusterSnapshotAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>SharedSnapshotQuotaExceededException You have exceeded the maximum number of accounts that you can
     *         share a manual DB snapshot with.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterSnapshotAttribute");

            HttpResponseHandler<ModifyDbClusterSnapshotAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterSnapshotAttributeRequest, ModifyDbClusterSnapshotAttributeResponse>()
                            .withOperationName("ModifyDBClusterSnapshotAttribute")
                            .withMarshaller(new ModifyDbClusterSnapshotAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbClusterSnapshotAttributeRequest));
            CompletableFuture<ModifyDbClusterSnapshotAttributeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <code>DescribeValidDBInstanceModifications</code> before you call <code>ModifyDBInstance</code>.
     * </p>
     *
     * @param modifyDbInstanceRequest
     * @return A Java Future containing the result of the ModifyDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>DbUpgradeDependencyFailureException The DB upgrade failed because a resource the DB depends on can't
     *         be modified.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbInstanceResponse> modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBInstance");

            HttpResponseHandler<ModifyDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbInstanceRequest, ModifyDbInstanceResponse>()
                            .withOperationName("ModifyDBInstance")
                            .withMarshaller(new ModifyDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbInstanceRequest));
            CompletableFuture<ModifyDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param modifyDbParameterGroupRequest
     * @return A Java Future containing the result of the ModifyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbParameterGroupResponse> modifyDBParameterGroup(
            ModifyDbParameterGroupRequest modifyDbParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBParameterGroup");

            HttpResponseHandler<ModifyDbParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbParameterGroupRequest, ModifyDbParameterGroupResponse>()
                            .withOperationName("ModifyDBParameterGroup")
                            .withMarshaller(new ModifyDbParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbParameterGroupRequest));
            CompletableFuture<ModifyDbParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy.
     * </p>
     *
     * @param modifyDbProxyRequest
     * @return A Java Future containing the result of the ModifyDBProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyAlreadyExistsException The specified proxy name must be unique for all proxies owned by your
     *         Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbProxyResponse> modifyDBProxy(ModifyDbProxyRequest modifyDbProxyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBProxy");

            HttpResponseHandler<ModifyDbProxyResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbProxyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbProxyRequest, ModifyDbProxyResponse>()
                            .withOperationName("ModifyDBProxy")
                            .withMarshaller(new ModifyDbProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbProxyRequest));
            CompletableFuture<ModifyDbProxyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy endpoint.
     * </p>
     *
     * @param modifyDbProxyEndpointRequest
     * @return A Java Future containing the result of the ModifyDBProxyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>DbProxyEndpointAlreadyExistsException The specified DB proxy endpoint name must be unique for all DB
     *         proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyEndpointStateException You can't perform this operation while the DB proxy endpoint is
     *         in a particular state.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbProxyEndpointResponse> modifyDBProxyEndpoint(
            ModifyDbProxyEndpointRequest modifyDbProxyEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbProxyEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBProxyEndpoint");

            HttpResponseHandler<ModifyDbProxyEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbProxyEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbProxyEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbProxyEndpointRequest, ModifyDbProxyEndpointResponse>()
                            .withOperationName("ModifyDBProxyEndpoint")
                            .withMarshaller(new ModifyDbProxyEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbProxyEndpointRequest));
            CompletableFuture<ModifyDbProxyEndpointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the properties of a <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param modifyDbProxyTargetGroupRequest
     * @return A Java Future containing the result of the ModifyDBProxyTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBProxyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbProxyTargetGroupResponse> modifyDBProxyTargetGroup(
            ModifyDbProxyTargetGroupRequest modifyDbProxyTargetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbProxyTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBProxyTargetGroup");

            HttpResponseHandler<ModifyDbProxyTargetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbProxyTargetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbProxyTargetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbProxyTargetGroupRequest, ModifyDbProxyTargetGroupResponse>()
                            .withOperationName("ModifyDBProxyTargetGroup")
                            .withMarshaller(new ModifyDbProxyTargetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbProxyTargetGroupRequest));
            CompletableFuture<ModifyDbProxyTargetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not
     * shared or public.
     * </p>
     * <p>
     * Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This command doesn't apply to RDS
     * Custom.
     * </p>
     *
     * @param modifyDbSnapshotRequest
     * @return A Java Future containing the result of the ModifyDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbSnapshotResponse> modifyDBSnapshot(ModifyDbSnapshotRequest modifyDbSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBSnapshot");

            HttpResponseHandler<ModifyDbSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbSnapshotRequest, ModifyDbSnapshotResponse>()
                            .withOperationName("ModifyDBSnapshot")
                            .withMarshaller(new ModifyDbSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbSnapshotRequest));
            CompletableFuture<ModifyDbSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
     * </p>
     * <p>
     * To share a manual DB snapshot with other Amazon Web Services accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon Web
     * Services accounts that are authorized to restore the manual DB snapshot. Uses the value <code>all</code> to make
     * the manual DB snapshot public, which means it can be copied or restored by all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB snapshots that contain private information that you don't
     * want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If the manual DB snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web
     * Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a value for
     * that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or whether a
     * manual DB snapshot public or private, use the <a>DescribeDBSnapshotAttributes</a> API operation. The accounts are
     * returned as values for the <code>restore</code> attribute.
     * </p>
     *
     * @param modifyDbSnapshotAttributeRequest
     * @return A Java Future containing the result of the ModifyDBSnapshotAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>SharedSnapshotQuotaExceededException You have exceeded the maximum number of accounts that you can
     *         share a manual DB snapshot with.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbSnapshotAttributeResponse> modifyDBSnapshotAttribute(
            ModifyDbSnapshotAttributeRequest modifyDbSnapshotAttributeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbSnapshotAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBSnapshotAttribute");

            HttpResponseHandler<ModifyDbSnapshotAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbSnapshotAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbSnapshotAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbSnapshotAttributeRequest, ModifyDbSnapshotAttributeResponse>()
                            .withOperationName("ModifyDBSnapshotAttribute")
                            .withMarshaller(new ModifyDbSnapshotAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbSnapshotAttributeRequest));
            CompletableFuture<ModifyDbSnapshotAttributeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the Amazon Web Services Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     * @return A Java Future containing the result of the ModifyDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetQuotaExceededException The request would result in the user exceeding the allowed number of
     *         subnets in a DB subnet groups.</li>
     *         <li>SubnetAlreadyInUseException The DB subnet is already in use in the Availability Zone.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDbSubnetGroupResponse> modifyDBSubnetGroup(
            ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBSubnetGroup");

            HttpResponseHandler<ModifyDbSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyDbSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyDbSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDbSubnetGroupRequest, ModifyDbSubnetGroupResponse>()
                            .withOperationName("ModifyDBSubnetGroup")
                            .withMarshaller(new ModifyDbSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDbSubnetGroupRequest));
            CompletableFuture<ModifyDbSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this
     * call. To change source identifiers for a subscription, use the <code>AddSourceIdentifierToSubscription</code> and
     * <code>RemoveSourceIdentifierFromSubscription</code> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given source type (<code>SourceType</code>) in <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS
     * User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have reached the maximum number of event subscriptions.</li>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SnsInvalidTopicException SNS has responded that there is a problem with the SNS topic specified.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the SNS topic ARN.</li>
     *         <li>SnsTopicArnNotFoundException The SNS topic ARN does not exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The supplied category does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEventSubscription");

            HttpResponseHandler<ModifyEventSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyEventSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse>()
                            .withOperationName("ModifyEventSubscription")
                            .withMarshaller(new ModifyEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyEventSubscriptionRequest));
            CompletableFuture<ModifyEventSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a setting for an Amazon Aurora global database cluster. You can change one or more database
     * configuration parameters by specifying these parameters and the new values in the request. For more information
     * on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation only applies to Aurora global database clusters.
     * </p>
     * </note>
     *
     * @param modifyGlobalClusterRequest
     * @return A Java Future containing the result of the ModifyGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyGlobalClusterResponse> modifyGlobalCluster(
            ModifyGlobalClusterRequest modifyGlobalClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyGlobalCluster");

            HttpResponseHandler<ModifyGlobalClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyGlobalClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyGlobalClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyGlobalClusterRequest, ModifyGlobalClusterResponse>()
                            .withOperationName("ModifyGlobalCluster")
                            .withMarshaller(new ModifyGlobalClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyGlobalClusterRequest));
            CompletableFuture<ModifyGlobalClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an existing option group.
     * </p>
     *
     * @param modifyOptionGroupRequest
     * @return A Java Future containing the result of the ModifyOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOptionGroupStateException The option group isn't in the <i>available</i> state.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ModifyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyOptionGroupResponse> modifyOptionGroup(ModifyOptionGroupRequest modifyOptionGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyOptionGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyOptionGroup");

            HttpResponseHandler<ModifyOptionGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyOptionGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyOptionGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyOptionGroupRequest, ModifyOptionGroupResponse>()
                            .withOperationName("ModifyOptionGroup")
                            .withMarshaller(new ModifyOptionGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyOptionGroupRequest));
            CompletableFuture<ModifyOptionGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Promotes a read replica DB instance to a standalone DB instance.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Backup duration is a function of the amount of changes to the database since the previous backup. If you plan to
     * promote a read replica to a standalone instance, we recommend that you enable backups and complete at least one
     * backup prior to promotion. In addition, a read replica cannot be promoted to a standalone instance when it is in
     * the <code>backing-up</code> status. If you have enabled backups on your read replica, configure the automated
     * backup window so that daily backups do not interfere with read replica promotion.
     * </p>
     * </li>
     * <li>
     * <p>
     * This command doesn't apply to Aurora MySQL, Aurora PostgreSQL, or RDS Custom.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param promoteReadReplicaRequest
     * @return A Java Future containing the result of the PromoteReadReplica operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.PromoteReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplica" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PromoteReadReplicaResponse> promoteReadReplica(PromoteReadReplicaRequest promoteReadReplicaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, promoteReadReplicaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PromoteReadReplica");

            HttpResponseHandler<PromoteReadReplicaResponse> responseHandler = protocolFactory
                    .createResponseHandler(PromoteReadReplicaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PromoteReadReplicaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PromoteReadReplicaRequest, PromoteReadReplicaResponse>()
                            .withOperationName("PromoteReadReplica")
                            .withMarshaller(new PromoteReadReplicaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(promoteReadReplicaRequest));
            CompletableFuture<PromoteReadReplicaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Promotes a read replica DB cluster to a standalone DB cluster.
     * </p>
     *
     * @param promoteReadReplicaDbClusterRequest
     * @return A Java Future containing the result of the PromoteReadReplicaDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.PromoteReadReplicaDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PromoteReadReplicaDbClusterResponse> promoteReadReplicaDBCluster(
            PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, promoteReadReplicaDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PromoteReadReplicaDBCluster");

            HttpResponseHandler<PromoteReadReplicaDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(PromoteReadReplicaDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PromoteReadReplicaDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PromoteReadReplicaDbClusterRequest, PromoteReadReplicaDbClusterResponse>()
                            .withOperationName("PromoteReadReplicaDBCluster")
                            .withMarshaller(new PromoteReadReplicaDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(promoteReadReplicaDbClusterRequest));
            CompletableFuture<PromoteReadReplicaDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Purchases a reserved DB instance offering.
     * </p>
     *
     * @param purchaseReservedDbInstancesOfferingRequest
     * @return A Java Future containing the result of the PurchaseReservedDBInstancesOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>ReservedDbInstanceAlreadyExistsException User already has a reservation with the given identifier.</li>
     *         <li>ReservedDbInstanceQuotaExceededException Request would exceed the user's DB Instance quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.PurchaseReservedDBInstancesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseReservedDbInstancesOfferingResponse> purchaseReservedDBInstancesOffering(
            PurchaseReservedDbInstancesOfferingRequest purchaseReservedDbInstancesOfferingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedDbInstancesOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedDBInstancesOffering");

            HttpResponseHandler<PurchaseReservedDbInstancesOfferingResponse> responseHandler = protocolFactory
                    .createResponseHandler(PurchaseReservedDbInstancesOfferingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PurchaseReservedDbInstancesOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedDbInstancesOfferingRequest, PurchaseReservedDbInstancesOfferingResponse>()
                            .withOperationName("PurchaseReservedDBInstancesOffering")
                            .withMarshaller(new PurchaseReservedDbInstancesOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(purchaseReservedDbInstancesOfferingRequest));
            CompletableFuture<PurchaseReservedDbInstancesOfferingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * You might need to reboot your DB cluster, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB cluster parameter group associated with the DB cluster, reboot the DB
     * cluster for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB cluster restarts the database engine service. Rebooting a DB cluster results in a momentary
     * outage, during which the DB cluster status is set to rebooting.
     * </p>
     * <p>
     * Use this operation only for a non-Aurora Multi-AZ DB cluster.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param rebootDbClusterRequest
     * @return A Java Future containing the result of the RebootDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RebootDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootDbClusterResponse> rebootDBCluster(RebootDbClusterRequest rebootDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDBCluster");

            HttpResponseHandler<RebootDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(RebootDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RebootDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootDbClusterRequest, RebootDbClusterResponse>()
                            .withOperationName("RebootDBCluster")
                            .withMarshaller(new RebootDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(rebootDbClusterRequest));
            CompletableFuture<RebootDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to rebooting.
     * </p>
     * <p>
     * For more information about rebooting, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html">Rebooting a DB
     * Instance</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * If your DB instance is part of a Multi-AZ DB cluster, you can reboot the DB cluster with the
     * <code>RebootDBCluster</code> operation.
     * </p>
     *
     * @param rebootDbInstanceRequest
     * @return A Java Future containing the result of the RebootDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RebootDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootDbInstanceResponse> rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDBInstance");

            HttpResponseHandler<RebootDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(RebootDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RebootDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootDbInstanceRequest, RebootDbInstanceResponse>()
                            .withOperationName("RebootDBInstance")
                            .withMarshaller(new RebootDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(rebootDbInstanceRequest));
            CompletableFuture<RebootDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate one or more <code>DBProxyTarget</code> data structures with a <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param registerDbProxyTargetsRequest
     * @return A Java Future containing the result of the RegisterDBProxyTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbProxyTargetAlreadyRegisteredException The proxy is already associated with the specified RDS DB
     *         instance or Aurora DB cluster.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>InsufficientAvailableIPsInSubnetException The requested operation can't be performed because there
     *         aren't enough available IP addresses in the proxy's subnets. Add more CIDR blocks to the VPC or remove IP
     *         address that aren't required from the subnets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RegisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RegisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterDbProxyTargetsResponse> registerDBProxyTargets(
            RegisterDbProxyTargetsRequest registerDbProxyTargetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerDbProxyTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterDBProxyTargets");

            HttpResponseHandler<RegisterDbProxyTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(RegisterDbProxyTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RegisterDbProxyTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterDbProxyTargetsRequest, RegisterDbProxyTargetsResponse>()
                            .withOperationName("RegisterDBProxyTargets")
                            .withMarshaller(new RegisterDbProxyTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerDbProxyTargetsRequest));
            CompletableFuture<RegisterDbProxyTargetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a standalone
     * cluster with read-write capability instead of being read-only and receiving data from a primary cluster in a
     * different Region.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param removeFromGlobalClusterRequest
     * @return A Java Future containing the result of the RemoveFromGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RemoveFromGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveFromGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveFromGlobalClusterResponse> removeFromGlobalCluster(
            RemoveFromGlobalClusterRequest removeFromGlobalClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFromGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFromGlobalCluster");

            HttpResponseHandler<RemoveFromGlobalClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveFromGlobalClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveFromGlobalClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveFromGlobalClusterRequest, RemoveFromGlobalClusterResponse>()
                            .withOperationName("RemoveFromGlobalCluster")
                            .withMarshaller(new RemoveFromGlobalClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeFromGlobalClusterRequest));
            CompletableFuture<RemoveFromGlobalClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param removeRoleFromDbClusterRequest
     * @return A Java Future containing the result of the RemoveRoleFromDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleNotFoundException The specified IAM role Amazon Resource Name (ARN) isn't associated
     *         with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RemoveRoleFromDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveRoleFromDbClusterResponse> removeRoleFromDBCluster(
            RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeRoleFromDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRoleFromDBCluster");

            HttpResponseHandler<RemoveRoleFromDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveRoleFromDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveRoleFromDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveRoleFromDbClusterRequest, RemoveRoleFromDbClusterResponse>()
                            .withOperationName("RemoveRoleFromDBCluster")
                            .withMarshaller(new RemoveRoleFromDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeRoleFromDbClusterRequest));
            CompletableFuture<RemoveRoleFromDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.
     * </p>
     *
     * @param removeRoleFromDbInstanceRequest
     * @return A Java Future containing the result of the RemoveRoleFromDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceRoleNotFoundException The specified <code>RoleArn</code> value doesn't match the specified
     *         feature for the DB instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RemoveRoleFromDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveRoleFromDbInstanceResponse> removeRoleFromDBInstance(
            RemoveRoleFromDbInstanceRequest removeRoleFromDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeRoleFromDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRoleFromDBInstance");

            HttpResponseHandler<RemoveRoleFromDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveRoleFromDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveRoleFromDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveRoleFromDbInstanceRequest, RemoveRoleFromDbInstanceResponse>()
                            .withOperationName("RemoveRoleFromDBInstance")
                            .withMarshaller(new RemoveRoleFromDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeRoleFromDbInstanceRequest));
            CompletableFuture<RemoveRoleFromDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a source identifier from an existing RDS event notification subscription.
     * </p>
     *
     * @param removeSourceIdentifierFromSubscriptionRequest
     * @return A Java Future containing the result of the RemoveSourceIdentifierFromSubscription operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SourceNotFoundException The requested source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RemoveSourceIdentifierFromSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> removeSourceIdentifierFromSubscription(
            RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeSourceIdentifierFromSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveSourceIdentifierFromSubscription");

            HttpResponseHandler<RemoveSourceIdentifierFromSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveSourceIdentifierFromSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveSourceIdentifierFromSubscriptionRequest, RemoveSourceIdentifierFromSubscriptionResponse>()
                            .withOperationName("RemoveSourceIdentifierFromSubscription")
                            .withMarshaller(new RemoveSourceIdentifierFromSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeSourceIdentifierFromSubscriptionRequest));
            CompletableFuture<RemoveSourceIdentifierFromSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon RDS resource.
     * </p>
     * <p>
     * For an overview on tagging an Amazon RDS resource, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS
     * Resources</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");

            HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveTagsFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveTagsFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource")
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeTagsFromResourceRequest));
            CompletableFuture<RemoveTagsFromResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit
     * a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request. You must call <code>RebootDBInstance</code> for every DB instance in your DB cluster that you want the
     * updated static parameter to apply to.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the ResetDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ResetDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetDbClusterParameterGroupResponse> resetDBClusterParameterGroup(
            ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDbClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDBClusterParameterGroup");

            HttpResponseHandler<ResetDbClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResetDbClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResetDbClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetDbClusterParameterGroupRequest, ResetDbClusterParameterGroupResponse>()
                            .withOperationName("ResetDBClusterParameterGroup")
                            .withMarshaller(new ResetDbClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetDbClusterParameterGroupRequest));
            CompletableFuture<ResetDbClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters,
     * provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request.
     * </p>
     *
     * @param resetDbParameterGroupRequest
     * @return A Java Future containing the result of the ResetDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ResetDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetDbParameterGroupResponse> resetDBParameterGroup(
            ResetDbParameterGroupRequest resetDbParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDBParameterGroup");

            HttpResponseHandler<ResetDbParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResetDbParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResetDbParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetDbParameterGroupRequest, ResetDbParameterGroupResponse>()
                            .withOperationName("ResetDBParameterGroup")
                            .withMarshaller(new ResetDbParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetDbParameterGroupRequest));
            CompletableFuture<ResetDbParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon RDS must be authorized
     * to access the Amazon S3 bucket and the data must be created using the Percona XtraBackup utility as described in
     * <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3"
     * > Migrating Data from MySQL by Using an Amazon S3 Bucket</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <code>CreateDBInstance</code> action to create DB instances for the restored DB cluster, specifying the
     * identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after
     * the <code>RestoreDBClusterFromS3</code> action has completed and the DB cluster is available.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters. The source DB engine must be MySQL.
     * </p>
     * </note>
     *
     * @param restoreDbClusterFromS3Request
     * @return A Java Future containing the result of the RestoreDBClusterFromS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException The user already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidS3BucketException The specified Amazon S3 bucket name can't be found or Amazon RDS isn't
     *         authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and
     *         <b>S3IngestionRoleArn</b> values and try again.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RestoreDBClusterFromS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbClusterFromS3Response> restoreDBClusterFromS3(
            RestoreDbClusterFromS3Request restoreDbClusterFromS3Request) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreDbClusterFromS3Request
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterFromS3");

            HttpResponseHandler<RestoreDbClusterFromS3Response> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbClusterFromS3Response::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbClusterFromS3Response> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterFromS3Request, RestoreDbClusterFromS3Response>()
                            .withOperationName("RestoreDBClusterFromS3")
                            .withMarshaller(new RestoreDbClusterFromS3RequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restoreDbClusterFromS3Request));
            CompletableFuture<RestoreDbClusterFromS3Response> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * The target DB cluster is created from the source snapshot with a default configuration. If you don't specify a
     * security group, the new DB cluster is associated with the default security group.
     * </p>
     * <note>
     * <p>
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <code>CreateDBInstance</code> action to create DB instances for the restored DB cluster, specifying the
     * identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after
     * the <code>RestoreDBClusterFromSnapshot</code> action has completed and the DB cluster is available.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreDBClusterFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException The user already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster doesn't have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidRestoreException Cannot restore from VPC backup to non-VPC DB instance.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RestoreDBClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbClusterFromSnapshotResponse> restoreDBClusterFromSnapshot(
            RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreDbClusterFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterFromSnapshot");

            HttpResponseHandler<RestoreDbClusterFromSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbClusterFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterFromSnapshotRequest, RestoreDbClusterFromSnapshotResponse>()
                            .withOperationName("RestoreDBClusterFromSnapshot")
                            .withMarshaller(new RestoreDbClusterFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restoreDbClusterFromSnapshotRequest));
            CompletableFuture<RestoreDbClusterFromSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     * <note>
     * <p>
     * For Aurora, this action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke
     * the <code>CreateDBInstance</code> action to create DB instances for the restored DB cluster, specifying the
     * identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after
     * the <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param restoreDbClusterToPointInTimeRequest
     * @return A Java Future containing the result of the RestoreDBClusterToPointInTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException The user already has a DB cluster with the given identifier.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InsufficientDbClusterCapacityException The DB cluster doesn't have enough capacity for the current
     *         operation.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>InvalidRestoreException Cannot restore from VPC backup to non-VPC DB instance.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RestoreDBClusterToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbClusterToPointInTimeResponse> restoreDBClusterToPointInTime(
            RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterToPointInTime");

            HttpResponseHandler<RestoreDbClusterToPointInTimeResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbClusterToPointInTimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterToPointInTimeRequest, RestoreDbClusterToPointInTimeResponse>()
                            .withOperationName("RestoreDBClusterToPointInTime")
                            .withMarshaller(new RestoreDbClusterToPointInTimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restoreDbClusterToPointInTimeRequest));
            CompletableFuture<RestoreDbClusterToPointInTimeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new DB instance from a DB snapshot. The target database is created from the source database restore
     * point with most of the source's original configuration, including the default security group and DB parameter
     * group. By default, the new DB instance is created as a Single-AZ deployment, except when the instance is a SQL
     * Server instance that has an option group associated with mirroring. In this case, the instance becomes a Multi-AZ
     * deployment, not a Single-AZ deployment.
     * </p>
     * <p>
     * If you want to replace your original DB instance with the new, restored DB instance, then rename your original DB
     * instance before you call the RestoreDBInstanceFromDBSnapshot action. RDS doesn't allow two DB instances with the
     * same name. After you have renamed your original DB instance with a different identifier, then you can pass the
     * original name of the DB instance as the DBInstanceIdentifier in the call to the RestoreDBInstanceFromDBSnapshot
     * action. The result is that you replace the original DB instance with the DB instance created from the snapshot.
     * </p>
     * <p>
     * If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of
     * the shared DB snapshot.
     * </p>
     * <note>
     * <p>
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use
     * <code>RestoreDBClusterFromSnapshot</code>.
     * </p>
     * </note>
     *
     * @param restoreDbInstanceFromDbSnapshotRequest
     * @return A Java Future containing the result of the RestoreDBInstanceFromDBSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidRestoreException Cannot restore from VPC backup to non-VPC DB instance.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RestoreDBInstanceFromDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbInstanceFromDbSnapshotResponse> restoreDBInstanceFromDBSnapshot(
            RestoreDbInstanceFromDbSnapshotRequest restoreDbInstanceFromDbSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreDbInstanceFromDbSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBInstanceFromDBSnapshot");

            HttpResponseHandler<RestoreDbInstanceFromDbSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbInstanceFromDbSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbInstanceFromDbSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbInstanceFromDbSnapshotRequest, RestoreDbInstanceFromDbSnapshotResponse>()
                            .withOperationName("RestoreDBInstanceFromDBSnapshot")
                            .withMarshaller(new RestoreDbInstanceFromDbSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restoreDbInstanceFromDbSnapshotRequest));
            CompletableFuture<RestoreDbInstanceFromDbSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using backup files. You can
     * create a backup of your on-premises database, store it on Amazon Simple Storage Service (Amazon S3), and then
     * restore the backup file onto a new Amazon RDS DB instance running MySQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html">Importing Data into
     * an Amazon RDS MySQL DB Instance</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param restoreDbInstanceFromS3Request
     * @return A Java Future containing the result of the RestoreDBInstanceFromS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidS3BucketException The specified Amazon S3 bucket name can't be found or Amazon RDS isn't
     *         authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and
     *         <b>S3IngestionRoleArn</b> values and try again.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RestoreDBInstanceFromS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromS3" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbInstanceFromS3Response> restoreDBInstanceFromS3(
            RestoreDbInstanceFromS3Request restoreDbInstanceFromS3Request) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreDbInstanceFromS3Request
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBInstanceFromS3");

            HttpResponseHandler<RestoreDbInstanceFromS3Response> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbInstanceFromS3Response::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbInstanceFromS3Response> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbInstanceFromS3Request, RestoreDbInstanceFromS3Response>()
                            .withOperationName("RestoreDBInstanceFromS3")
                            .withMarshaller(new RestoreDbInstanceFromS3RequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restoreDbInstanceFromS3Request));
            CompletableFuture<RestoreDbInstanceFromS3Response> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time
     * identified by the <code>LatestRestorableTime</code> property. You can restore to a point up to the number of days
     * specified by the <code>BackupRetentionPeriod</code> property.
     * </p>
     * <p>
     * The target database is created with most of the original configuration, but in a system-selected Availability
     * Zone, with the default security group, the default subnet group, and the default DB parameter group. By default,
     * the new DB instance is created as a single-AZ deployment except when the instance is a SQL Server instance that
     * has an option group that is associated with mirroring; in this case, the instance becomes a mirrored deployment
     * and not a single-AZ deployment.
     * </p>
     * <note>
     * <p>
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use
     * <code>RestoreDBClusterToPointInTime</code>.
     * </p>
     * </note>
     *
     * @param restoreDbInstanceToPointInTimeRequest
     * @return A Java Future containing the result of the RestoreDBInstanceToPointInTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>PointInTimeRestoreNotEnabledException <code>SourceDBInstanceIdentifier</code> refers to a DB instance
     *         with <code>BackupRetentionPeriod</code> equal to 0.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidRestoreException Cannot restore from VPC backup to non-VPC DB instance.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RestoreDBInstanceToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreDbInstanceToPointInTimeResponse> restoreDBInstanceToPointInTime(
            RestoreDbInstanceToPointInTimeRequest restoreDbInstanceToPointInTimeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreDbInstanceToPointInTimeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBInstanceToPointInTime");

            HttpResponseHandler<RestoreDbInstanceToPointInTimeResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreDbInstanceToPointInTimeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreDbInstanceToPointInTimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreDbInstanceToPointInTimeRequest, RestoreDbInstanceToPointInTimeResponse>()
                            .withOperationName("RestoreDBInstanceToPointInTime")
                            .withMarshaller(new RestoreDbInstanceToPointInTimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restoreDbInstanceToPointInTimeRequest));
            CompletableFuture<RestoreDbInstanceToPointInTimeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups.
     * Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and
     * either EC2SecurityGroupName or EC2SecurityGroupId).
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param revokeDbSecurityGroupIngressRequest
     * @return A Java Future containing the result of the RevokeDBSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.RevokeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RevokeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeDbSecurityGroupIngressResponse> revokeDBSecurityGroupIngress(
            RevokeDbSecurityGroupIngressRequest revokeDbSecurityGroupIngressRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeDbSecurityGroupIngressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeDBSecurityGroupIngress");

            HttpResponseHandler<RevokeDbSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(RevokeDbSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RevokeDbSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeDbSecurityGroupIngressRequest, RevokeDbSecurityGroupIngressResponse>()
                            .withOperationName("RevokeDBSecurityGroupIngress")
                            .withMarshaller(new RevokeDbSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(revokeDbSecurityGroupIngressRequest));
            CompletableFuture<RevokeDbSecurityGroupIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a database activity stream to monitor activity on the database. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html"> Monitoring Amazon
     * Aurora with Database Activity Streams</a> in the <i>Amazon Aurora User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html"> Monitoring Amazon RDS with
     * Database Activity Streams</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param startActivityStreamRequest
     * @return A Java Future containing the result of the StartActivityStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StartActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartActivityStreamResponse> startActivityStream(
            StartActivityStreamRequest startActivityStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startActivityStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartActivityStream");

            HttpResponseHandler<StartActivityStreamResponse> responseHandler = protocolFactory
                    .createResponseHandler(StartActivityStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StartActivityStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartActivityStreamRequest, StartActivityStreamResponse>()
                            .withOperationName("StartActivityStream")
                            .withMarshaller(new StartActivityStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startActivityStreamRequest));
            CompletableFuture<StartActivityStreamResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster
     * CLI command, or the StopDBCluster action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html"> Stopping and
     * Starting an Aurora Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param startDbClusterRequest
     * @return A Java Future containing the result of the StartDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StartDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartDbClusterResponse> startDBCluster(StartDbClusterRequest startDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDBCluster");

            HttpResponseHandler<StartDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(StartDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StartDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDbClusterRequest, StartDbClusterResponse>()
                            .withOperationName("StartDBCluster")
                            .withMarshaller(new StartDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startDbClusterRequest));
            CompletableFuture<StartDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console, the stop-db-instance CLI
     * command, or the StopDBInstance action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html"> Starting an Amazon RDS DB
     * instance That Was Previously Stopped</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <note>
     * <p>
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora DB clusters, use
     * <code>StartDBCluster</code> instead.
     * </p>
     * </note>
     *
     * @param startDbInstanceRequest
     * @return A Java Future containing the result of the StartDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StartDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartDbInstanceResponse> startDBInstance(StartDbInstanceRequest startDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDBInstance");

            HttpResponseHandler<StartDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(StartDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StartDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDbInstanceRequest, StartDbInstanceResponse>()
                            .withOperationName("StartDBInstance")
                            .withMarshaller(new StartDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startDbInstanceRequest));
            CompletableFuture<StartDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables replication of automated backups to a different Amazon Web Services Region.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html"> Replicating Automated
     * Backups to Another Amazon Web Services Region</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param startDbInstanceAutomatedBackupsReplicationRequest
     * @return A Java Future containing the result of the StartDBInstanceAutomatedBackupsReplication operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DbInstanceAutomatedBackupQuotaExceededException The quota for retained automated backups was
     *         exceeded. This prevents you from retaining any additional automated backups. The retained automated
     *         backups quota is the same as your DB instance quota.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StartDBInstanceAutomatedBackupsReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstanceAutomatedBackupsReplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDbInstanceAutomatedBackupsReplicationResponse> startDBInstanceAutomatedBackupsReplication(
            StartDbInstanceAutomatedBackupsReplicationRequest startDbInstanceAutomatedBackupsReplicationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startDbInstanceAutomatedBackupsReplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDBInstanceAutomatedBackupsReplication");

            HttpResponseHandler<StartDbInstanceAutomatedBackupsReplicationResponse> responseHandler = protocolFactory
                    .createResponseHandler(StartDbInstanceAutomatedBackupsReplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StartDbInstanceAutomatedBackupsReplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDbInstanceAutomatedBackupsReplicationRequest, StartDbInstanceAutomatedBackupsReplicationResponse>()
                            .withOperationName("StartDBInstanceAutomatedBackupsReplication")
                            .withMarshaller(new StartDbInstanceAutomatedBackupsReplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(startDbInstanceAutomatedBackupsReplicationRequest));
            CompletableFuture<StartDbInstanceAutomatedBackupsReplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an export of DB snapshot or DB cluster data to Amazon S3. The provided IAM role must have access to the S3
     * bucket.
     * </p>
     * <p>
     * You can't export snapshot data from RDS Custom DB instances.
     * </p>
     * <p>
     * You can't export cluster data from Multi-AZ DB clusters.
     * </p>
     * <p>
     * For more information on exporting DB snapshot data, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ExportSnapshot.html">Exporting DB snapshot data
     * to Amazon S3</a> in the <i>Amazon RDS User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-export-snapshot.html">Exporting DB
     * cluster snapshot data to Amazon S3</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on exporting DB cluster data, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/export-cluster-data.html">Exporting DB cluster
     * data to Amazon S3</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param startExportTaskRequest
     * @return A Java Future containing the result of the StartExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>ExportTaskAlreadyExistsException You can't start an export task that's already running.</li>
     *         <li>InvalidS3BucketException The specified Amazon S3 bucket name can't be found or Amazon RDS isn't
     *         authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and
     *         <b>S3IngestionRoleArn</b> values and try again.</li>
     *         <li>IamRoleNotFoundException The IAM role is missing for exporting to an Amazon S3 bucket.</li>
     *         <li>IamRoleMissingPermissionsException The IAM role requires additional permissions to export to an
     *         Amazon S3 bucket.</li>
     *         <li>InvalidExportOnlyException The export is invalid for exporting to an Amazon S3 bucket.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>InvalidExportSourceStateException The state of the export snapshot is invalid for exporting to an
     *         Amazon S3 bucket.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StartExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartExportTaskResponse> startExportTask(StartExportTaskRequest startExportTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartExportTask");

            HttpResponseHandler<StartExportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(StartExportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StartExportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartExportTaskRequest, StartExportTaskResponse>()
                            .withOperationName("StartExportTask")
                            .withMarshaller(new StartExportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startExportTaskRequest));
            CompletableFuture<StartExportTaskResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a database activity stream that was started using the Amazon Web Services console, the
     * <code>start-activity-stream</code> CLI command, or the <code>StartActivityStream</code> action.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html"> Monitoring Amazon
     * Aurora with Database Activity Streams</a> in the <i>Amazon Aurora User Guide</i> or <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html"> Monitoring Amazon RDS with
     * Database Activity Streams</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param stopActivityStreamRequest
     * @return A Java Future containing the result of the StopActivityStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StopActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopActivityStreamResponse> stopActivityStream(StopActivityStreamRequest stopActivityStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopActivityStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopActivityStream");

            HttpResponseHandler<StopActivityStreamResponse> responseHandler = protocolFactory
                    .createResponseHandler(StopActivityStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StopActivityStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopActivityStreamRequest, StopActivityStreamResponse>()
                            .withOperationName("StopActivityStream")
                            .withMarshaller(new StopActivityStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopActivityStreamRequest));
            CompletableFuture<StopActivityStreamResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster's metadata,
     * including its endpoints and DB parameter groups. Aurora also retains the transaction logs so you can do a
     * point-in-time restore if necessary.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html"> Stopping and
     * Starting an Aurora Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param stopDbClusterRequest
     * @return A Java Future containing the result of the StopDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StopDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopDbClusterResponse> stopDBCluster(StopDbClusterRequest stopDbClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDBCluster");

            HttpResponseHandler<StopDbClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(StopDbClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StopDbClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDbClusterRequest, StopDbClusterResponse>()
                            .withOperationName("StopDBCluster")
                            .withMarshaller(new StopDbClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopDbClusterRequest));
            CompletableFuture<StopDbClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB instance's metadata,
     * including its endpoint, DB parameter group, and option group membership. Amazon RDS also retains the transaction
     * logs so you can do a point-in-time restore if necessary.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html"> Stopping an Amazon RDS DB
     * Instance Temporarily</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <note>
     * <p>
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora clusters, use
     * <code>StopDBCluster</code> instead.
     * </p>
     * </note>
     *
     * @param stopDbInstanceRequest
     * @return A Java Future containing the result of the StopDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StopDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopDbInstanceResponse> stopDBInstance(StopDbInstanceRequest stopDbInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDBInstance");

            HttpResponseHandler<StopDbInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(StopDbInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StopDbInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDbInstanceRequest, StopDbInstanceResponse>()
                            .withOperationName("StopDBInstance")
                            .withMarshaller(new StopDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopDbInstanceRequest));
            CompletableFuture<StopDbInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops automated backup replication for a DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html"> Replicating Automated
     * Backups to Another Amazon Web Services Region</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param stopDbInstanceAutomatedBackupsReplicationRequest
     * @return A Java Future containing the result of the StopDBInstanceAutomatedBackupsReplication operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.StopDBInstanceAutomatedBackupsReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstanceAutomatedBackupsReplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopDbInstanceAutomatedBackupsReplicationResponse> stopDBInstanceAutomatedBackupsReplication(
            StopDbInstanceAutomatedBackupsReplicationRequest stopDbInstanceAutomatedBackupsReplicationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopDbInstanceAutomatedBackupsReplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDBInstanceAutomatedBackupsReplication");

            HttpResponseHandler<StopDbInstanceAutomatedBackupsReplicationResponse> responseHandler = protocolFactory
                    .createResponseHandler(StopDbInstanceAutomatedBackupsReplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StopDbInstanceAutomatedBackupsReplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDbInstanceAutomatedBackupsReplicationRequest, StopDbInstanceAutomatedBackupsReplicationResponse>()
                            .withOperationName("StopDBInstanceAutomatedBackupsReplication")
                            .withMarshaller(new StopDbInstanceAutomatedBackupsReplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(stopDbInstanceAutomatedBackupsReplicationRequest));
            CompletableFuture<StopDbInstanceAutomatedBackupsReplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Switches over a blue/green deployment.
     * </p>
     * <p>
     * Before you switch over, production traffic is routed to the databases in the blue environment. After you switch
     * over, production traffic is routed to the databases in the green environment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param switchoverBlueGreenDeploymentRequest
     * @return A Java Future containing the result of the SwitchoverBlueGreenDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>InvalidBlueGreenDeploymentStateException The blue/green deployment can't be switched over or deleted
     *         because there is an invalid configuration in the green environment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.SwitchoverBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/SwitchoverBlueGreenDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SwitchoverBlueGreenDeploymentResponse> switchoverBlueGreenDeployment(
            SwitchoverBlueGreenDeploymentRequest switchoverBlueGreenDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                switchoverBlueGreenDeploymentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SwitchoverBlueGreenDeployment");

            HttpResponseHandler<SwitchoverBlueGreenDeploymentResponse> responseHandler = protocolFactory
                    .createResponseHandler(SwitchoverBlueGreenDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SwitchoverBlueGreenDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SwitchoverBlueGreenDeploymentRequest, SwitchoverBlueGreenDeploymentResponse>()
                            .withOperationName("SwitchoverBlueGreenDeployment")
                            .withMarshaller(new SwitchoverBlueGreenDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(switchoverBlueGreenDeploymentRequest));
            CompletableFuture<SwitchoverBlueGreenDeploymentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Switches over the specified secondary DB cluster to be the new primary DB cluster in the global database cluster.
     * Switchover operations were previously called "managed planned failovers."
     * </p>
     * <p>
     * Aurora promotes the specified secondary cluster to assume full read/write capabilities and demotes the current
     * primary cluster to a secondary (read-only) cluster, maintaining the orginal replication topology. All secondary
     * clusters are synchronized with the primary at the beginning of the process so the new primary continues
     * operations for the Aurora global database without losing any data. Your database is unavailable for a short time
     * while the primary and selected secondary clusters are assuming their new roles. For more information about
     * switching over an Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover"
     * >Performing switchovers for Amazon Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation is intended for controlled environments, for operations such as "regional rotation" or to fall
     * back to the original primary after a global database failover.
     * </p>
     * </note>
     *
     * @param switchoverGlobalClusterRequest
     * @return A Java Future containing the result of the SwitchoverGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.SwitchoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/SwitchoverGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SwitchoverGlobalClusterResponse> switchoverGlobalCluster(
            SwitchoverGlobalClusterRequest switchoverGlobalClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, switchoverGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SwitchoverGlobalCluster");

            HttpResponseHandler<SwitchoverGlobalClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(SwitchoverGlobalClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SwitchoverGlobalClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SwitchoverGlobalClusterRequest, SwitchoverGlobalClusterResponse>()
                            .withOperationName("SwitchoverGlobalCluster")
                            .withMarshaller(new SwitchoverGlobalClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(switchoverGlobalClusterRequest));
            CompletableFuture<SwitchoverGlobalClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Switches over an Oracle standby database in an Oracle Data Guard environment, making it the new primary database.
     * Issue this command in the Region that hosts the current standby database.
     * </p>
     *
     * @param switchoverReadReplicaRequest
     * @return A Java Future containing the result of the SwitchoverReadReplica operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.SwitchoverReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/SwitchoverReadReplica" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SwitchoverReadReplicaResponse> switchoverReadReplica(
            SwitchoverReadReplicaRequest switchoverReadReplicaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, switchoverReadReplicaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RDS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SwitchoverReadReplica");

            HttpResponseHandler<SwitchoverReadReplicaResponse> responseHandler = protocolFactory
                    .createResponseHandler(SwitchoverReadReplicaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SwitchoverReadReplicaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SwitchoverReadReplicaRequest, SwitchoverReadReplicaResponse>()
                            .withOperationName("SwitchoverReadReplica")
                            .withMarshaller(new SwitchoverReadReplicaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(switchoverReadReplicaRequest));
            CompletableFuture<SwitchoverReadReplicaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public RdsAsyncWaiter waiter() {
        return RdsAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final RdsServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBProxyEndpointStateFault")
                                .exceptionBuilderSupplier(InvalidDbProxyEndpointStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentStateFault")
                                .exceptionBuilderSupplier(InvalidBlueGreenDeploymentStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamRoleNotFound")
                                .exceptionBuilderSupplier(IamRoleNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExportTaskNotFound")
                                .exceptionBuilderSupplier(ExportTaskNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAutomatedBackupQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterAutomatedBackupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRestoreFault")
                                .exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExportOnly")
                                .exceptionBuilderSupplier(InvalidExportOnlyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceRoleQuotaExceeded")
                                .exceptionBuilderSupplier(DbInstanceRoleQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterBacktrackNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterBacktrackNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault")
                                .exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs")
                                .exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault")
                                .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOptionGroupStateFault")
                                .exceptionBuilderSupplier(InvalidOptionGroupStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceRoleNotFound")
                                .exceptionBuilderSupplier(DbInstanceRoleNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlueGreenDeploymentAlreadyExistsFault")
                                .exceptionBuilderSupplier(BlueGreenDeploymentAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageTypeNotAvailableFault")
                                .exceptionBuilderSupplier(StorageTypeNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceRoleAlreadyExists")
                                .exceptionBuilderSupplier(DbInstanceRoleAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity")
                                .exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists")
                                .exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyEndpointNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyEndpointNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstancesOfferingNotFound")
                                .exceptionBuilderSupplier(ReservedDbInstancesOfferingNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PointInTimeRestoreNotEnabled")
                                .exceptionBuilderSupplier(PointInTimeRestoreNotEnabledException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState")
                                .exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterCapacityFault")
                                .exceptionBuilderSupplier(InvalidDbClusterCapacityException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomAvailabilityZoneNotFound")
                                .exceptionBuilderSupplier(CustomAvailabilityZoneNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound")
                                .exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyEndpointAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbProxyEndpointAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomDBEngineVersionAlreadyExistsFault")
                                .exceptionBuilderSupplier(CustomDbEngineVersionAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NetworkTypeNotSupported")
                                .exceptionBuilderSupplier(NetworkTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationQuotaExceeded")
                                .exceptionBuilderSupplier(AuthorizationQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded")
                                .exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(GlobalClusterQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CreateCustomDBEngineVersionFault")
                                .exceptionBuilderSupplier(CreateCustomDbEngineVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlueGreenDeploymentNotFoundFault")
                                .exceptionBuilderSupplier(BlueGreenDeploymentNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAutomatedBackupNotFound")
                                .exceptionBuilderSupplier(DbInstanceAutomatedBackupNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists")
                                .exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QuotaExceeded.DBSecurityGroup")
                                .exceptionBuilderSupplier(DbSecurityGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceDatabaseNotSupportedFault")
                                .exceptionBuilderSupplier(SourceDatabaseNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure")
                                .exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ProvisionedIopsNotAvailableInAZFault")
                                .exceptionBuilderSupplier(ProvisionedIopsNotAvailableInAzException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterEndpointAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity")
                                .exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyQuotaExceededFault")
                                .exceptionBuilderSupplier(DbProxyQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotNotFound")
                                .exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstanceAlreadyExists")
                                .exceptionBuilderSupplier(ReservedDbInstanceAlreadyExistsException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyTargetNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyTargetNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OptionGroupNotFoundFault")
                                .exceptionBuilderSupplier(OptionGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomDBEngineVersionNotFoundFault")
                                .exceptionBuilderSupplier(CustomDbEngineVersionNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DomainNotFoundFault")
                                .exceptionBuilderSupplier(DomainNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterEndpointNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAutomatedBackupNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterAutomatedBackupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageQuotaExceeded")
                                .exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterEndpointStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterEndpointStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationNotFound")
                                .exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OptionGroupAlreadyExistsFault")
                                .exceptionBuilderSupplier(OptionGroupAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OptionGroupQuotaExceededFault")
                                .exceptionBuilderSupplier(OptionGroupQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExportSourceState")
                                .exceptionBuilderSupplier(InvalidExportSourceStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBInstanceAutomatedBackupState")
                                .exceptionBuilderSupplier(InvalidDbInstanceAutomatedBackupStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBLogFileNotFoundFault")
                                .exceptionBuilderSupplier(DbLogFileNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleNotFound")
                                .exceptionBuilderSupplier(DbClusterRoleNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound")
                                .exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("Ec2ImagePropertiesNotSupportedFault")
                                .exceptionBuilderSupplier(Ec2ImagePropertiesNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceNotFound")
                                .exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyTargetAlreadyRegisteredFault")
                                .exceptionBuilderSupplier(DbProxyTargetAlreadyRegisteredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstanceNotFound")
                                .exceptionBuilderSupplier(ReservedDbInstanceNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleQuotaExceeded")
                                .exceptionBuilderSupplier(DbClusterRoleQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateNotFound")
                                .exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState")
                                .exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAutomatedBackupQuotaExceeded")
                                .exceptionBuilderSupplier(DbInstanceAutomatedBackupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExportTaskStateFault")
                                .exceptionBuilderSupplier(InvalidExportTaskStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3BucketFault")
                                .exceptionBuilderSupplier(InvalidS3BucketException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundFault")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageTypeNotSupported")
                                .exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionNotFound")
                                .exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse")
                                .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyTargetGroupNotFoundFault")
                                .exceptionBuilderSupplier(DbProxyTargetGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterNotFoundFault")
                                .exceptionBuilderSupplier(GlobalClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleAlreadyExists")
                                .exceptionBuilderSupplier(DbClusterRoleAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEventSubscriptionState")
                                .exceptionBuilderSupplier(InvalidEventSubscriptionStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientAvailableIPsInSubnetFault")
                                .exceptionBuilderSupplier(InsufficientAvailableIPsInSubnetException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyEndpointQuotaExceededFault")
                                .exceptionBuilderSupplier(DbProxyEndpointQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomDBEngineVersionQuotaExceededFault")
                                .exceptionBuilderSupplier(CustomDbEngineVersionQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupNotSupported")
                                .exceptionBuilderSupplier(DbSecurityGroupNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExportTaskAlreadyExists")
                                .exceptionBuilderSupplier(ExportTaskAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(GlobalClusterAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupNotAllowedFault")
                                .exceptionBuilderSupplier(DbSubnetGroupNotAllowedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGlobalClusterStateFault")
                                .exceptionBuilderSupplier(InvalidGlobalClusterStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSInvalidTopic")
                                .exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBProxyStateFault")
                                .exceptionBuilderSupplier(InvalidDbProxyStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceClusterNotSupportedFault")
                                .exceptionBuilderSupplier(SourceClusterNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IamRoleMissingPermissions")
                                .exceptionBuilderSupplier(IamRoleMissingPermissionsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound")
                                .exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSNoAuthorization")
                                .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterEndpointQuotaExceededException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedDBInstanceQuotaExceeded")
                                .exceptionBuilderSupplier(ReservedDbInstanceQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist")
                                .exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBProxyAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbProxyAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbSecurityGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceNotFound")
                                .exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBInstanceState")
                                .exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded")
                                .exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists")
                                .exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCustomDBEngineVersionStateFault")
                                .exceptionBuilderSupplier(InvalidCustomDbEngineVersionStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterAutomatedBackupStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterAutomatedBackupStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState")
                                .exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(400)
                                .build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(RdsException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
