/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.DataShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataShareAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataShareAssociation> {
    private static final SdkField<String> CONSUMER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerIdentifier").getter(DataShareAssociation.getter(DataShareAssociation::consumerIdentifier)).setter(DataShareAssociation.setter(Builder::consumerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DataShareAssociation.getter(DataShareAssociation::statusAsString)).setter(DataShareAssociation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CONSUMER_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerRegion").getter(DataShareAssociation.getter(DataShareAssociation::consumerRegion)).setter(DataShareAssociation.setter(Builder::consumerRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerRegion").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(DataShareAssociation.getter(DataShareAssociation::createdDate)).setter(DataShareAssociation.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Instant> STATUS_CHANGE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StatusChangeDate").getter(DataShareAssociation.getter(DataShareAssociation::statusChangeDate)).setter(DataShareAssociation.setter(Builder::statusChangeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusChangeDate").build()}).build();
    private static final SdkField<Boolean> PRODUCER_ALLOWED_WRITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ProducerAllowedWrites").getter(DataShareAssociation.getter(DataShareAssociation::producerAllowedWrites)).setter(DataShareAssociation.setter(Builder::producerAllowedWrites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProducerAllowedWrites").build()}).build();
    private static final SdkField<Boolean> CONSUMER_ACCEPTED_WRITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConsumerAcceptedWrites").getter(DataShareAssociation.getter(DataShareAssociation::consumerAcceptedWrites)).setter(DataShareAssociation.setter(Builder::consumerAcceptedWrites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerAcceptedWrites").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_IDENTIFIER_FIELD, STATUS_FIELD, CONSUMER_REGION_FIELD, CREATED_DATE_FIELD, STATUS_CHANGE_DATE_FIELD, PRODUCER_ALLOWED_WRITES_FIELD, CONSUMER_ACCEPTED_WRITES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String consumerIdentifier;
    private final String status;
    private final String consumerRegion;
    private final Instant createdDate;
    private final Instant statusChangeDate;
    private final Boolean producerAllowedWrites;
    private final Boolean consumerAcceptedWrites;

    private DataShareAssociation(BuilderImpl builder) {
        this.consumerIdentifier = builder.consumerIdentifier;
        this.status = builder.status;
        this.consumerRegion = builder.consumerRegion;
        this.createdDate = builder.createdDate;
        this.statusChangeDate = builder.statusChangeDate;
        this.producerAllowedWrites = builder.producerAllowedWrites;
        this.consumerAcceptedWrites = builder.consumerAcceptedWrites;
    }

    public final String consumerIdentifier() {
        return this.consumerIdentifier;
    }

    public final DataShareStatus status() {
        return DataShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String consumerRegion() {
        return this.consumerRegion;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant statusChangeDate() {
        return this.statusChangeDate;
    }

    public final Boolean producerAllowedWrites() {
        return this.producerAllowedWrites;
    }

    public final Boolean consumerAcceptedWrites() {
        return this.consumerAcceptedWrites;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusChangeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.producerAllowedWrites());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerAcceptedWrites());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataShareAssociation)) {
            return false;
        }
        DataShareAssociation other = (DataShareAssociation)obj;
        return Objects.equals(this.consumerIdentifier(), other.consumerIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.consumerRegion(), other.consumerRegion()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.statusChangeDate(), other.statusChangeDate()) && Objects.equals(this.producerAllowedWrites(), other.producerAllowedWrites()) && Objects.equals(this.consumerAcceptedWrites(), other.consumerAcceptedWrites());
    }

    public final String toString() {
        return ToString.builder((String)"DataShareAssociation").add("ConsumerIdentifier", (Object)this.consumerIdentifier()).add("Status", (Object)this.statusAsString()).add("ConsumerRegion", (Object)this.consumerRegion()).add("CreatedDate", (Object)this.createdDate()).add("StatusChangeDate", (Object)this.statusChangeDate()).add("ProducerAllowedWrites", (Object)this.producerAllowedWrites()).add("ConsumerAcceptedWrites", (Object)this.consumerAcceptedWrites()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.consumerIdentifier()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ConsumerRegion": {
                return Optional.ofNullable(clazz.cast(this.consumerRegion()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "StatusChangeDate": {
                return Optional.ofNullable(clazz.cast(this.statusChangeDate()));
            }
            case "ProducerAllowedWrites": {
                return Optional.ofNullable(clazz.cast(this.producerAllowedWrites()));
            }
            case "ConsumerAcceptedWrites": {
                return Optional.ofNullable(clazz.cast(this.consumerAcceptedWrites()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataShareAssociation, T> g) {
        return obj -> g.apply((DataShareAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String consumerIdentifier;
        private String status;
        private String consumerRegion;
        private Instant createdDate;
        private Instant statusChangeDate;
        private Boolean producerAllowedWrites;
        private Boolean consumerAcceptedWrites;

        private BuilderImpl() {
        }

        private BuilderImpl(DataShareAssociation model) {
            this.consumerIdentifier(model.consumerIdentifier);
            this.status(model.status);
            this.consumerRegion(model.consumerRegion);
            this.createdDate(model.createdDate);
            this.statusChangeDate(model.statusChangeDate);
            this.producerAllowedWrites(model.producerAllowedWrites);
            this.consumerAcceptedWrites(model.consumerAcceptedWrites);
        }

        public final String getConsumerIdentifier() {
            return this.consumerIdentifier;
        }

        public final void setConsumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
        }

        @Override
        public final Builder consumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConsumerRegion() {
            return this.consumerRegion;
        }

        public final void setConsumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
        }

        @Override
        public final Builder consumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getStatusChangeDate() {
            return this.statusChangeDate;
        }

        public final void setStatusChangeDate(Instant statusChangeDate) {
            this.statusChangeDate = statusChangeDate;
        }

        @Override
        public final Builder statusChangeDate(Instant statusChangeDate) {
            this.statusChangeDate = statusChangeDate;
            return this;
        }

        public final Boolean getProducerAllowedWrites() {
            return this.producerAllowedWrites;
        }

        public final void setProducerAllowedWrites(Boolean producerAllowedWrites) {
            this.producerAllowedWrites = producerAllowedWrites;
        }

        @Override
        public final Builder producerAllowedWrites(Boolean producerAllowedWrites) {
            this.producerAllowedWrites = producerAllowedWrites;
            return this;
        }

        public final Boolean getConsumerAcceptedWrites() {
            return this.consumerAcceptedWrites;
        }

        public final void setConsumerAcceptedWrites(Boolean consumerAcceptedWrites) {
            this.consumerAcceptedWrites = consumerAcceptedWrites;
        }

        @Override
        public final Builder consumerAcceptedWrites(Boolean consumerAcceptedWrites) {
            this.consumerAcceptedWrites = consumerAcceptedWrites;
            return this;
        }

        public DataShareAssociation build() {
            return new DataShareAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataShareAssociation> {
        public Builder consumerIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(DataShareStatus var1);

        public Builder consumerRegion(String var1);

        public Builder createdDate(Instant var1);

        public Builder statusChangeDate(Instant var1);

        public Builder producerAllowedWrites(Boolean var1);

        public Builder consumerAcceptedWrites(Boolean var1);
    }
}

