/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyLakehouseConfigurationResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, ModifyLakehouseConfigurationResponse> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifyLakehouseConfigurationResponse.getter(ModifyLakehouseConfigurationResponse::clusterIdentifier)).setter(ModifyLakehouseConfigurationResponse.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> LAKEHOUSE_IDC_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LakehouseIdcApplicationArn").getter(ModifyLakehouseConfigurationResponse.getter(ModifyLakehouseConfigurationResponse::lakehouseIdcApplicationArn)).setter(ModifyLakehouseConfigurationResponse.setter(Builder::lakehouseIdcApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakehouseIdcApplicationArn").build()}).build();
    private static final SdkField<String> LAKEHOUSE_REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LakehouseRegistrationStatus").getter(ModifyLakehouseConfigurationResponse.getter(ModifyLakehouseConfigurationResponse::lakehouseRegistrationStatus)).setter(ModifyLakehouseConfigurationResponse.setter(Builder::lakehouseRegistrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakehouseRegistrationStatus").build()}).build();
    private static final SdkField<String> CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogArn").getter(ModifyLakehouseConfigurationResponse.getter(ModifyLakehouseConfigurationResponse::catalogArn)).setter(ModifyLakehouseConfigurationResponse.setter(Builder::catalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, LAKEHOUSE_IDC_APPLICATION_ARN_FIELD, LAKEHOUSE_REGISTRATION_STATUS_FIELD, CATALOG_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyLakehouseConfigurationResponse.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String lakehouseIdcApplicationArn;
    private final String lakehouseRegistrationStatus;
    private final String catalogArn;

    private ModifyLakehouseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.lakehouseIdcApplicationArn = builder.lakehouseIdcApplicationArn;
        this.lakehouseRegistrationStatus = builder.lakehouseRegistrationStatus;
        this.catalogArn = builder.catalogArn;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String lakehouseIdcApplicationArn() {
        return this.lakehouseIdcApplicationArn;
    }

    public final String lakehouseRegistrationStatus() {
        return this.lakehouseRegistrationStatus;
    }

    public final String catalogArn() {
        return this.catalogArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseRegistrationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLakehouseConfigurationResponse)) {
            return false;
        }
        ModifyLakehouseConfigurationResponse other = (ModifyLakehouseConfigurationResponse)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.lakehouseIdcApplicationArn(), other.lakehouseIdcApplicationArn()) && Objects.equals(this.lakehouseRegistrationStatus(), other.lakehouseRegistrationStatus()) && Objects.equals(this.catalogArn(), other.catalogArn());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyLakehouseConfigurationResponse").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("LakehouseIdcApplicationArn", (Object)this.lakehouseIdcApplicationArn()).add("LakehouseRegistrationStatus", (Object)this.lakehouseRegistrationStatus()).add("CatalogArn", (Object)this.catalogArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "LakehouseIdcApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.lakehouseIdcApplicationArn()));
            }
            case "LakehouseRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.lakehouseRegistrationStatus()));
            }
            case "CatalogArn": {
                return Optional.ofNullable(clazz.cast(this.catalogArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("LakehouseIdcApplicationArn", LAKEHOUSE_IDC_APPLICATION_ARN_FIELD);
        map.put("LakehouseRegistrationStatus", LAKEHOUSE_REGISTRATION_STATUS_FIELD);
        map.put("CatalogArn", CATALOG_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyLakehouseConfigurationResponse, T> g) {
        return obj -> g.apply((ModifyLakehouseConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String lakehouseIdcApplicationArn;
        private String lakehouseRegistrationStatus;
        private String catalogArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLakehouseConfigurationResponse model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.lakehouseIdcApplicationArn(model.lakehouseIdcApplicationArn);
            this.lakehouseRegistrationStatus(model.lakehouseRegistrationStatus);
            this.catalogArn(model.catalogArn);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getLakehouseIdcApplicationArn() {
            return this.lakehouseIdcApplicationArn;
        }

        public final void setLakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
        }

        @Override
        public final Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
            return this;
        }

        public final String getLakehouseRegistrationStatus() {
            return this.lakehouseRegistrationStatus;
        }

        public final void setLakehouseRegistrationStatus(String lakehouseRegistrationStatus) {
            this.lakehouseRegistrationStatus = lakehouseRegistrationStatus;
        }

        @Override
        public final Builder lakehouseRegistrationStatus(String lakehouseRegistrationStatus) {
            this.lakehouseRegistrationStatus = lakehouseRegistrationStatus;
            return this;
        }

        public final String getCatalogArn() {
            return this.catalogArn;
        }

        public final void setCatalogArn(String catalogArn) {
            this.catalogArn = catalogArn;
        }

        @Override
        public final Builder catalogArn(String catalogArn) {
            this.catalogArn = catalogArn;
            return this;
        }

        @Override
        public ModifyLakehouseConfigurationResponse build() {
            return new ModifyLakehouseConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyLakehouseConfigurationResponse> {
        public Builder clusterIdentifier(String var1);

        public Builder lakehouseIdcApplicationArn(String var1);

        public Builder lakehouseRegistrationStatus(String var1);

        public Builder catalogArn(String var1);
    }
}

