/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTableResponse extends RedshiftDataResponse implements
        ToCopyableBuilder<DescribeTableResponse.Builder, DescribeTableResponse> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_LIST_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .memberName("ColumnList")
            .getter(getter(DescribeTableResponse::columnList))
            .setter(setter(Builder::columnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeTableResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DescribeTableResponse::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_LIST_FIELD,
            NEXT_TOKEN_FIELD, TABLE_NAME_FIELD));

    private final List<ColumnMetadata> columnList;

    private final String nextToken;

    private final String tableName;

    private DescribeTableResponse(BuilderImpl builder) {
        super(builder);
        this.columnList = builder.columnList;
        this.nextToken = builder.nextToken;
        this.tableName = builder.tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumnList() {
        return columnList != null && !(columnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of columns in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnList} method.
     * </p>
     * 
     * @return A list of columns in the table.
     */
    public final List<ColumnMetadata> columnList() {
        return columnList;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The table name.
     * </p>
     * 
     * @return The table name.
     */
    public final String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnList() ? columnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableResponse)) {
            return false;
        }
        DescribeTableResponse other = (DescribeTableResponse) obj;
        return hasColumnList() == other.hasColumnList() && Objects.equals(columnList(), other.columnList())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(tableName(), other.tableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTableResponse").add("ColumnList", hasColumnList() ? columnList() : null)
                .add("NextToken", nextToken()).add("TableName", tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnList":
            return Optional.ofNullable(clazz.cast(columnList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableResponse, T> g) {
        return obj -> g.apply((DescribeTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTableResponse> {
        /**
         * <p>
         * A list of columns in the table.
         * </p>
         * 
         * @param columnList
         *        A list of columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnList(Collection<ColumnMetadata> columnList);

        /**
         * <p>
         * A list of columns in the table.
         * </p>
         * 
         * @param columnList
         *        A list of columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnList(ColumnMetadata... columnList);

        /**
         * <p>
         * A list of columns in the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #columnList(List<ColumnMetadata>)}.
         * 
         * @param columnList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnList(java.util.Collection<ColumnMetadata>)
         */
        Builder columnList(Consumer<ColumnMetadata.Builder>... columnList);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The table name.
         * </p>
         * 
         * @param tableName
         *        The table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl extends RedshiftDataResponse.BuilderImpl implements Builder {
        private List<ColumnMetadata> columnList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableResponse model) {
            super(model);
            columnList(model.columnList);
            nextToken(model.nextToken);
            tableName(model.tableName);
        }

        public final List<ColumnMetadata.Builder> getColumnList() {
            List<ColumnMetadata.Builder> result = ColumnListCopier.copyToBuilder(this.columnList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnList(Collection<ColumnMetadata.BuilderImpl> columnList) {
            this.columnList = ColumnListCopier.copyFromBuilder(columnList);
        }

        @Override
        public final Builder columnList(Collection<ColumnMetadata> columnList) {
            this.columnList = ColumnListCopier.copy(columnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnList(ColumnMetadata... columnList) {
            columnList(Arrays.asList(columnList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnList(Consumer<ColumnMetadata.Builder>... columnList) {
            columnList(Stream.of(columnList).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public DescribeTableResponse build() {
            return new DescribeTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
