/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.ResultFormatString;
import software.amazon.awssdk.services.redshiftdata.model.SqlParameter;
import software.amazon.awssdk.services.redshiftdata.model.SqlParametersListCopier;
import software.amazon.awssdk.services.redshiftdata.model.StatementStringListCopier;
import software.amazon.awssdk.services.redshiftdata.model.StatusString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatementData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatementData> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(StatementData.getter(StatementData::id)).setter(StatementData.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(StatementData.getter(StatementData::queryString)).setter(StatementData.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<List<String>> QUERY_STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryStrings").getter(StatementData.getter(StatementData::queryStrings)).setter(StatementData.setter(Builder::queryStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStrings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(StatementData.getter(StatementData::secretArn)).setter(StatementData.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StatementData.getter(StatementData::statusAsString)).setter(StatementData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementName").getter(StatementData.getter(StatementData::statementName)).setter(StatementData.setter(Builder::statementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(StatementData.getter(StatementData::createdAt)).setter(StatementData.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(StatementData.getter(StatementData::updatedAt)).setter(StatementData.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<List<SqlParameter>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryParameters").getter(StatementData.getter(StatementData::queryParameters)).setter(StatementData.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_BATCH_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsBatchStatement").getter(StatementData.getter(StatementData::isBatchStatement)).setter(StatementData.setter(Builder::isBatchStatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsBatchStatement").build()}).build();
    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultFormat").getter(StatementData.getter(StatementData::resultFormatAsString)).setter(StatementData.setter(Builder::resultFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultFormat").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(StatementData.getter(StatementData::sessionId)).setter(StatementData.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, QUERY_STRING_FIELD, QUERY_STRINGS_FIELD, SECRET_ARN_FIELD, STATUS_FIELD, STATEMENT_NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, QUERY_PARAMETERS_FIELD, IS_BATCH_STATEMENT_FIELD, RESULT_FORMAT_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StatementData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String queryString;
    private final List<String> queryStrings;
    private final String secretArn;
    private final String status;
    private final String statementName;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<SqlParameter> queryParameters;
    private final Boolean isBatchStatement;
    private final String resultFormat;
    private final String sessionId;

    private StatementData(BuilderImpl builder) {
        this.id = builder.id;
        this.queryString = builder.queryString;
        this.queryStrings = builder.queryStrings;
        this.secretArn = builder.secretArn;
        this.status = builder.status;
        this.statementName = builder.statementName;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.queryParameters = builder.queryParameters;
        this.isBatchStatement = builder.isBatchStatement;
        this.resultFormat = builder.resultFormat;
        this.sessionId = builder.sessionId;
    }

    public final String id() {
        return this.id;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final boolean hasQueryStrings() {
        return this.queryStrings != null && !(this.queryStrings instanceof SdkAutoConstructList);
    }

    public final List<String> queryStrings() {
        return this.queryStrings;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final StatusString status() {
        return StatusString.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statementName() {
        return this.statementName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructList);
    }

    public final List<SqlParameter> queryParameters() {
        return this.queryParameters;
    }

    public final Boolean isBatchStatement() {
        return this.isBatchStatement;
    }

    public final ResultFormatString resultFormat() {
        return ResultFormatString.fromValue(this.resultFormat);
    }

    public final String resultFormatAsString() {
        return this.resultFormat;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryStrings() ? this.queryStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isBatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementData)) {
            return false;
        }
        StatementData other = (StatementData)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.queryString(), other.queryString()) && this.hasQueryStrings() == other.hasQueryStrings() && Objects.equals(this.queryStrings(), other.queryStrings()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statementName(), other.statementName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters()) && Objects.equals(this.isBatchStatement(), other.isBatchStatement()) && Objects.equals(this.resultFormatAsString(), other.resultFormatAsString()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"StatementData").add("Id", (Object)this.id()).add("QueryString", (Object)this.queryString()).add("QueryStrings", this.hasQueryStrings() ? this.queryStrings() : null).add("SecretArn", (Object)this.secretArn()).add("Status", (Object)this.statusAsString()).add("StatementName", (Object)this.statementName()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).add("IsBatchStatement", (Object)this.isBatchStatement()).add("ResultFormat", (Object)this.resultFormatAsString()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "QueryStrings": {
                return Optional.ofNullable(clazz.cast(this.queryStrings()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatementName": {
                return Optional.ofNullable(clazz.cast(this.statementName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "IsBatchStatement": {
                return Optional.ofNullable(clazz.cast(this.isBatchStatement()));
            }
            case "ResultFormat": {
                return Optional.ofNullable(clazz.cast(this.resultFormatAsString()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("QueryStrings", QUERY_STRINGS_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatementName", STATEMENT_NAME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("IsBatchStatement", IS_BATCH_STATEMENT_FIELD);
        map.put("ResultFormat", RESULT_FORMAT_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatementData, T> g) {
        return obj -> g.apply((StatementData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String queryString;
        private List<String> queryStrings = DefaultSdkAutoConstructList.getInstance();
        private String secretArn;
        private String status;
        private String statementName;
        private Instant createdAt;
        private Instant updatedAt;
        private List<SqlParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();
        private Boolean isBatchStatement;
        private String resultFormat;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StatementData model) {
            this.id(model.id);
            this.queryString(model.queryString);
            this.queryStrings(model.queryStrings);
            this.secretArn(model.secretArn);
            this.status(model.status);
            this.statementName(model.statementName);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.queryParameters(model.queryParameters);
            this.isBatchStatement(model.isBatchStatement);
            this.resultFormat(model.resultFormat);
            this.sessionId(model.sessionId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Collection<String> getQueryStrings() {
            if (this.queryStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryStrings;
        }

        public final void setQueryStrings(Collection<String> queryStrings) {
            this.queryStrings = StatementStringListCopier.copy(queryStrings);
        }

        @Override
        public final Builder queryStrings(Collection<String> queryStrings) {
            this.queryStrings = StatementStringListCopier.copy(queryStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryStrings(String ... queryStrings) {
            this.queryStrings(Arrays.asList(queryStrings));
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatementName() {
            return this.statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<SqlParameter.Builder> getQueryParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<SqlParameter.BuilderImpl> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copyFromBuilder(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<SqlParameter> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(SqlParameter ... queryParameters) {
            this.queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(Consumer<SqlParameter.Builder> ... queryParameters) {
            this.queryParameters(Stream.of(queryParameters).map(c -> (SqlParameter)((SqlParameter.Builder)SqlParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsBatchStatement() {
            return this.isBatchStatement;
        }

        public final void setIsBatchStatement(Boolean isBatchStatement) {
            this.isBatchStatement = isBatchStatement;
        }

        @Override
        public final Builder isBatchStatement(Boolean isBatchStatement) {
            this.isBatchStatement = isBatchStatement;
            return this;
        }

        public final String getResultFormat() {
            return this.resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormatString resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public StatementData build() {
            return new StatementData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatementData> {
        public Builder id(String var1);

        public Builder queryString(String var1);

        public Builder queryStrings(Collection<String> var1);

        public Builder queryStrings(String ... var1);

        public Builder secretArn(String var1);

        public Builder status(String var1);

        public Builder status(StatusString var1);

        public Builder statementName(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder queryParameters(Collection<SqlParameter> var1);

        public Builder queryParameters(SqlParameter ... var1);

        public Builder queryParameters(Consumer<SqlParameter.Builder> ... var1);

        public Builder isBatchStatement(Boolean var1);

        public Builder resultFormat(String var1);

        public Builder resultFormat(ResultFormatString var1);

        public Builder sessionId(String var1);
    }
}

