/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreFromSnapshotRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<RestoreFromSnapshotRequest.Builder, RestoreFromSnapshotRequest> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(RestoreFromSnapshotRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(RestoreFromSnapshotRequest::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotArn").getter(getter(RestoreFromSnapshotRequest::snapshotArn))
            .setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(RestoreFromSnapshotRequest::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(RestoreFromSnapshotRequest::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD,
            OWNER_ACCOUNT_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_NAME_FIELD, WORKGROUP_NAME_FIELD));

    private final String namespaceName;

    private final String ownerAccount;

    private final String snapshotArn;

    private final String snapshotName;

    private final String workgroupName;

    private RestoreFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceName = builder.namespaceName;
        this.ownerAccount = builder.ownerAccount;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotName = builder.snapshotName;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The name of the namespace to restore the snapshot to.
     * </p>
     * 
     * @return The name of the namespace to restore the snapshot to.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The Amazon Web Services account that owns the snapshot.
     * </p>
     * 
     * @return The Amazon Web Services account that owns the snapshot.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot to restore from. Required if restoring from Amazon Redshift
     * Serverless to a provisioned cluster. Must not be specified at the same time as <code>snapshotName</code>.
     * </p>
     * <p>
     * The format of the ARN is
     * arn:aws:redshift:&lt;region&gt;:&lt;account_id&gt;:snapshot:&lt;cluster_identifier&gt;/&lt
     * ;snapshot_identifier&gt;.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot to restore from. Required if restoring from Amazon
     *         Redshift Serverless to a provisioned cluster. Must not be specified at the same time as
     *         <code>snapshotName</code>.</p>
     *         <p>
     *         The format of the ARN is
     *         arn:aws:redshift:&lt;region&gt;:&lt;account_id&gt;:snapshot:&lt;cluster_identifier
     *         &gt;/&lt;snapshot_identifier&gt;.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * The name of the snapshot to restore from. Must not be specified at the same time as <code>snapshotArn</code>.
     * </p>
     * 
     * @return The name of the snapshot to restore from. Must not be specified at the same time as
     *         <code>snapshotArn</code>.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The name of the workgroup used to restore the snapshot.
     * </p>
     * 
     * @return The name of the workgroup used to restore the snapshot.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromSnapshotRequest)) {
            return false;
        }
        RestoreFromSnapshotRequest other = (RestoreFromSnapshotRequest) obj;
        return Objects.equals(namespaceName(), other.namespaceName()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(snapshotArn(), other.snapshotArn()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreFromSnapshotRequest").add("NamespaceName", namespaceName())
                .add("OwnerAccount", ownerAccount()).add("SnapshotArn", snapshotArn()).add("SnapshotName", snapshotName())
                .add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "snapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreFromSnapshotRequest> {
        /**
         * <p>
         * The name of the namespace to restore the snapshot to.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace to restore the snapshot to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The Amazon Web Services account that owns the snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        The Amazon Web Services account that owns the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot to restore from. Required if restoring from Amazon Redshift
         * Serverless to a provisioned cluster. Must not be specified at the same time as <code>snapshotName</code>.
         * </p>
         * <p>
         * The format of the ARN is
         * arn:aws:redshift:&lt;region&gt;:&lt;account_id&gt;:snapshot:&lt;cluster_identifier&gt
         * ;/&lt;snapshot_identifier&gt;.
         * </p>
         * 
         * @param snapshotArn
         *        The Amazon Resource Name (ARN) of the snapshot to restore from. Required if restoring from Amazon
         *        Redshift Serverless to a provisioned cluster. Must not be specified at the same time as
         *        <code>snapshotName</code>.</p>
         *        <p>
         *        The format of the ARN is
         *        arn:aws:redshift:&lt;region&gt;:&lt;account_id&gt;:snapshot:&lt;cluster_identifier
         *        &gt;/&lt;snapshot_identifier&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The name of the snapshot to restore from. Must not be specified at the same time as <code>snapshotArn</code>.
         * </p>
         * 
         * @param snapshotName
         *        The name of the snapshot to restore from. Must not be specified at the same time as
         *        <code>snapshotArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The name of the workgroup used to restore the snapshot.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup used to restore the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String namespaceName;

        private String ownerAccount;

        private String snapshotArn;

        private String snapshotName;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromSnapshotRequest model) {
            super(model);
            namespaceName(model.namespaceName);
            ownerAccount(model.ownerAccount);
            snapshotArn(model.snapshotArn);
            snapshotName(model.snapshotName);
            workgroupName(model.workgroupName);
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreFromSnapshotRequest build() {
            return new RestoreFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
