/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNamespaceRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<UpdateNamespaceRequest.Builder, UpdateNamespaceRequest> {
    private static final SdkField<String> ADMIN_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUserPassword").getter(getter(UpdateNamespaceRequest::adminUserPassword))
            .setter(setter(Builder::adminUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserPassword").build()).build();

    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUsername").getter(getter(UpdateNamespaceRequest::adminUsername))
            .setter(setter(Builder::adminUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUsername").build()).build();

    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultIamRoleArn").getter(getter(UpdateNamespaceRequest::defaultIamRoleArn))
            .setter(setter(Builder::defaultIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultIamRoleArn").build()).build();

    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("iamRoles")
            .getter(getter(UpdateNamespaceRequest::iamRoles))
            .setter(setter(Builder::iamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(UpdateNamespaceRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<List<String>> LOG_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logExports")
            .getter(getter(UpdateNamespaceRequest::logExportsAsStrings))
            .setter(setter(Builder::logExportsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logExports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(UpdateNamespaceRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_PASSWORD_FIELD,
            ADMIN_USERNAME_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD, IAM_ROLES_FIELD, KMS_KEY_ID_FIELD, LOG_EXPORTS_FIELD,
            NAMESPACE_NAME_FIELD));

    private final String adminUserPassword;

    private final String adminUsername;

    private final String defaultIamRoleArn;

    private final List<String> iamRoles;

    private final String kmsKeyId;

    private final List<String> logExports;

    private final String namespaceName;

    private UpdateNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.adminUserPassword = builder.adminUserPassword;
        this.adminUsername = builder.adminUsername;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
        this.iamRoles = builder.iamRoles;
        this.kmsKeyId = builder.kmsKeyId;
        this.logExports = builder.logExports;
        this.namespaceName = builder.namespaceName;
    }

    /**
     * <p>
     * The password of the administrator for the first database created in the namespace. This parameter must be updated
     * together with <code>adminUsername</code>.
     * </p>
     * 
     * @return The password of the administrator for the first database created in the namespace. This parameter must be
     *         updated together with <code>adminUsername</code>.
     */
    public final String adminUserPassword() {
        return adminUserPassword;
    }

    /**
     * <p>
     * The username of the administrator for the first database created in the namespace. This parameter must be updated
     * together with <code>adminUserPassword</code>.
     * </p>
     * 
     * @return The username of the administrator for the first database created in the namespace. This parameter must be
     *         updated together with <code>adminUserPassword</code>.
     */
    public final String adminUsername() {
        return adminUsername;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter must be
     * updated together with <code>iamRoles</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter must
     *         be updated together with <code>iamRoles</code>.
     */
    public final String defaultIamRoleArn() {
        return defaultIamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the IamRoles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIamRoles() {
        return iamRoles != null && !(iamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM roles to associate with the namespace. This parameter must be updated together with
     * <code>defaultIamRoleArn</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIamRoles} method.
     * </p>
     * 
     * @return A list of IAM roles to associate with the namespace. This parameter must be updated together with
     *         <code>defaultIamRoleArn</code>.
     */
    public final List<String> iamRoles() {
        return iamRoles;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The types of logs the namespace can export. The export types are <code>userlog</code>, <code>connectionlog</code>
     * , and <code>useractivitylog</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogExports} method.
     * </p>
     * 
     * @return The types of logs the namespace can export. The export types are <code>userlog</code>,
     *         <code>connectionlog</code>, and <code>useractivitylog</code>.
     */
    public final List<LogExport> logExports() {
        return LogExportListCopier.copyStringToEnum(logExports);
    }

    /**
     * For responses, this returns true if the service returned a value for the LogExports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogExports() {
        return logExports != null && !(logExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of logs the namespace can export. The export types are <code>userlog</code>, <code>connectionlog</code>
     * , and <code>useractivitylog</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogExports} method.
     * </p>
     * 
     * @return The types of logs the namespace can export. The export types are <code>userlog</code>,
     *         <code>connectionlog</code>, and <code>useractivitylog</code>.
     */
    public final List<String> logExportsAsStrings() {
        return logExports;
    }

    /**
     * <p>
     * The name of the namespace to update. You can't update the name of a namespace once it is created.
     * </p>
     * 
     * @return The name of the namespace to update. You can't update the name of a namespace once it is created.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(defaultIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIamRoles() ? iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogExports() ? logExportsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNamespaceRequest)) {
            return false;
        }
        UpdateNamespaceRequest other = (UpdateNamespaceRequest) obj;
        return Objects.equals(adminUserPassword(), other.adminUserPassword())
                && Objects.equals(adminUsername(), other.adminUsername())
                && Objects.equals(defaultIamRoleArn(), other.defaultIamRoleArn()) && hasIamRoles() == other.hasIamRoles()
                && Objects.equals(iamRoles(), other.iamRoles()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasLogExports() == other.hasLogExports() && Objects.equals(logExportsAsStrings(), other.logExportsAsStrings())
                && Objects.equals(namespaceName(), other.namespaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNamespaceRequest")
                .add("AdminUserPassword", adminUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AdminUsername", adminUsername() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DefaultIamRoleArn", defaultIamRoleArn()).add("IamRoles", hasIamRoles() ? iamRoles() : null)
                .add("KmsKeyId", kmsKeyId()).add("LogExports", hasLogExports() ? logExportsAsStrings() : null)
                .add("NamespaceName", namespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminUserPassword":
            return Optional.ofNullable(clazz.cast(adminUserPassword()));
        case "adminUsername":
            return Optional.ofNullable(clazz.cast(adminUsername()));
        case "defaultIamRoleArn":
            return Optional.ofNullable(clazz.cast(defaultIamRoleArn()));
        case "iamRoles":
            return Optional.ofNullable(clazz.cast(iamRoles()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "logExports":
            return Optional.ofNullable(clazz.cast(logExportsAsStrings()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNamespaceRequest, T> g) {
        return obj -> g.apply((UpdateNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNamespaceRequest> {
        /**
         * <p>
         * The password of the administrator for the first database created in the namespace. This parameter must be
         * updated together with <code>adminUsername</code>.
         * </p>
         * 
         * @param adminUserPassword
         *        The password of the administrator for the first database created in the namespace. This parameter must
         *        be updated together with <code>adminUsername</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserPassword(String adminUserPassword);

        /**
         * <p>
         * The username of the administrator for the first database created in the namespace. This parameter must be
         * updated together with <code>adminUserPassword</code>.
         * </p>
         * 
         * @param adminUsername
         *        The username of the administrator for the first database created in the namespace. This parameter must
         *        be updated together with <code>adminUserPassword</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUsername(String adminUsername);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter must be
         * updated together with <code>iamRoles</code>.
         * </p>
         * 
         * @param defaultIamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter
         *        must be updated together with <code>iamRoles</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultIamRoleArn(String defaultIamRoleArn);

        /**
         * <p>
         * A list of IAM roles to associate with the namespace. This parameter must be updated together with
         * <code>defaultIamRoleArn</code>.
         * </p>
         * 
         * @param iamRoles
         *        A list of IAM roles to associate with the namespace. This parameter must be updated together with
         *        <code>defaultIamRoleArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(Collection<String> iamRoles);

        /**
         * <p>
         * A list of IAM roles to associate with the namespace. This parameter must be updated together with
         * <code>defaultIamRoleArn</code>.
         * </p>
         * 
         * @param iamRoles
         *        A list of IAM roles to associate with the namespace. This parameter must be updated together with
         *        <code>defaultIamRoleArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(String... iamRoles);

        /**
         * <p>
         * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The types of logs the namespace can export. The export types are <code>userlog</code>,
         * <code>connectionlog</code>, and <code>useractivitylog</code>.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. The export types are <code>userlog</code>,
         *        <code>connectionlog</code>, and <code>useractivitylog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExportsWithStrings(Collection<String> logExports);

        /**
         * <p>
         * The types of logs the namespace can export. The export types are <code>userlog</code>,
         * <code>connectionlog</code>, and <code>useractivitylog</code>.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. The export types are <code>userlog</code>,
         *        <code>connectionlog</code>, and <code>useractivitylog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExportsWithStrings(String... logExports);

        /**
         * <p>
         * The types of logs the namespace can export. The export types are <code>userlog</code>,
         * <code>connectionlog</code>, and <code>useractivitylog</code>.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. The export types are <code>userlog</code>,
         *        <code>connectionlog</code>, and <code>useractivitylog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExports(Collection<LogExport> logExports);

        /**
         * <p>
         * The types of logs the namespace can export. The export types are <code>userlog</code>,
         * <code>connectionlog</code>, and <code>useractivitylog</code>.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. The export types are <code>userlog</code>,
         *        <code>connectionlog</code>, and <code>useractivitylog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExports(LogExport... logExports);

        /**
         * <p>
         * The name of the namespace to update. You can't update the name of a namespace once it is created.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace to update. You can't update the name of a namespace once it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String adminUserPassword;

        private String adminUsername;

        private String defaultIamRoleArn;

        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private List<String> logExports = DefaultSdkAutoConstructList.getInstance();

        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNamespaceRequest model) {
            super(model);
            adminUserPassword(model.adminUserPassword);
            adminUsername(model.adminUsername);
            defaultIamRoleArn(model.defaultIamRoleArn);
            iamRoles(model.iamRoles);
            kmsKeyId(model.kmsKeyId);
            logExportsWithStrings(model.logExports);
            namespaceName(model.namespaceName);
        }

        public final String getAdminUserPassword() {
            return adminUserPassword;
        }

        public final void setAdminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
        }

        @Override
        public final Builder adminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        public final String getAdminUsername() {
            return adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public final Collection<String> getIamRoles() {
            if (iamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return iamRoles;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String... iamRoles) {
            iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getLogExports() {
            if (logExports instanceof SdkAutoConstructList) {
                return null;
            }
            return logExports;
        }

        public final void setLogExports(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
        }

        @Override
        public final Builder logExportsWithStrings(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExportsWithStrings(String... logExports) {
            logExportsWithStrings(Arrays.asList(logExports));
            return this;
        }

        @Override
        public final Builder logExports(Collection<LogExport> logExports) {
            this.logExports = LogExportListCopier.copyEnumToString(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExports(LogExport... logExports) {
            logExports(Arrays.asList(logExports));
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNamespaceRequest build() {
            return new UpdateNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
