/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLakehouseConfigurationResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, UpdateLakehouseConfigurationResponse> {
    private static final SdkField<String> CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalogArn").getter(UpdateLakehouseConfigurationResponse.getter(UpdateLakehouseConfigurationResponse::catalogArn)).setter(UpdateLakehouseConfigurationResponse.setter(Builder::catalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogArn").build()}).build();
    private static final SdkField<String> LAKEHOUSE_IDC_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lakehouseIdcApplicationArn").getter(UpdateLakehouseConfigurationResponse.getter(UpdateLakehouseConfigurationResponse::lakehouseIdcApplicationArn)).setter(UpdateLakehouseConfigurationResponse.setter(Builder::lakehouseIdcApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseIdcApplicationArn").build()}).build();
    private static final SdkField<String> LAKEHOUSE_REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lakehouseRegistrationStatus").getter(UpdateLakehouseConfigurationResponse.getter(UpdateLakehouseConfigurationResponse::lakehouseRegistrationStatus)).setter(UpdateLakehouseConfigurationResponse.setter(Builder::lakehouseRegistrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseRegistrationStatus").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(UpdateLakehouseConfigurationResponse.getter(UpdateLakehouseConfigurationResponse::namespaceName)).setter(UpdateLakehouseConfigurationResponse.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ARN_FIELD, LAKEHOUSE_IDC_APPLICATION_ARN_FIELD, LAKEHOUSE_REGISTRATION_STATUS_FIELD, NAMESPACE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLakehouseConfigurationResponse.memberNameToFieldInitializer();
    private final String catalogArn;
    private final String lakehouseIdcApplicationArn;
    private final String lakehouseRegistrationStatus;
    private final String namespaceName;

    private UpdateLakehouseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.catalogArn = builder.catalogArn;
        this.lakehouseIdcApplicationArn = builder.lakehouseIdcApplicationArn;
        this.lakehouseRegistrationStatus = builder.lakehouseRegistrationStatus;
        this.namespaceName = builder.namespaceName;
    }

    public final String catalogArn() {
        return this.catalogArn;
    }

    public final String lakehouseIdcApplicationArn() {
        return this.lakehouseIdcApplicationArn;
    }

    public final String lakehouseRegistrationStatus() {
        return this.lakehouseRegistrationStatus;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseRegistrationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLakehouseConfigurationResponse)) {
            return false;
        }
        UpdateLakehouseConfigurationResponse other = (UpdateLakehouseConfigurationResponse)((Object)obj);
        return Objects.equals(this.catalogArn(), other.catalogArn()) && Objects.equals(this.lakehouseIdcApplicationArn(), other.lakehouseIdcApplicationArn()) && Objects.equals(this.lakehouseRegistrationStatus(), other.lakehouseRegistrationStatus()) && Objects.equals(this.namespaceName(), other.namespaceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLakehouseConfigurationResponse").add("CatalogArn", (Object)this.catalogArn()).add("LakehouseIdcApplicationArn", (Object)this.lakehouseIdcApplicationArn()).add("LakehouseRegistrationStatus", (Object)this.lakehouseRegistrationStatus()).add("NamespaceName", (Object)this.namespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalogArn": {
                return Optional.ofNullable(clazz.cast(this.catalogArn()));
            }
            case "lakehouseIdcApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.lakehouseIdcApplicationArn()));
            }
            case "lakehouseRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.lakehouseRegistrationStatus()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("catalogArn", CATALOG_ARN_FIELD);
        map.put("lakehouseIdcApplicationArn", LAKEHOUSE_IDC_APPLICATION_ARN_FIELD);
        map.put("lakehouseRegistrationStatus", LAKEHOUSE_REGISTRATION_STATUS_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLakehouseConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateLakehouseConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String catalogArn;
        private String lakehouseIdcApplicationArn;
        private String lakehouseRegistrationStatus;
        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLakehouseConfigurationResponse model) {
            super(model);
            this.catalogArn(model.catalogArn);
            this.lakehouseIdcApplicationArn(model.lakehouseIdcApplicationArn);
            this.lakehouseRegistrationStatus(model.lakehouseRegistrationStatus);
            this.namespaceName(model.namespaceName);
        }

        public final String getCatalogArn() {
            return this.catalogArn;
        }

        public final void setCatalogArn(String catalogArn) {
            this.catalogArn = catalogArn;
        }

        @Override
        public final Builder catalogArn(String catalogArn) {
            this.catalogArn = catalogArn;
            return this;
        }

        public final String getLakehouseIdcApplicationArn() {
            return this.lakehouseIdcApplicationArn;
        }

        public final void setLakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
        }

        @Override
        public final Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
            return this;
        }

        public final String getLakehouseRegistrationStatus() {
            return this.lakehouseRegistrationStatus;
        }

        public final void setLakehouseRegistrationStatus(String lakehouseRegistrationStatus) {
            this.lakehouseRegistrationStatus = lakehouseRegistrationStatus;
        }

        @Override
        public final Builder lakehouseRegistrationStatus(String lakehouseRegistrationStatus) {
            this.lakehouseRegistrationStatus = lakehouseRegistrationStatus;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public UpdateLakehouseConfigurationResponse build() {
            return new UpdateLakehouseConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLakehouseConfigurationResponse> {
        public Builder catalogArn(String var1);

        public Builder lakehouseIdcApplicationArn(String var1);

        public Builder lakehouseRegistrationStatus(String var1);

        public Builder namespaceName(String var1);
    }
}

