/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<CompareFacesRequest.Builder, CompareFacesRequest> {
    private static final SdkField<Image> SOURCE_IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .memberName("SourceImage").getter(getter(CompareFacesRequest::sourceImage)).setter(setter(Builder::sourceImage))
            .constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImage").build()).build();

    private static final SdkField<Image> TARGET_IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .memberName("TargetImage").getter(getter(CompareFacesRequest::targetImage)).setter(setter(Builder::targetImage))
            .constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetImage").build()).build();

    private static final SdkField<Float> SIMILARITY_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("SimilarityThreshold").getter(getter(CompareFacesRequest::similarityThreshold))
            .setter(setter(Builder::similarityThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimilarityThreshold").build())
            .build();

    private static final SdkField<String> QUALITY_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityFilter").getter(getter(CompareFacesRequest::qualityFilterAsString))
            .setter(setter(Builder::qualityFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FIELD,
            TARGET_IMAGE_FIELD, SIMILARITY_THRESHOLD_FIELD, QUALITY_FILTER_FIELD));

    private final Image sourceImage;

    private final Image targetImage;

    private final Float similarityThreshold;

    private final String qualityFilter;

    private CompareFacesRequest(BuilderImpl builder) {
        super(builder);
        this.sourceImage = builder.sourceImage;
        this.targetImage = builder.targetImage;
        this.similarityThreshold = builder.similarityThreshold;
        this.qualityFilter = builder.qualityFilter;
    }

    /**
     * <p>
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
     * operations, passing base64-encoded image bytes is not supported.
     * </p>
     * <p>
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed
     * using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.
     * </p>
     * 
     * @return The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
     *         Rekognition operations, passing base64-encoded image bytes is not supported. </p>
     *         <p>
     *         If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
     *         passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
     *         developer guide.
     */
    public final Image sourceImage() {
        return sourceImage;
    }

    /**
     * <p>
     * The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
     * operations, passing base64-encoded image bytes is not supported.
     * </p>
     * <p>
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed
     * using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.
     * </p>
     * 
     * @return The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
     *         Rekognition operations, passing base64-encoded image bytes is not supported. </p>
     *         <p>
     *         If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
     *         passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
     *         developer guide.
     */
    public final Image targetImage() {
        return targetImage;
    }

    /**
     * <p>
     * The minimum level of confidence in the face matches that a match must meet to be included in the
     * <code>FaceMatches</code> array.
     * </p>
     * 
     * @return The minimum level of confidence in the face matches that a match must meet to be included in the
     *         <code>FaceMatches</code> array.
     */
    public final Float similarityThreshold() {
        return similarityThreshold;
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
     * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
     * chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur
     * for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or
     * a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The
     * default value is <code>NONE</code>.
     * </p>
     * <p>
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
     *         specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
     *         don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality
     *         detections can occur for a number of reasons. Some examples are an object that's misidentified as a face,
     *         a face that's too blurry, or a face with a pose that's too extreme to use. If you specify
     *         <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
     *         <p>
     *         To use quality filtering, the collection you are using must be associated with version 3 of the face
     *         model or higher.
     * @see QualityFilter
     */
    public final QualityFilter qualityFilter() {
        return QualityFilter.fromValue(qualityFilter);
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
     * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
     * chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur
     * for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or
     * a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The
     * default value is <code>NONE</code>.
     * </p>
     * <p>
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
     *         specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
     *         don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality
     *         detections can occur for a number of reasons. Some examples are an object that's misidentified as a face,
     *         a face that's too blurry, or a face with a pose that's too extreme to use. If you specify
     *         <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
     *         <p>
     *         To use quality filtering, the collection you are using must be associated with version 3 of the face
     *         model or higher.
     * @see QualityFilter
     */
    public final String qualityFilterAsString() {
        return qualityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceImage());
        hashCode = 31 * hashCode + Objects.hashCode(targetImage());
        hashCode = 31 * hashCode + Objects.hashCode(similarityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(qualityFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesRequest)) {
            return false;
        }
        CompareFacesRequest other = (CompareFacesRequest) obj;
        return Objects.equals(sourceImage(), other.sourceImage()) && Objects.equals(targetImage(), other.targetImage())
                && Objects.equals(similarityThreshold(), other.similarityThreshold())
                && Objects.equals(qualityFilterAsString(), other.qualityFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareFacesRequest").add("SourceImage", sourceImage()).add("TargetImage", targetImage())
                .add("SimilarityThreshold", similarityThreshold()).add("QualityFilter", qualityFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceImage":
            return Optional.ofNullable(clazz.cast(sourceImage()));
        case "TargetImage":
            return Optional.ofNullable(clazz.cast(targetImage()));
        case "SimilarityThreshold":
            return Optional.ofNullable(clazz.cast(similarityThreshold()));
        case "QualityFilter":
            return Optional.ofNullable(clazz.cast(qualityFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareFacesRequest, T> g) {
        return obj -> g.apply((CompareFacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CompareFacesRequest> {
        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * 
         * @param sourceImage
         *        The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
         *        Rekognition operations, passing base64-encoded image bytes is not supported. </p>
         *        <p>
         *        If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image
         *        bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon
         *        Rekognition developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImage(Image sourceImage);

        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceImage(Image)}.
         * 
         * @param sourceImage
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceImage(Image)
         */
        default Builder sourceImage(Consumer<Image.Builder> sourceImage) {
            return sourceImage(Image.builder().applyMutation(sourceImage).build());
        }

        /**
         * <p>
         * The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * 
         * @param targetImage
         *        The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
         *        Rekognition operations, passing base64-encoded image bytes is not supported. </p>
         *        <p>
         *        If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image
         *        bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon
         *        Rekognition developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetImage(Image targetImage);

        /**
         * <p>
         * The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #targetImage(Image)}.
         * 
         * @param targetImage
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetImage(Image)
         */
        default Builder targetImage(Consumer<Image.Builder> targetImage) {
            return targetImage(Image.builder().applyMutation(targetImage).build());
        }

        /**
         * <p>
         * The minimum level of confidence in the face matches that a match must meet to be included in the
         * <code>FaceMatches</code> array.
         * </p>
         * 
         * @param similarityThreshold
         *        The minimum level of confidence in the face matches that a match must meet to be included in the
         *        <code>FaceMatches</code> array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarityThreshold(Float similarityThreshold);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
         * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
         * chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can
         * occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too
         * blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is
         * performed. The default value is <code>NONE</code>.
         * </p>
         * <p>
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
         * higher.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
         *        specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
         *        don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases.
         *        Low-quality detections can occur for a number of reasons. Some examples are an object that's
         *        misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If
         *        you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
         *        <p>
         *        To use quality filtering, the collection you are using must be associated with version 3 of the face
         *        model or higher.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(String qualityFilter);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
         * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
         * chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can
         * occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too
         * blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is
         * performed. The default value is <code>NONE</code>.
         * </p>
         * <p>
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
         * higher.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
         *        specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
         *        don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases.
         *        Low-quality detections can occur for a number of reasons. Some examples are an object that's
         *        misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If
         *        you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
         *        <p>
         *        To use quality filtering, the collection you are using must be associated with version 3 of the face
         *        model or higher.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(QualityFilter qualityFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Image sourceImage;

        private Image targetImage;

        private Float similarityThreshold;

        private String qualityFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesRequest model) {
            super(model);
            sourceImage(model.sourceImage);
            targetImage(model.targetImage);
            similarityThreshold(model.similarityThreshold);
            qualityFilter(model.qualityFilter);
        }

        public final Image.Builder getSourceImage() {
            return sourceImage != null ? sourceImage.toBuilder() : null;
        }

        public final void setSourceImage(Image.BuilderImpl sourceImage) {
            this.sourceImage = sourceImage != null ? sourceImage.build() : null;
        }

        @Override
        public final Builder sourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final Image.Builder getTargetImage() {
            return targetImage != null ? targetImage.toBuilder() : null;
        }

        public final void setTargetImage(Image.BuilderImpl targetImage) {
            this.targetImage = targetImage != null ? targetImage.build() : null;
        }

        @Override
        public final Builder targetImage(Image targetImage) {
            this.targetImage = targetImage;
            return this;
        }

        public final Float getSimilarityThreshold() {
            return similarityThreshold;
        }

        public final void setSimilarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
        }

        @Override
        public final Builder similarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public final String getQualityFilter() {
            return qualityFilter;
        }

        public final void setQualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
        }

        @Override
        public final Builder qualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
            return this;
        }

        @Override
        public final Builder qualityFilter(QualityFilter qualityFilter) {
            this.qualityFilter(qualityFilter == null ? null : qualityFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompareFacesRequest build() {
            return new CompareFacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
