/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LabelDetectionFeatureName {
    GENERAL_LABELS("GENERAL_LABELS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LabelDetectionFeatureName> VALUE_MAP;
    private final String value;

    private LabelDetectionFeatureName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LabelDetectionFeatureName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LabelDetectionFeatureName> knownValues() {
        EnumSet<LabelDetectionFeatureName> knownValues = EnumSet.allOf(LabelDetectionFeatureName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LabelDetectionFeatureName.class, LabelDetectionFeatureName::toString);
    }
}

