/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContentClassifier {
    FREE_OF_PERSONALLY_IDENTIFIABLE_INFORMATION("FreeOfPersonallyIdentifiableInformation"),
    FREE_OF_ADULT_CONTENT("FreeOfAdultContent"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContentClassifier> VALUE_MAP;
    private final String value;

    private ContentClassifier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentClassifier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentClassifier> knownValues() {
        EnumSet<ContentClassifier> knownValues = EnumSet.allOf(ContentClassifier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContentClassifier.class, ContentClassifier::toString);
    }
}

