/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rekognition.model.RegionOfInterest;
import software.amazon.awssdk.services.rekognition.model.RegionsOfInterestCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorDataSharingPreference;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorInput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorNotificationChannel;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings;
import software.amazon.awssdk.services.rekognition.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamProcessorRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, CreateStreamProcessorRequest> {
    private static final SdkField<StreamProcessorInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::input)).setter(CreateStreamProcessorRequest.setter(Builder::input)).constructor(StreamProcessorInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<StreamProcessorOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::output)).setter(CreateStreamProcessorRequest.setter(Builder::output)).constructor(StreamProcessorOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::name)).setter(CreateStreamProcessorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<StreamProcessorSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::settings)).setter(CreateStreamProcessorRequest.setter(Builder::settings)).constructor(StreamProcessorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::roleArn)).setter(CreateStreamProcessorRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::tags)).setter(CreateStreamProcessorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<StreamProcessorNotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationChannel").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::notificationChannel)).setter(CreateStreamProcessorRequest.setter(Builder::notificationChannel)).constructor(StreamProcessorNotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::kmsKeyId)).setter(CreateStreamProcessorRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionsOfInterest").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::regionsOfInterest)).setter(CreateStreamProcessorRequest.setter(Builder::regionsOfInterest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterest").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamProcessorDataSharingPreference> DATA_SHARING_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSharingPreference").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::dataSharingPreference)).setter(CreateStreamProcessorRequest.setter(Builder::dataSharingPreference)).constructor(StreamProcessorDataSharingPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSharingPreference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, OUTPUT_FIELD, NAME_FIELD, SETTINGS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, NOTIFICATION_CHANNEL_FIELD, KMS_KEY_ID_FIELD, REGIONS_OF_INTEREST_FIELD, DATA_SHARING_PREFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStreamProcessorRequest.memberNameToFieldInitializer();
    private final StreamProcessorInput input;
    private final StreamProcessorOutput output;
    private final String name;
    private final StreamProcessorSettings settings;
    private final String roleArn;
    private final Map<String, String> tags;
    private final StreamProcessorNotificationChannel notificationChannel;
    private final String kmsKeyId;
    private final List<RegionOfInterest> regionsOfInterest;
    private final StreamProcessorDataSharingPreference dataSharingPreference;

    private CreateStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
        this.output = builder.output;
        this.name = builder.name;
        this.settings = builder.settings;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.notificationChannel = builder.notificationChannel;
        this.kmsKeyId = builder.kmsKeyId;
        this.regionsOfInterest = builder.regionsOfInterest;
        this.dataSharingPreference = builder.dataSharingPreference;
    }

    public final StreamProcessorInput input() {
        return this.input;
    }

    public final StreamProcessorOutput output() {
        return this.output;
    }

    public final String name() {
        return this.name;
    }

    public final StreamProcessorSettings settings() {
        return this.settings;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final StreamProcessorNotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasRegionsOfInterest() {
        return this.regionsOfInterest != null && !(this.regionsOfInterest instanceof SdkAutoConstructList);
    }

    public final List<RegionOfInterest> regionsOfInterest() {
        return this.regionsOfInterest;
    }

    public final StreamProcessorDataSharingPreference dataSharingPreference() {
        return this.dataSharingPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionsOfInterest() ? this.regionsOfInterest() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSharingPreference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamProcessorRequest)) {
            return false;
        }
        CreateStreamProcessorRequest other = (CreateStreamProcessorRequest)((Object)obj);
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasRegionsOfInterest() == other.hasRegionsOfInterest() && Objects.equals(this.regionsOfInterest(), other.regionsOfInterest()) && Objects.equals(this.dataSharingPreference(), other.dataSharingPreference());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStreamProcessorRequest").add("Input", (Object)this.input()).add("Output", (Object)this.output()).add("Name", (Object)this.name()).add("Settings", (Object)this.settings()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("NotificationChannel", (Object)this.notificationChannel()).add("KmsKeyId", (Object)this.kmsKeyId()).add("RegionsOfInterest", this.hasRegionsOfInterest() ? this.regionsOfInterest() : null).add("DataSharingPreference", (Object)this.dataSharingPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "RegionsOfInterest": {
                return Optional.ofNullable(clazz.cast(this.regionsOfInterest()));
            }
            case "DataSharingPreference": {
                return Optional.ofNullable(clazz.cast(this.dataSharingPreference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Input", INPUT_FIELD);
        map.put("Output", OUTPUT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NotificationChannel", NOTIFICATION_CHANNEL_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("RegionsOfInterest", REGIONS_OF_INTEREST_FIELD);
        map.put("DataSharingPreference", DATA_SHARING_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamProcessorRequest, T> g) {
        return obj -> g.apply((CreateStreamProcessorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private StreamProcessorInput input;
        private StreamProcessorOutput output;
        private String name;
        private StreamProcessorSettings settings;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private StreamProcessorNotificationChannel notificationChannel;
        private String kmsKeyId;
        private List<RegionOfInterest> regionsOfInterest = DefaultSdkAutoConstructList.getInstance();
        private StreamProcessorDataSharingPreference dataSharingPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamProcessorRequest model) {
            super(model);
            this.input(model.input);
            this.output(model.output);
            this.name(model.name);
            this.settings(model.settings);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.notificationChannel(model.notificationChannel);
            this.kmsKeyId(model.kmsKeyId);
            this.regionsOfInterest(model.regionsOfInterest);
            this.dataSharingPreference(model.dataSharingPreference);
        }

        public final StreamProcessorInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final StreamProcessorNotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        public final void setNotificationChannel(StreamProcessorNotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public final Builder notificationChannel(StreamProcessorNotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<RegionOfInterest.Builder> getRegionsOfInterest() {
            List<RegionOfInterest.Builder> result = RegionsOfInterestCopier.copyToBuilder(this.regionsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionsOfInterest(Collection<RegionOfInterest.BuilderImpl> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterest);
        }

        @Override
        public final Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copy(regionsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(RegionOfInterest ... regionsOfInterest) {
            this.regionsOfInterest(Arrays.asList(regionsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(Consumer<RegionOfInterest.Builder> ... regionsOfInterest) {
            this.regionsOfInterest(Stream.of(regionsOfInterest).map(c -> (RegionOfInterest)((RegionOfInterest.Builder)RegionOfInterest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StreamProcessorDataSharingPreference.Builder getDataSharingPreference() {
            return this.dataSharingPreference != null ? this.dataSharingPreference.toBuilder() : null;
        }

        public final void setDataSharingPreference(StreamProcessorDataSharingPreference.BuilderImpl dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference != null ? dataSharingPreference.build() : null;
        }

        @Override
        public final Builder dataSharingPreference(StreamProcessorDataSharingPreference dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamProcessorRequest build() {
            return new CreateStreamProcessorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamProcessorRequest> {
        public Builder input(StreamProcessorInput var1);

        default public Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return this.input((StreamProcessorInput)((StreamProcessorInput.Builder)StreamProcessorInput.builder().applyMutation(input)).build());
        }

        public Builder output(StreamProcessorOutput var1);

        default public Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return this.output((StreamProcessorOutput)((StreamProcessorOutput.Builder)StreamProcessorOutput.builder().applyMutation(output)).build());
        }

        public Builder name(String var1);

        public Builder settings(StreamProcessorSettings var1);

        default public Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return this.settings((StreamProcessorSettings)((StreamProcessorSettings.Builder)StreamProcessorSettings.builder().applyMutation(settings)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder notificationChannel(StreamProcessorNotificationChannel var1);

        default public Builder notificationChannel(Consumer<StreamProcessorNotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((StreamProcessorNotificationChannel)((StreamProcessorNotificationChannel.Builder)StreamProcessorNotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder regionsOfInterest(Collection<RegionOfInterest> var1);

        public Builder regionsOfInterest(RegionOfInterest ... var1);

        public Builder regionsOfInterest(Consumer<RegionOfInterest.Builder> ... var1);

        public Builder dataSharingPreference(StreamProcessorDataSharingPreference var1);

        default public Builder dataSharingPreference(Consumer<StreamProcessorDataSharingPreference.Builder> dataSharingPreference) {
            return this.dataSharingPreference((StreamProcessorDataSharingPreference)((StreamProcessorDataSharingPreference.Builder)StreamProcessorDataSharingPreference.builder().applyMutation(dataSharingPreference)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

