/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ContentType;
import software.amazon.awssdk.services.rekognition.model.ContentTypesCopier;
import software.amazon.awssdk.services.rekognition.model.HumanLoopActivationOutput;
import software.amazon.awssdk.services.rekognition.model.ModerationLabel;
import software.amazon.awssdk.services.rekognition.model.ModerationLabelsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectModerationLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectModerationLabelsResponse> {
    private static final SdkField<List<ModerationLabel>> MODERATION_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModerationLabels").getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::moderationLabels)).setter(DetectModerationLabelsResponse.setter(Builder::moderationLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModerationLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODERATION_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModerationModelVersion").getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::moderationModelVersion)).setter(DetectModerationLabelsResponse.setter(Builder::moderationModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationModelVersion").build()}).build();
    private static final SdkField<HumanLoopActivationOutput> HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopActivationOutput").getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::humanLoopActivationOutput)).setter(DetectModerationLabelsResponse.setter(Builder::humanLoopActivationOutput)).constructor(HumanLoopActivationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationOutput").build()}).build();
    private static final SdkField<String> PROJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectVersion").getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::projectVersion)).setter(DetectModerationLabelsResponse.setter(Builder::projectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersion").build()}).build();
    private static final SdkField<List<ContentType>> CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContentTypes").getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::contentTypes)).setter(DetectModerationLabelsResponse.setter(Builder::contentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContentType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODERATION_LABELS_FIELD, MODERATION_MODEL_VERSION_FIELD, HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD, PROJECT_VERSION_FIELD, CONTENT_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectModerationLabelsResponse.memberNameToFieldInitializer();
    private final List<ModerationLabel> moderationLabels;
    private final String moderationModelVersion;
    private final HumanLoopActivationOutput humanLoopActivationOutput;
    private final String projectVersion;
    private final List<ContentType> contentTypes;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.moderationLabels = builder.moderationLabels;
        this.moderationModelVersion = builder.moderationModelVersion;
        this.humanLoopActivationOutput = builder.humanLoopActivationOutput;
        this.projectVersion = builder.projectVersion;
        this.contentTypes = builder.contentTypes;
    }

    public final boolean hasModerationLabels() {
        return this.moderationLabels != null && !(this.moderationLabels instanceof SdkAutoConstructList);
    }

    public final List<ModerationLabel> moderationLabels() {
        return this.moderationLabels;
    }

    public final String moderationModelVersion() {
        return this.moderationModelVersion;
    }

    public final HumanLoopActivationOutput humanLoopActivationOutput() {
        return this.humanLoopActivationOutput;
    }

    public final String projectVersion() {
        return this.projectVersion;
    }

    public final boolean hasContentTypes() {
        return this.contentTypes != null && !(this.contentTypes instanceof SdkAutoConstructList);
    }

    public final List<ContentType> contentTypes() {
        return this.contentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModerationLabels() ? this.moderationLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.moderationModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopActivationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentTypes() ? this.contentTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse)((Object)obj);
        return this.hasModerationLabels() == other.hasModerationLabels() && Objects.equals(this.moderationLabels(), other.moderationLabels()) && Objects.equals(this.moderationModelVersion(), other.moderationModelVersion()) && Objects.equals(this.humanLoopActivationOutput(), other.humanLoopActivationOutput()) && Objects.equals(this.projectVersion(), other.projectVersion()) && this.hasContentTypes() == other.hasContentTypes() && Objects.equals(this.contentTypes(), other.contentTypes());
    }

    public final String toString() {
        return ToString.builder((String)"DetectModerationLabelsResponse").add("ModerationLabels", this.hasModerationLabels() ? this.moderationLabels() : null).add("ModerationModelVersion", (Object)this.moderationModelVersion()).add("HumanLoopActivationOutput", (Object)this.humanLoopActivationOutput()).add("ProjectVersion", (Object)this.projectVersion()).add("ContentTypes", this.hasContentTypes() ? this.contentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModerationLabels": {
                return Optional.ofNullable(clazz.cast(this.moderationLabels()));
            }
            case "ModerationModelVersion": {
                return Optional.ofNullable(clazz.cast(this.moderationModelVersion()));
            }
            case "HumanLoopActivationOutput": {
                return Optional.ofNullable(clazz.cast(this.humanLoopActivationOutput()));
            }
            case "ProjectVersion": {
                return Optional.ofNullable(clazz.cast(this.projectVersion()));
            }
            case "ContentTypes": {
                return Optional.ofNullable(clazz.cast(this.contentTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModerationLabels", MODERATION_LABELS_FIELD);
        map.put("ModerationModelVersion", MODERATION_MODEL_VERSION_FIELD);
        map.put("HumanLoopActivationOutput", HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD);
        map.put("ProjectVersion", PROJECT_VERSION_FIELD);
        map.put("ContentTypes", CONTENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectModerationLabelsResponse, T> g) {
        return obj -> g.apply((DetectModerationLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<ModerationLabel> moderationLabels = DefaultSdkAutoConstructList.getInstance();
        private String moderationModelVersion;
        private HumanLoopActivationOutput humanLoopActivationOutput;
        private String projectVersion;
        private List<ContentType> contentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            super(model);
            this.moderationLabels(model.moderationLabels);
            this.moderationModelVersion(model.moderationModelVersion);
            this.humanLoopActivationOutput(model.humanLoopActivationOutput);
            this.projectVersion(model.projectVersion);
            this.contentTypes(model.contentTypes);
        }

        public final List<ModerationLabel.Builder> getModerationLabels() {
            List<ModerationLabel.Builder> result = ModerationLabelsCopier.copyToBuilder(this.moderationLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModerationLabels(Collection<ModerationLabel.BuilderImpl> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copyFromBuilder(moderationLabels);
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel ... moderationLabels) {
            this.moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(Consumer<ModerationLabel.Builder> ... moderationLabels) {
            this.moderationLabels(Stream.of(moderationLabels).map(c -> (ModerationLabel)((ModerationLabel.Builder)ModerationLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getModerationModelVersion() {
            return this.moderationModelVersion;
        }

        public final void setModerationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
        }

        @Override
        public final Builder moderationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
            return this;
        }

        public final HumanLoopActivationOutput.Builder getHumanLoopActivationOutput() {
            return this.humanLoopActivationOutput != null ? this.humanLoopActivationOutput.toBuilder() : null;
        }

        public final void setHumanLoopActivationOutput(HumanLoopActivationOutput.BuilderImpl humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput != null ? humanLoopActivationOutput.build() : null;
        }

        @Override
        public final Builder humanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput;
            return this;
        }

        public final String getProjectVersion() {
            return this.projectVersion;
        }

        public final void setProjectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
        }

        @Override
        public final Builder projectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
            return this;
        }

        public final List<ContentType.Builder> getContentTypes() {
            List<ContentType.Builder> result = ContentTypesCopier.copyToBuilder(this.contentTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentTypes(Collection<ContentType.BuilderImpl> contentTypes) {
            this.contentTypes = ContentTypesCopier.copyFromBuilder(contentTypes);
        }

        @Override
        public final Builder contentTypes(Collection<ContentType> contentTypes) {
            this.contentTypes = ContentTypesCopier.copy(contentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(ContentType ... contentTypes) {
            this.contentTypes(Arrays.asList(contentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(Consumer<ContentType.Builder> ... contentTypes) {
            this.contentTypes(Stream.of(contentTypes).map(c -> (ContentType)((ContentType.Builder)ContentType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        public Builder moderationLabels(Collection<ModerationLabel> var1);

        public Builder moderationLabels(ModerationLabel ... var1);

        public Builder moderationLabels(Consumer<ModerationLabel.Builder> ... var1);

        public Builder moderationModelVersion(String var1);

        public Builder humanLoopActivationOutput(HumanLoopActivationOutput var1);

        default public Builder humanLoopActivationOutput(Consumer<HumanLoopActivationOutput.Builder> humanLoopActivationOutput) {
            return this.humanLoopActivationOutput((HumanLoopActivationOutput)((HumanLoopActivationOutput.Builder)HumanLoopActivationOutput.builder().applyMutation(humanLoopActivationOutput)).build());
        }

        public Builder projectVersion(String var1);

        public Builder contentTypes(Collection<ContentType> var1);

        public Builder contentTypes(ContentType ... var1);

        public Builder contentTypes(Consumer<ContentType.Builder> ... var1);
    }
}

