/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SegmentType {
    TECHNICAL_CUE("TECHNICAL_CUE"),
    SHOT("SHOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SegmentType> VALUE_MAP;
    private final String value;

    private SegmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SegmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SegmentType> knownValues() {
        EnumSet<SegmentType> knownValues = EnumSet.allOf(SegmentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SegmentType.class, SegmentType::toString);
    }
}

