/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.repostspace.model.ConfigurationStatus;
import software.amazon.awssdk.services.repostspace.model.GroupAdminsCopier;
import software.amazon.awssdk.services.repostspace.model.RepostspaceResponse;
import software.amazon.awssdk.services.repostspace.model.TierLevel;
import software.amazon.awssdk.services.repostspace.model.UserAdminsCopier;
import software.amazon.awssdk.services.repostspace.model.VanityDomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSpaceResponse
extends RepostspaceResponse
implements ToCopyableBuilder<Builder, GetSpaceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSpaceResponse.getter(GetSpaceResponse::arn)).setter(GetSpaceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(GetSpaceResponse.getter(GetSpaceResponse::clientId)).setter(GetSpaceResponse.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationStatus").getter(GetSpaceResponse.getter(GetSpaceResponse::configurationStatusAsString)).setter(GetSpaceResponse.setter(Builder::configurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build()}).build();
    private static final SdkField<Long> CONTENT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("contentSize").getter(GetSpaceResponse.getter(GetSpaceResponse::contentSize)).setter(GetSpaceResponse.setter(Builder::contentSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentSize").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createDateTime").getter(GetSpaceResponse.getter(GetSpaceResponse::createDateTime)).setter(GetSpaceResponse.setter(Builder::createDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOMER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerRoleArn").getter(GetSpaceResponse.getter(GetSpaceResponse::customerRoleArn)).setter(GetSpaceResponse.setter(Builder::customerRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerRoleArn").build()}).build();
    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deleteDateTime").getter(GetSpaceResponse.getter(GetSpaceResponse::deleteDateTime)).setter(GetSpaceResponse.setter(Builder::deleteDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetSpaceResponse.getter(GetSpaceResponse::description)).setter(GetSpaceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> GROUP_ADMINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupAdmins").getter(GetSpaceResponse.getter(GetSpaceResponse::groupAdmins)).setter(GetSpaceResponse.setter(Builder::groupAdmins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAdmins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetSpaceResponse.getter(GetSpaceResponse::name)).setter(GetSpaceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RANDOM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("randomDomain").getter(GetSpaceResponse.getter(GetSpaceResponse::randomDomain)).setter(GetSpaceResponse.setter(Builder::randomDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomDomain").build()}).build();
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(GetSpaceResponse.getter(GetSpaceResponse::spaceId)).setter(GetSpaceResponse.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSpaceResponse.getter(GetSpaceResponse::status)).setter(GetSpaceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Long> STORAGE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageLimit").getter(GetSpaceResponse.getter(GetSpaceResponse::storageLimit)).setter(GetSpaceResponse.setter(Builder::storageLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLimit").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(GetSpaceResponse.getter(GetSpaceResponse::tierAsString)).setter(GetSpaceResponse.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<List<String>> USER_ADMINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAdmins").getter(GetSpaceResponse.getter(GetSpaceResponse::userAdmins)).setter(GetSpaceResponse.setter(Builder::userAdmins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAdmins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("userCount").getter(GetSpaceResponse.getter(GetSpaceResponse::userCount)).setter(GetSpaceResponse.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()}).build();
    private static final SdkField<String> USER_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userKMSKey").getter(GetSpaceResponse.getter(GetSpaceResponse::userKMSKey)).setter(GetSpaceResponse.setter(Builder::userKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userKMSKey").build()}).build();
    private static final SdkField<String> VANITY_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vanityDomain").getter(GetSpaceResponse.getter(GetSpaceResponse::vanityDomain)).setter(GetSpaceResponse.setter(Builder::vanityDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomain").build()}).build();
    private static final SdkField<String> VANITY_DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vanityDomainStatus").getter(GetSpaceResponse.getter(GetSpaceResponse::vanityDomainStatusAsString)).setter(GetSpaceResponse.setter(Builder::vanityDomainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomainStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CLIENT_ID_FIELD, CONFIGURATION_STATUS_FIELD, CONTENT_SIZE_FIELD, CREATE_DATE_TIME_FIELD, CUSTOMER_ROLE_ARN_FIELD, DELETE_DATE_TIME_FIELD, DESCRIPTION_FIELD, GROUP_ADMINS_FIELD, NAME_FIELD, RANDOM_DOMAIN_FIELD, SPACE_ID_FIELD, STATUS_FIELD, STORAGE_LIMIT_FIELD, TIER_FIELD, USER_ADMINS_FIELD, USER_COUNT_FIELD, USER_KMS_KEY_FIELD, VANITY_DOMAIN_FIELD, VANITY_DOMAIN_STATUS_FIELD));
    private final String arn;
    private final String clientId;
    private final String configurationStatus;
    private final Long contentSize;
    private final Instant createDateTime;
    private final String customerRoleArn;
    private final Instant deleteDateTime;
    private final String description;
    private final List<String> groupAdmins;
    private final String name;
    private final String randomDomain;
    private final String spaceId;
    private final String status;
    private final Long storageLimit;
    private final String tier;
    private final List<String> userAdmins;
    private final Integer userCount;
    private final String userKMSKey;
    private final String vanityDomain;
    private final String vanityDomainStatus;

    private GetSpaceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.clientId = builder.clientId;
        this.configurationStatus = builder.configurationStatus;
        this.contentSize = builder.contentSize;
        this.createDateTime = builder.createDateTime;
        this.customerRoleArn = builder.customerRoleArn;
        this.deleteDateTime = builder.deleteDateTime;
        this.description = builder.description;
        this.groupAdmins = builder.groupAdmins;
        this.name = builder.name;
        this.randomDomain = builder.randomDomain;
        this.spaceId = builder.spaceId;
        this.status = builder.status;
        this.storageLimit = builder.storageLimit;
        this.tier = builder.tier;
        this.userAdmins = builder.userAdmins;
        this.userCount = builder.userCount;
        this.userKMSKey = builder.userKMSKey;
        this.vanityDomain = builder.vanityDomain;
        this.vanityDomainStatus = builder.vanityDomainStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final ConfigurationStatus configurationStatus() {
        return ConfigurationStatus.fromValue(this.configurationStatus);
    }

    public final String configurationStatusAsString() {
        return this.configurationStatus;
    }

    public final Long contentSize() {
        return this.contentSize;
    }

    public final Instant createDateTime() {
        return this.createDateTime;
    }

    public final String customerRoleArn() {
        return this.customerRoleArn;
    }

    public final Instant deleteDateTime() {
        return this.deleteDateTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasGroupAdmins() {
        return this.groupAdmins != null && !(this.groupAdmins instanceof SdkAutoConstructList);
    }

    public final List<String> groupAdmins() {
        return this.groupAdmins;
    }

    public final String name() {
        return this.name;
    }

    public final String randomDomain() {
        return this.randomDomain;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    public final String status() {
        return this.status;
    }

    public final Long storageLimit() {
        return this.storageLimit;
    }

    public final TierLevel tier() {
        return TierLevel.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final boolean hasUserAdmins() {
        return this.userAdmins != null && !(this.userAdmins instanceof SdkAutoConstructList);
    }

    public final List<String> userAdmins() {
        return this.userAdmins;
    }

    public final Integer userCount() {
        return this.userCount;
    }

    public final String userKMSKey() {
        return this.userKMSKey;
    }

    public final String vanityDomain() {
        return this.vanityDomain;
    }

    public final VanityDomainStatus vanityDomainStatus() {
        return VanityDomainStatus.fromValue(this.vanityDomainStatus);
    }

    public final String vanityDomainStatusAsString() {
        return this.vanityDomainStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupAdmins() ? this.groupAdmins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAdmins() ? this.userAdmins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.userKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.vanityDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.vanityDomainStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpaceResponse)) {
            return false;
        }
        GetSpaceResponse other = (GetSpaceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.configurationStatusAsString(), other.configurationStatusAsString()) && Objects.equals(this.contentSize(), other.contentSize()) && Objects.equals(this.createDateTime(), other.createDateTime()) && Objects.equals(this.customerRoleArn(), other.customerRoleArn()) && Objects.equals(this.deleteDateTime(), other.deleteDateTime()) && Objects.equals(this.description(), other.description()) && this.hasGroupAdmins() == other.hasGroupAdmins() && Objects.equals(this.groupAdmins(), other.groupAdmins()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.randomDomain(), other.randomDomain()) && Objects.equals(this.spaceId(), other.spaceId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.storageLimit(), other.storageLimit()) && Objects.equals(this.tierAsString(), other.tierAsString()) && this.hasUserAdmins() == other.hasUserAdmins() && Objects.equals(this.userAdmins(), other.userAdmins()) && Objects.equals(this.userCount(), other.userCount()) && Objects.equals(this.userKMSKey(), other.userKMSKey()) && Objects.equals(this.vanityDomain(), other.vanityDomain()) && Objects.equals(this.vanityDomainStatusAsString(), other.vanityDomainStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSpaceResponse").add("Arn", (Object)this.arn()).add("ClientId", (Object)this.clientId()).add("ConfigurationStatus", (Object)this.configurationStatusAsString()).add("ContentSize", (Object)this.contentSize()).add("CreateDateTime", (Object)this.createDateTime()).add("CustomerRoleArn", (Object)this.customerRoleArn()).add("DeleteDateTime", (Object)this.deleteDateTime()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("GroupAdmins", this.hasGroupAdmins() ? this.groupAdmins() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("RandomDomain", (Object)this.randomDomain()).add("SpaceId", (Object)this.spaceId()).add("Status", (Object)this.status()).add("StorageLimit", (Object)this.storageLimit()).add("Tier", (Object)this.tierAsString()).add("UserAdmins", this.hasUserAdmins() ? this.userAdmins() : null).add("UserCount", (Object)this.userCount()).add("UserKMSKey", (Object)this.userKMSKey()).add("VanityDomain", (Object)this.vanityDomain()).add("VanityDomainStatus", (Object)this.vanityDomainStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "configurationStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationStatusAsString()));
            }
            case "contentSize": {
                return Optional.ofNullable(clazz.cast(this.contentSize()));
            }
            case "createDateTime": {
                return Optional.ofNullable(clazz.cast(this.createDateTime()));
            }
            case "customerRoleArn": {
                return Optional.ofNullable(clazz.cast(this.customerRoleArn()));
            }
            case "deleteDateTime": {
                return Optional.ofNullable(clazz.cast(this.deleteDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "groupAdmins": {
                return Optional.ofNullable(clazz.cast(this.groupAdmins()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "randomDomain": {
                return Optional.ofNullable(clazz.cast(this.randomDomain()));
            }
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "storageLimit": {
                return Optional.ofNullable(clazz.cast(this.storageLimit()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "userAdmins": {
                return Optional.ofNullable(clazz.cast(this.userAdmins()));
            }
            case "userCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
            case "userKMSKey": {
                return Optional.ofNullable(clazz.cast(this.userKMSKey()));
            }
            case "vanityDomain": {
                return Optional.ofNullable(clazz.cast(this.vanityDomain()));
            }
            case "vanityDomainStatus": {
                return Optional.ofNullable(clazz.cast(this.vanityDomainStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSpaceResponse, T> g) {
        return obj -> g.apply((GetSpaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String clientId;
        private String configurationStatus;
        private Long contentSize;
        private Instant createDateTime;
        private String customerRoleArn;
        private Instant deleteDateTime;
        private String description;
        private List<String> groupAdmins = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String randomDomain;
        private String spaceId;
        private String status;
        private Long storageLimit;
        private String tier;
        private List<String> userAdmins = DefaultSdkAutoConstructList.getInstance();
        private Integer userCount;
        private String userKMSKey;
        private String vanityDomain;
        private String vanityDomainStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSpaceResponse model) {
            super(model);
            this.arn(model.arn);
            this.clientId(model.clientId);
            this.configurationStatus(model.configurationStatus);
            this.contentSize(model.contentSize);
            this.createDateTime(model.createDateTime);
            this.customerRoleArn(model.customerRoleArn);
            this.deleteDateTime(model.deleteDateTime);
            this.description(model.description);
            this.groupAdmins(model.groupAdmins);
            this.name(model.name);
            this.randomDomain(model.randomDomain);
            this.spaceId(model.spaceId);
            this.status(model.status);
            this.storageLimit(model.storageLimit);
            this.tier(model.tier);
            this.userAdmins(model.userAdmins);
            this.userCount(model.userCount);
            this.userKMSKey(model.userKMSKey);
            this.vanityDomain(model.vanityDomain);
            this.vanityDomainStatus(model.vanityDomainStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getConfigurationStatus() {
            return this.configurationStatus;
        }

        public final void setConfigurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
        }

        @Override
        public final Builder configurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus(configurationStatus == null ? null : configurationStatus.toString());
            return this;
        }

        public final Long getContentSize() {
            return this.contentSize;
        }

        public final void setContentSize(Long contentSize) {
            this.contentSize = contentSize;
        }

        @Override
        public final Builder contentSize(Long contentSize) {
            this.contentSize = contentSize;
            return this;
        }

        public final Instant getCreateDateTime() {
            return this.createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final String getCustomerRoleArn() {
            return this.customerRoleArn;
        }

        public final void setCustomerRoleArn(String customerRoleArn) {
            this.customerRoleArn = customerRoleArn;
        }

        @Override
        public final Builder customerRoleArn(String customerRoleArn) {
            this.customerRoleArn = customerRoleArn;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return this.deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getGroupAdmins() {
            if (this.groupAdmins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupAdmins;
        }

        public final void setGroupAdmins(Collection<String> groupAdmins) {
            this.groupAdmins = GroupAdminsCopier.copy(groupAdmins);
        }

        @Override
        public final Builder groupAdmins(Collection<String> groupAdmins) {
            this.groupAdmins = GroupAdminsCopier.copy(groupAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupAdmins(String ... groupAdmins) {
            this.groupAdmins(Arrays.asList(groupAdmins));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRandomDomain() {
            return this.randomDomain;
        }

        public final void setRandomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
        }

        @Override
        public final Builder randomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
            return this;
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Long getStorageLimit() {
            return this.storageLimit;
        }

        public final void setStorageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Collection<String> getUserAdmins() {
            if (this.userAdmins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userAdmins;
        }

        public final void setUserAdmins(Collection<String> userAdmins) {
            this.userAdmins = UserAdminsCopier.copy(userAdmins);
        }

        @Override
        public final Builder userAdmins(Collection<String> userAdmins) {
            this.userAdmins = UserAdminsCopier.copy(userAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAdmins(String ... userAdmins) {
            this.userAdmins(Arrays.asList(userAdmins));
            return this;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final String getUserKMSKey() {
            return this.userKMSKey;
        }

        public final void setUserKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
        }

        @Override
        public final Builder userKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
            return this;
        }

        public final String getVanityDomain() {
            return this.vanityDomain;
        }

        public final void setVanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
        }

        @Override
        public final Builder vanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
            return this;
        }

        public final String getVanityDomainStatus() {
            return this.vanityDomainStatus;
        }

        public final void setVanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
        }

        @Override
        public final Builder vanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
            return this;
        }

        @Override
        public final Builder vanityDomainStatus(VanityDomainStatus vanityDomainStatus) {
            this.vanityDomainStatus(vanityDomainStatus == null ? null : vanityDomainStatus.toString());
            return this;
        }

        @Override
        public GetSpaceResponse build() {
            return new GetSpaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RepostspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSpaceResponse> {
        public Builder arn(String var1);

        public Builder clientId(String var1);

        public Builder configurationStatus(String var1);

        public Builder configurationStatus(ConfigurationStatus var1);

        public Builder contentSize(Long var1);

        public Builder createDateTime(Instant var1);

        public Builder customerRoleArn(String var1);

        public Builder deleteDateTime(Instant var1);

        public Builder description(String var1);

        public Builder groupAdmins(Collection<String> var1);

        public Builder groupAdmins(String ... var1);

        public Builder name(String var1);

        public Builder randomDomain(String var1);

        public Builder spaceId(String var1);

        public Builder status(String var1);

        public Builder storageLimit(Long var1);

        public Builder tier(String var1);

        public Builder tier(TierLevel var1);

        public Builder userAdmins(Collection<String> var1);

        public Builder userAdmins(String ... var1);

        public Builder userCount(Integer var1);

        public Builder userKMSKey(String var1);

        public Builder vanityDomain(String var1);

        public Builder vanityDomainStatus(String var1);

        public Builder vanityDomainStatus(VanityDomainStatus var1);
    }
}

