/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppVersionResourceResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<DescribeAppVersionResourceResponse.Builder, DescribeAppVersionResourceResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(DescribeAppVersionResourceResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(DescribeAppVersionResourceResponse::appVersion))
            .setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<PhysicalResource> PHYSICAL_RESOURCE_FIELD = SdkField
            .<PhysicalResource> builder(MarshallingType.SDK_POJO).memberName("physicalResource")
            .getter(getter(DescribeAppVersionResourceResponse::physicalResource)).setter(setter(Builder::physicalResource))
            .constructor(PhysicalResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, PHYSICAL_RESOURCE_FIELD));

    private final String appArn;

    private final String appVersion;

    private final PhysicalResource physicalResource;

    private DescribeAppVersionResourceResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.physicalResource = builder.physicalResource;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Resilience Hub application version.
     * </p>
     * 
     * @return Resilience Hub application version.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified
     * using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
     * </p>
     * 
     * @return Defines a physical resource. A physical resource is a resource that exists in your account. It can be
     *         identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
     */
    public final PhysicalResource physicalResource() {
        return physicalResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppVersionResourceResponse)) {
            return false;
        }
        DescribeAppVersionResourceResponse other = (DescribeAppVersionResourceResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(physicalResource(), other.physicalResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppVersionResourceResponse").add("AppArn", appArn()).add("AppVersion", appVersion())
                .add("PhysicalResource", physicalResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "physicalResource":
            return Optional.ofNullable(clazz.cast(physicalResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppVersionResourceResponse, T> g) {
        return obj -> g.apply((DescribeAppVersionResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppVersionResourceResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Resilience Hub application version.
         * </p>
         * 
         * @param appVersion
         *        Resilience Hub application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * Defines a physical resource. A physical resource is a resource that exists in your account. It can be
         * identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
         * </p>
         * 
         * @param physicalResource
         *        Defines a physical resource. A physical resource is a resource that exists in your account. It can be
         *        identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResource(PhysicalResource physicalResource);

        /**
         * <p>
         * Defines a physical resource. A physical resource is a resource that exists in your account. It can be
         * identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalResource.Builder} avoiding the
         * need to create one manually via {@link PhysicalResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalResource.Builder#build()} is called immediately and its
         * result is passed to {@link #physicalResource(PhysicalResource)}.
         * 
         * @param physicalResource
         *        a consumer that will call methods on {@link PhysicalResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalResource(PhysicalResource)
         */
        default Builder physicalResource(Consumer<PhysicalResource.Builder> physicalResource) {
            return physicalResource(PhysicalResource.builder().applyMutation(physicalResource).build());
        }
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private PhysicalResource physicalResource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppVersionResourceResponse model) {
            super(model);
            appArn(model.appArn);
            appVersion(model.appVersion);
            physicalResource(model.physicalResource);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final PhysicalResource.Builder getPhysicalResource() {
            return physicalResource != null ? physicalResource.toBuilder() : null;
        }

        public final void setPhysicalResource(PhysicalResource.BuilderImpl physicalResource) {
            this.physicalResource = physicalResource != null ? physicalResource.build() : null;
        }

        @Override
        public final Builder physicalResource(PhysicalResource physicalResource) {
            this.physicalResource = physicalResource;
            return this;
        }

        @Override
        public DescribeAppVersionResourceResponse build() {
            return new DescribeAppVersionResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
