/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppVersionSummary> {
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(AppVersionSummary.getter(AppVersionSummary::appVersion)).setter(AppVersionSummary.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AppVersionSummary.getter(AppVersionSummary::creationTime)).setter(AppVersionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Long> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("identifier").getter(AppVersionSummary.getter(AppVersionSummary::identifier)).setter(AppVersionSummary.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(AppVersionSummary.getter(AppVersionSummary::versionName)).setter(AppVersionSummary.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_VERSION_FIELD, CREATION_TIME_FIELD, IDENTIFIER_FIELD, VERSION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppVersionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appVersion;
    private final Instant creationTime;
    private final Long identifier;
    private final String versionName;

    private AppVersionSummary(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.creationTime = builder.creationTime;
        this.identifier = builder.identifier;
        this.versionName = builder.versionName;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Long identifier() {
        return this.identifier;
    }

    public final String versionName() {
        return this.versionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppVersionSummary)) {
            return false;
        }
        AppVersionSummary other = (AppVersionSummary)obj;
        return Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.versionName(), other.versionName());
    }

    public final String toString() {
        return ToString.builder((String)"AppVersionSummary").add("AppVersion", (Object)this.appVersion()).add("CreationTime", (Object)this.creationTime()).add("Identifier", (Object)this.identifier()).add("VersionName", (Object)this.versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppVersionSummary, T> g) {
        return obj -> g.apply((AppVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appVersion;
        private Instant creationTime;
        private Long identifier;
        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppVersionSummary model) {
            this.appVersion(model.appVersion);
            this.creationTime(model.creationTime);
            this.identifier(model.identifier);
            this.versionName(model.versionName);
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(Long identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(Long identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public AppVersionSummary build() {
            return new AppVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppVersionSummary> {
        public Builder appVersion(String var1);

        public Builder creationTime(Instant var1);

        public Builder identifier(Long var1);

        public Builder versionName(String var1);
    }
}

