/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConditionOperatorType {
    EQUALS("Equals"),
    NOT_EQUALS("NotEquals"),
    GREATER_THEN("GreaterThen"),
    GREATER_OR_EQUALS("GreaterOrEquals"),
    LESS_THEN("LessThen"),
    LESS_OR_EQUALS("LessOrEquals"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConditionOperatorType> VALUE_MAP;
    private final String value;

    private ConditionOperatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConditionOperatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConditionOperatorType> knownValues() {
        EnumSet<ConditionOperatorType> knownValues = EnumSet.allOf(ConditionOperatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConditionOperatorType.class, ConditionOperatorType::toString);
    }
}

