/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationIdListCopier;
import software.amazon.awssdk.services.resiliencehub.model.RenderRecommendationType;
import software.amazon.awssdk.services.resiliencehub.model.RenderRecommendationTypeListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.TagMapCopier;
import software.amazon.awssdk.services.resiliencehub.model.TemplateFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRecommendationTemplateRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, CreateRecommendationTemplateRequest> {
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentArn").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::assessmentArn)).setter(CreateRecommendationTemplateRequest.setter(Builder::assessmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::bucketName)).setter(CreateRecommendationTemplateRequest.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::clientToken)).setter(CreateRecommendationTemplateRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::formatAsString)).setter(CreateRecommendationTemplateRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::name)).setter(CreateRecommendationTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationIds").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::recommendationIds)).setter(CreateRecommendationTemplateRequest.setter(Builder::recommendationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationTypes").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::recommendationTypesAsStrings)).setter(CreateRecommendationTemplateRequest.setter(Builder::recommendationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRecommendationTemplateRequest.getter(CreateRecommendationTemplateRequest::tags)).setter(CreateRecommendationTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ARN_FIELD, BUCKET_NAME_FIELD, CLIENT_TOKEN_FIELD, FORMAT_FIELD, NAME_FIELD, RECOMMENDATION_IDS_FIELD, RECOMMENDATION_TYPES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRecommendationTemplateRequest.memberNameToFieldInitializer();
    private final String assessmentArn;
    private final String bucketName;
    private final String clientToken;
    private final String format;
    private final String name;
    private final List<String> recommendationIds;
    private final List<String> recommendationTypes;
    private final Map<String, String> tags;

    private CreateRecommendationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentArn = builder.assessmentArn;
        this.bucketName = builder.bucketName;
        this.clientToken = builder.clientToken;
        this.format = builder.format;
        this.name = builder.name;
        this.recommendationIds = builder.recommendationIds;
        this.recommendationTypes = builder.recommendationTypes;
        this.tags = builder.tags;
    }

    public final String assessmentArn() {
        return this.assessmentArn;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final TemplateFormat format() {
        return TemplateFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRecommendationIds() {
        return this.recommendationIds != null && !(this.recommendationIds instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationIds() {
        return this.recommendationIds;
    }

    public final List<RenderRecommendationType> recommendationTypes() {
        return RenderRecommendationTypeListCopier.copyStringToEnum(this.recommendationTypes);
    }

    public final boolean hasRecommendationTypes() {
        return this.recommendationTypes != null && !(this.recommendationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationTypesAsStrings() {
        return this.recommendationTypes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationIds() ? this.recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationTypes() ? this.recommendationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommendationTemplateRequest)) {
            return false;
        }
        CreateRecommendationTemplateRequest other = (CreateRecommendationTemplateRequest)((Object)obj);
        return Objects.equals(this.assessmentArn(), other.assessmentArn()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.name(), other.name()) && this.hasRecommendationIds() == other.hasRecommendationIds() && Objects.equals(this.recommendationIds(), other.recommendationIds()) && this.hasRecommendationTypes() == other.hasRecommendationTypes() && Objects.equals(this.recommendationTypesAsStrings(), other.recommendationTypesAsStrings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRecommendationTemplateRequest").add("AssessmentArn", (Object)this.assessmentArn()).add("BucketName", (Object)this.bucketName()).add("ClientToken", (Object)this.clientToken()).add("Format", (Object)this.formatAsString()).add("Name", (Object)this.name()).add("RecommendationIds", this.hasRecommendationIds() ? this.recommendationIds() : null).add("RecommendationTypes", this.hasRecommendationTypes() ? this.recommendationTypesAsStrings() : null).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentArn()));
            }
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recommendationIds": {
                return Optional.ofNullable(clazz.cast(this.recommendationIds()));
            }
            case "recommendationTypes": {
                return Optional.ofNullable(clazz.cast(this.recommendationTypesAsStrings()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assessmentArn", ASSESSMENT_ARN_FIELD);
        map.put("bucketName", BUCKET_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("recommendationIds", RECOMMENDATION_IDS_FIELD);
        map.put("recommendationTypes", RECOMMENDATION_TYPES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommendationTemplateRequest, T> g) {
        return obj -> g.apply((CreateRecommendationTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String assessmentArn;
        private String bucketName;
        private String clientToken;
        private String format;
        private String name;
        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> recommendationTypes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommendationTemplateRequest model) {
            super(model);
            this.assessmentArn(model.assessmentArn);
            this.bucketName(model.bucketName);
            this.clientToken(model.clientToken);
            this.format(model.format);
            this.name(model.name);
            this.recommendationIds(model.recommendationIds);
            this.recommendationTypesWithStrings(model.recommendationTypes);
            this.tags(model.tags);
        }

        public final String getAssessmentArn() {
            return this.assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TemplateFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (this.recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String ... recommendationIds) {
            this.recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final Collection<String> getRecommendationTypes() {
            if (this.recommendationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationTypes;
        }

        public final void setRecommendationTypes(Collection<String> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copy(recommendationTypes);
        }

        @Override
        public final Builder recommendationTypesWithStrings(Collection<String> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copy(recommendationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTypesWithStrings(String ... recommendationTypes) {
            this.recommendationTypesWithStrings(Arrays.asList(recommendationTypes));
            return this;
        }

        @Override
        public final Builder recommendationTypes(Collection<RenderRecommendationType> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copyEnumToString(recommendationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationTypes(RenderRecommendationType ... recommendationTypes) {
            this.recommendationTypes(Arrays.asList(recommendationTypes));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRecommendationTemplateRequest build() {
            return new CreateRecommendationTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRecommendationTemplateRequest> {
        public Builder assessmentArn(String var1);

        public Builder bucketName(String var1);

        public Builder clientToken(String var1);

        public Builder format(String var1);

        public Builder format(TemplateFormat var1);

        public Builder name(String var1);

        public Builder recommendationIds(Collection<String> var1);

        public Builder recommendationIds(String ... var1);

        public Builder recommendationTypesWithStrings(Collection<String> var1);

        public Builder recommendationTypesWithStrings(String ... var1);

        public Builder recommendationTypes(Collection<RenderRecommendationType> var1);

        public Builder recommendationTypes(RenderRecommendationType ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

