/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendationListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceGroupingRecommendationsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListResourceGroupingRecommendationsResponse> {
    private static final SdkField<List<GroupingRecommendation>> GROUPING_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupingRecommendations").getter(ListResourceGroupingRecommendationsResponse.getter(ListResourceGroupingRecommendationsResponse::groupingRecommendations)).setter(ListResourceGroupingRecommendationsResponse.setter(Builder::groupingRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupingRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResourceGroupingRecommendationsResponse.getter(ListResourceGroupingRecommendationsResponse::nextToken)).setter(ListResourceGroupingRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPING_RECOMMENDATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceGroupingRecommendationsResponse.memberNameToFieldInitializer();
    private final List<GroupingRecommendation> groupingRecommendations;
    private final String nextToken;

    private ListResourceGroupingRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.groupingRecommendations = builder.groupingRecommendations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGroupingRecommendations() {
        return this.groupingRecommendations != null && !(this.groupingRecommendations instanceof SdkAutoConstructList);
    }

    public final List<GroupingRecommendation> groupingRecommendations() {
        return this.groupingRecommendations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupingRecommendations() ? this.groupingRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceGroupingRecommendationsResponse)) {
            return false;
        }
        ListResourceGroupingRecommendationsResponse other = (ListResourceGroupingRecommendationsResponse)((Object)obj);
        return this.hasGroupingRecommendations() == other.hasGroupingRecommendations() && Objects.equals(this.groupingRecommendations(), other.groupingRecommendations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceGroupingRecommendationsResponse").add("GroupingRecommendations", this.hasGroupingRecommendations() ? this.groupingRecommendations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupingRecommendations": {
                return Optional.ofNullable(clazz.cast(this.groupingRecommendations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupingRecommendations", GROUPING_RECOMMENDATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceGroupingRecommendationsResponse, T> g) {
        return obj -> g.apply((ListResourceGroupingRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<GroupingRecommendation> groupingRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceGroupingRecommendationsResponse model) {
            super(model);
            this.groupingRecommendations(model.groupingRecommendations);
            this.nextToken(model.nextToken);
        }

        public final List<GroupingRecommendation.Builder> getGroupingRecommendations() {
            List<GroupingRecommendation.Builder> result = GroupingRecommendationListCopier.copyToBuilder(this.groupingRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupingRecommendations(Collection<GroupingRecommendation.BuilderImpl> groupingRecommendations) {
            this.groupingRecommendations = GroupingRecommendationListCopier.copyFromBuilder(groupingRecommendations);
        }

        @Override
        public final Builder groupingRecommendations(Collection<GroupingRecommendation> groupingRecommendations) {
            this.groupingRecommendations = GroupingRecommendationListCopier.copy(groupingRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingRecommendations(GroupingRecommendation ... groupingRecommendations) {
            this.groupingRecommendations(Arrays.asList(groupingRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingRecommendations(Consumer<GroupingRecommendation.Builder> ... groupingRecommendations) {
            this.groupingRecommendations(Stream.of(groupingRecommendations).map(c -> (GroupingRecommendation)((GroupingRecommendation.Builder)GroupingRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceGroupingRecommendationsResponse build() {
            return new ListResourceGroupingRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceGroupingRecommendationsResponse> {
        public Builder groupingRecommendations(Collection<GroupingRecommendation> var1);

        public Builder groupingRecommendations(GroupingRecommendation ... var1);

        public Builder groupingRecommendations(Consumer<GroupingRecommendation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

