/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.resourceexplorer2.model.AccessDeniedException;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ConflictException;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.InternalServerException;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Exception;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ThrottlingException;
import software.amazon.awssdk.services.resourceexplorer2.model.UnauthorizedException;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ValidationException;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable;
import software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable;

/**
 * Service client for accessing AWS Resource Explorer. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Resource Explorer is a resource search and discovery service. By using Resource Explorer, you can
 * explore your resources using an internet search engine-like experience. Examples of resources include Amazon
 * Relational Database Service (Amazon RDS) instances, Amazon Simple Storage Service (Amazon S3) buckets, or Amazon
 * DynamoDB tables. You can search for your resources using resource metadata like names, tags, and IDs. Resource
 * Explorer can search across all of the Amazon Web Services Regions in your account in which you turn the service on,
 * to simplify your cross-Region workloads.
 * </p>
 * <p>
 * Resource Explorer scans the resources in each of the Amazon Web Services Regions in your Amazon Web Services account
 * in which you turn on Resource Explorer. Resource Explorer <a href=
 * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/getting-started-terms-and-concepts.html#term-index"
 * >creates and maintains an index</a> in each Region, with the details of that Region's resources.
 * </p>
 * <p>
 * You can <a href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">search
 * across all of the indexed Regions in your account</a> by designating one of your Amazon Web Services Regions to
 * contain the aggregator index for the account. When you <a
 * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region-turn-on.html">promote a
 * local index in a Region to become the aggregator index for the account</a>, Resource Explorer automatically
 * replicates the index information from all local indexes in the other Regions to the aggregator index. Therefore, the
 * Region with the aggregator index has a copy of all resource information for all Regions in the account where you
 * turned on Resource Explorer. As a result, views in the aggregator index Region include resources from all of the
 * indexed Regions in your account.
 * </p>
 * <p>
 * For more information about Amazon Web Services Resource Explorer, including how to enable and configure the service,
 * see the <a href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/">Amazon Web Services Resource
 * Explorer User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ResourceExplorer2Client extends AwsClient {
    String SERVICE_NAME = "resource-explorer-2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "resource-explorer-2";

    /**
     * <p>
     * Sets the specified view as the default for the Amazon Web Services Region in which you call this operation. When
     * a user performs a <a>Search</a> that doesn't explicitly specify which view to use, then Amazon Web Services
     * Resource Explorer automatically chooses this default view for searches performed in this Amazon Web Services
     * Region.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     *
     * @param associateDefaultViewRequest
     * @return Result of the AssociateDefaultView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.AssociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/AssociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDefaultViewResponse associateDefaultView(AssociateDefaultViewRequest associateDefaultViewRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified view as the default for the Amazon Web Services Region in which you call this operation. When
     * a user performs a <a>Search</a> that doesn't explicitly specify which view to use, then Amazon Web Services
     * Resource Explorer automatically chooses this default view for searches performed in this Amazon Web Services
     * Region.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDefaultViewRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDefaultViewRequest#builder()}
     * </p>
     *
     * @param associateDefaultViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateDefaultView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.AssociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/AssociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDefaultViewResponse associateDefaultView(
            Consumer<AssociateDefaultViewRequest.Builder> associateDefaultViewRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        return associateDefaultView(AssociateDefaultViewRequest.builder().applyMutation(associateDefaultViewRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a list of views.
     * </p>
     *
     * @param batchGetViewRequest
     * @return Result of the BatchGetView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.BatchGetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/BatchGetView"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetViewResponse batchGetView(BatchGetViewRequest batchGetViewRequest) throws InternalServerException,
            ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a list of views.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetViewRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetViewRequest#builder()}
     * </p>
     *
     * @param batchGetViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.BatchGetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/BatchGetView"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetViewResponse batchGetView(Consumer<BatchGetViewRequest.Builder> batchGetViewRequest)
            throws InternalServerException, ValidationException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return batchGetView(BatchGetViewRequest.builder().applyMutation(batchGetViewRequest).build());
    }

    /**
     * <p>
     * Turns on Amazon Web Services Resource Explorer in the Amazon Web Services Region in which you called this
     * operation by creating an index. Resource Explorer begins discovering the resources in this Region and stores the
     * details about the resources in the index so that they can be queried by using the <a>Search</a> operation. You
     * can create only one index in a Region.
     * </p>
     * <note>
     * <p>
     * This operation creates only a <i>local</i> index. To promote the local index in one Amazon Web Services Region
     * into the aggregator index for the Amazon Web Services account, use the <a>UpdateIndexType</a> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more details about what happens when you turn on Resource Explorer in an Amazon Web Services Region, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-service-activate.html">Turn on
     * Resource Explorer to index your resources in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * If this is the first Amazon Web Services Region in which you've created an index for Resource Explorer, then this
     * operation also <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >creates a service-linked role</a> in your Amazon Web Services account that allows Resource Explorer to enumerate
     * your resources to populate the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Action</b>: <code>resource-explorer-2:CreateIndex</code>
     * </p>
     * <p>
     * <b>Resource</b>: The ARN of the index (as it will exist after the operation completes) in the Amazon Web Services
     * Region and account in which you're trying to create the index. Use the wildcard character (<code>*</code>) at the
     * end of the string to match the eventual UUID. For example, the following <code>Resource</code> element restricts
     * the role or user to creating an index in only the <code>us-east-2</code> Region of the specified account.
     * </p>
     * <p>
     * <code>"Resource": "arn:aws:resource-explorer-2:us-west-2:<i>&lt;account-id&gt;</i>:index/*"</code>
     * </p>
     * <p>
     * Alternatively, you can use <code>"Resource": "*"</code> to allow the role or user to create an index in any
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Action</b>: <code>iam:CreateServiceLinkedRole</code>
     * </p>
     * <p>
     * <b>Resource</b>: No specific resource (*).
     * </p>
     * <p>
     * This permission is required only the first time you create an index to turn on Resource Explorer in the account.
     * Resource Explorer uses this to create the <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >service-linked role needed to index the resources in your account</a>. Resource Explorer uses the same
     * service-linked role for all additional indexes you create afterwards.
     * </p>
     * </li>
     * </ul>
     *
     * @param createIndexRequest
     * @return Result of the CreateIndex operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws InternalServerException,
            ValidationException, ConflictException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns on Amazon Web Services Resource Explorer in the Amazon Web Services Region in which you called this
     * operation by creating an index. Resource Explorer begins discovering the resources in this Region and stores the
     * details about the resources in the index so that they can be queried by using the <a>Search</a> operation. You
     * can create only one index in a Region.
     * </p>
     * <note>
     * <p>
     * This operation creates only a <i>local</i> index. To promote the local index in one Amazon Web Services Region
     * into the aggregator index for the Amazon Web Services account, use the <a>UpdateIndexType</a> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more details about what happens when you turn on Resource Explorer in an Amazon Web Services Region, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-service-activate.html">Turn on
     * Resource Explorer to index your resources in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * If this is the first Amazon Web Services Region in which you've created an index for Resource Explorer, then this
     * operation also <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >creates a service-linked role</a> in your Amazon Web Services account that allows Resource Explorer to enumerate
     * your resources to populate the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Action</b>: <code>resource-explorer-2:CreateIndex</code>
     * </p>
     * <p>
     * <b>Resource</b>: The ARN of the index (as it will exist after the operation completes) in the Amazon Web Services
     * Region and account in which you're trying to create the index. Use the wildcard character (<code>*</code>) at the
     * end of the string to match the eventual UUID. For example, the following <code>Resource</code> element restricts
     * the role or user to creating an index in only the <code>us-east-2</code> Region of the specified account.
     * </p>
     * <p>
     * <code>"Resource": "arn:aws:resource-explorer-2:us-west-2:<i>&lt;account-id&gt;</i>:index/*"</code>
     * </p>
     * <p>
     * Alternatively, you can use <code>"Resource": "*"</code> to allow the role or user to create an index in any
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Action</b>: <code>iam:CreateServiceLinkedRole</code>
     * </p>
     * <p>
     * <b>Resource</b>: No specific resource (*).
     * </p>
     * <p>
     * This permission is required only the first time you create an index to turn on Resource Explorer in the account.
     * Resource Explorer uses this to create the <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >service-linked role needed to index the resources in your account</a>. Resource Explorer uses the same
     * service-linked role for all additional indexes you create afterwards.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIndex operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIndexResponse createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest)
            throws InternalServerException, ValidationException, ConflictException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates a view that users can query by using the <a>Search</a> operation. Results from queries that you make
     * using this view include only resources that match the view's <code>Filters</code>. For more information about
     * Amazon Web Services Resource Explorer views, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html">Managing views</a> in the
     * <i>Amazon Web Services Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * Only the principals with an IAM identity-based policy that grants <code>Allow</code> to the <code>Search</code>
     * action on a <code>Resource</code> with the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name (ARN)</a>
     * of this view can <a>Search</a> using views you create with this operation.
     * </p>
     *
     * @param createViewRequest
     * @return Result of the CreateView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateView"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateViewResponse createView(CreateViewRequest createViewRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a view that users can query by using the <a>Search</a> operation. Results from queries that you make
     * using this view include only resources that match the view's <code>Filters</code>. For more information about
     * Amazon Web Services Resource Explorer views, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html">Managing views</a> in the
     * <i>Amazon Web Services Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * Only the principals with an IAM identity-based policy that grants <code>Allow</code> to the <code>Search</code>
     * action on a <code>Resource</code> with the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name (ARN)</a>
     * of this view can <a>Search</a> using views you create with this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateViewRequest.Builder} avoiding the need to
     * create one manually via {@link CreateViewRequest#builder()}
     * </p>
     *
     * @param createViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest.Builder} to create a
     *        request.
     * @return Result of the CreateView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateView"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateViewResponse createView(Consumer<CreateViewRequest.Builder> createViewRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return createView(CreateViewRequest.builder().applyMutation(createViewRequest).build());
    }

    /**
     * <p>
     * Deletes the specified index and turns off Amazon Web Services Resource Explorer in the specified Amazon Web
     * Services Region. When you delete an index, Resource Explorer stops discovering and indexing resources in that
     * Region. Resource Explorer also deletes all views in that Region. These actions occur as asynchronous background
     * tasks. You can check to see when the actions are complete by using the <a>GetIndex</a> operation and checking the
     * <code>Status</code> response value.
     * </p>
     * <note>
     * <p>
     * If the index you delete is the aggregator index for the Amazon Web Services account, you must wait 24 hours
     * before you can promote another local index to be the aggregator index for the account. Users can't perform
     * account-wide searches using Resource Explorer until another aggregator index is configured.
     * </p>
     * </note>
     *
     * @param deleteIndexRequest
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified index and turns off Amazon Web Services Resource Explorer in the specified Amazon Web
     * Services Region. When you delete an index, Resource Explorer stops discovering and indexing resources in that
     * Region. Resource Explorer also deletes all views in that Region. These actions occur as asynchronous background
     * tasks. You can check to see when the actions are complete by using the <a>GetIndex</a> operation and checking the
     * <code>Status</code> response value.
     * </p>
     * <note>
     * <p>
     * If the index you delete is the aggregator index for the Amazon Web Services account, you must wait 24 hours
     * before you can promote another local index to be the aggregator index for the account. Users can't perform
     * account-wide searches using Resource Explorer until another aggregator index is configured.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes the specified view.
     * </p>
     * <p>
     * If the specified view is the default view for its Amazon Web Services Region, then all <a>Search</a> operations
     * in that Region must explicitly specify the view to use until you configure a new default by calling the
     * <a>AssociateDefaultView</a> operation.
     * </p>
     *
     * @param deleteViewRequest
     * @return Result of the DeleteView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteView"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteViewResponse deleteView(DeleteViewRequest deleteViewRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified view.
     * </p>
     * <p>
     * If the specified view is the default view for its Amazon Web Services Region, then all <a>Search</a> operations
     * in that Region must explicitly specify the view to use until you configure a new default by calling the
     * <a>AssociateDefaultView</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteViewRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteViewRequest#builder()}
     * </p>
     *
     * @param deleteViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteView"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteViewResponse deleteView(Consumer<DeleteViewRequest.Builder> deleteViewRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return deleteView(DeleteViewRequest.builder().applyMutation(deleteViewRequest).build());
    }

    /**
     * <p>
     * After you call this operation, the affected Amazon Web Services Region no longer has a default view. All
     * <a>Search</a> operations in that Region must explicitly specify a view or the operation fails. You can configure
     * a new default by calling the <a>AssociateDefaultView</a> operation.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     *
     * @param disassociateDefaultViewRequest
     * @return Result of the DisassociateDefaultView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DisassociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DisassociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDefaultViewResponse disassociateDefaultView(DisassociateDefaultViewRequest disassociateDefaultViewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * After you call this operation, the affected Amazon Web Services Region no longer has a default view. All
     * <a>Search</a> operations in that Region must explicitly specify a view or the operation fails. You can configure
     * a new default by calling the <a>AssociateDefaultView</a> operation.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDefaultViewRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDefaultViewRequest#builder()}
     * </p>
     *
     * @param disassociateDefaultViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateDefaultView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DisassociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DisassociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDefaultViewResponse disassociateDefaultView(
            Consumer<DisassociateDefaultViewRequest.Builder> disassociateDefaultViewRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        return disassociateDefaultView(DisassociateDefaultViewRequest.builder().applyMutation(disassociateDefaultViewRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the Amazon Resource Name (ARN) of the view that is the default for the Amazon Web Services Region in
     * which you call this operation. You can then call <a>GetView</a> to retrieve the details of that view.
     * </p>
     *
     * @param getDefaultViewRequest
     * @return Result of the GetDefaultView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDefaultViewResponse getDefaultView(GetDefaultViewRequest getDefaultViewRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Resource Name (ARN) of the view that is the default for the Amazon Web Services Region in
     * which you call this operation. You can then call <a>GetView</a> to retrieve the details of that view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetDefaultViewRequest#builder()}
     * </p>
     *
     * @param getDefaultViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewRequest.Builder} to create a
     *        request.
     * @return Result of the GetDefaultView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDefaultViewResponse getDefaultView(Consumer<GetDefaultViewRequest.Builder> getDefaultViewRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return getDefaultView(GetDefaultViewRequest.builder().applyMutation(getDefaultViewRequest).build());
    }

    /**
     * <p>
     * Retrieves details about the Amazon Web Services Resource Explorer index in the Amazon Web Services Region in
     * which you invoked the operation.
     * </p>
     *
     * @param getIndexRequest
     * @return Result of the GetIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws ResourceNotFoundException, InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about the Amazon Web Services Resource Explorer index in the Amazon Web Services Region in
     * which you invoked the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexRequest.Builder} avoiding the need to
     * create one manually via {@link GetIndexRequest#builder()}
     * </p>
     *
     * @param getIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetIndexRequest.Builder} to create a
     *        request.
     * @return Result of the GetIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIndexResponse getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        return getIndex(GetIndexRequest.builder().applyMutation(getIndexRequest).build());
    }

    /**
     * <p>
     * Retrieves details of the specified view.
     * </p>
     *
     * @param getViewRequest
     * @return Result of the GetView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetView" target="_top">AWS
     *      API Documentation</a>
     */
    default GetViewResponse getView(GetViewRequest getViewRequest) throws ResourceNotFoundException, InternalServerException,
            ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of the specified view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetViewRequest.Builder} avoiding the need to create
     * one manually via {@link GetViewRequest#builder()}
     * </p>
     *
     * @param getViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest.Builder} to create a
     *        request.
     * @return Result of the GetView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetView" target="_top">AWS
     *      API Documentation</a>
     */
    default GetViewResponse getView(Consumer<GetViewRequest.Builder> getViewRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return getView(GetViewRequest.builder().applyMutation(getViewRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer.
     * </p>
     *
     * @param listIndexesRequest
     * @return Result of the ListIndexes operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesResponse listIndexes(ListIndexesRequest listIndexesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest.Builder} to create a
     *        request.
     * @return Result of the ListIndexes operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesResponse listIndexes(Consumer<ListIndexesRequest.Builder> listIndexesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        return listIndexes(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable responses = client
     *             .listIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation.</b>
     * </p>
     *
     * @param listIndexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesIterable listIndexesPaginator(ListIndexesRequest listIndexesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        return new ListIndexesIterable(this, listIndexesRequest);
    }

    /**
     * <p>
     * Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable responses = client
     *             .listIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIndexesIterable listIndexesPaginator(Consumer<ListIndexesRequest.Builder> listIndexesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        return listIndexesPaginator(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     * @return Result of the ListSupportedResourceTypes operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupportedResourceTypesResponse listSupportedResourceTypes(
            ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSupportedResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSupportedResourceTypesRequest#builder()}
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest.Builder}
     *        to create a request.
     * @return Result of the ListSupportedResourceTypes operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupportedResourceTypesResponse listSupportedResourceTypes(
            Consumer<ListSupportedResourceTypesRequest.Builder> listSupportedResourceTypesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        return listSupportedResourceTypes(ListSupportedResourceTypesRequest.builder()
                .applyMutation(listSupportedResourceTypesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable responses = client.listSupportedResourceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable responses = client
     *             .listSupportedResourceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable responses = client.listSupportedResourceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupportedResourceTypesIterable listSupportedResourceTypesPaginator(
            ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        return new ListSupportedResourceTypesIterable(this, listSupportedResourceTypesRequest);
    }

    /**
     * <p>
     * Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable responses = client.listSupportedResourceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable responses = client
     *             .listSupportedResourceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable responses = client.listSupportedResourceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSupportedResourceTypes(software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSupportedResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSupportedResourceTypesRequest#builder()}
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupportedResourceTypesIterable listSupportedResourceTypesPaginator(
            Consumer<ListSupportedResourceTypesRequest.Builder> listSupportedResourceTypesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        return listSupportedResourceTypesPaginator(ListSupportedResourceTypesRequest.builder()
                .applyMutation(listSupportedResourceTypesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     * names (ARNs)</a> of the views available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a paginated
     * operation. These operations can occasionally return an empty set of results even when there are more results
     * available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no
     * more results to display.
     * </p>
     * </note>
     *
     * @param listViewsRequest
     * @return Result of the ListViews operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default ListViewsResponse listViews(ListViewsRequest listViewsRequest) throws InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     * names (ARNs)</a> of the views available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a paginated
     * operation. These operations can occasionally return an empty set of results even when there are more results
     * available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no
     * more results to display.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListViewsRequest#builder()}
     * </p>
     *
     * @param listViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest.Builder} to create a
     *        request.
     * @return Result of the ListViews operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default ListViewsResponse listViews(Consumer<ListViewsRequest.Builder> listViewsRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        return listViews(ListViewsRequest.builder().applyMutation(listViewsRequest).build());
    }

    /**
     * <p>
     * Lists the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     * names (ARNs)</a> of the views available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a paginated
     * operation. These operations can occasionally return an empty set of results even when there are more results
     * available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no
     * more results to display.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable responses = client.listViewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable responses = client.listViewsPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable responses = client.listViewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)} operation.</b>
     * </p>
     *
     * @param listViewsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default ListViewsIterable listViewsPaginator(ListViewsRequest listViewsRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        return new ListViewsIterable(this, listViewsRequest);
    }

    /**
     * <p>
     * Lists the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     * names (ARNs)</a> of the views available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a paginated
     * operation. These operations can occasionally return an empty set of results even when there are more results
     * available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no
     * more results to display.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable responses = client.listViewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable responses = client.listViewsPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable responses = client.listViewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listViews(software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListViewsRequest#builder()}
     * </p>
     *
     * @param listViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    default ListViewsIterable listViewsPaginator(Consumer<ListViewsRequest.Builder> listViewsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        return listViewsPaginator(ListViewsRequest.builder().applyMutation(listViewsRequest).build());
    }

    /**
     * <p>
     * Searches for resources and displays details about all resources that match the specified criteria. You must
     * specify a query string.
     * </p>
     * <p>
     * All search queries must use a view. If you don't explicitly specify a view, then Amazon Web Services Resource
     * Explorer uses the default view for the Amazon Web Services Region in which you call this operation. The results
     * are the logical intersection of the results that match both the <code>QueryString</code> parameter supplied to
     * this operation and the <code>SearchFilter</code> parameter attached to the view.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * If your search results are empty, or are missing results that you think should be there, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html">Troubleshooting
     * Resource Explorer search</a>.
     * </p>
     *
     * @param searchRequest
     * @return Result of the Search operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchResponse search(SearchRequest searchRequest) throws ResourceNotFoundException, InternalServerException,
            ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for resources and displays details about all resources that match the specified criteria. You must
     * specify a query string.
     * </p>
     * <p>
     * All search queries must use a view. If you don't explicitly specify a view, then Amazon Web Services Resource
     * Explorer uses the default view for the Amazon Web Services Region in which you call this operation. The results
     * are the logical intersection of the results that match both the <code>QueryString</code> parameter supplied to
     * this operation and the <code>SearchFilter</code> parameter attached to the view.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * If your search results are empty, or are missing results that you think should be there, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html">Troubleshooting
     * Resource Explorer search</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest.Builder} to create a request.
     * @return Result of the Search operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchResponse search(Consumer<SearchRequest.Builder> searchRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return search(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Searches for resources and displays details about all resources that match the specified criteria. You must
     * specify a query string.
     * </p>
     * <p>
     * All search queries must use a view. If you don't explicitly specify a view, then Amazon Web Services Resource
     * Explorer uses the default view for the Amazon Web Services Region in which you call this operation. The results
     * are the logical intersection of the results that match both the <code>QueryString</code> parameter supplied to
     * this operation and the <code>SearchFilter</code> parameter attached to the view.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * If your search results are empty, or are missing results that you think should be there, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html">Troubleshooting
     * Resource Explorer search</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable responses = client.searchPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)} operation.</b>
     * </p>
     *
     * @param searchRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchIterable searchPaginator(SearchRequest searchRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return new SearchIterable(this, searchRequest);
    }

    /**
     * <p>
     * Searches for resources and displays details about all resources that match the specified criteria. You must
     * specify a query string.
     * </p>
     * <p>
     * All search queries must use a view. If you don't explicitly specify a view, then Amazon Web Services Resource
     * Explorer uses the default view for the Amazon Web Services Region in which you call this operation. The results
     * are the logical intersection of the results that match both the <code>QueryString</code> parameter supplied to
     * this operation and the <code>SearchFilter</code> parameter attached to the view.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * If your search results are empty, or are missing results that you think should be there, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html">Troubleshooting
     * Resource Explorer search</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable responses = client.searchPaginator(request);
     *     for (software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchIterable searchPaginator(Consumer<SearchRequest.Builder> searchRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return searchPaginator(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Adds one or more tag key and value pairs to an Amazon Web Services Resource Explorer view or index.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ConflictException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tag key and value pairs to an Amazon Web Services Resource Explorer view or index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ValidationException, ConflictException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tag key and value pairs from an Amazon Web Services Resource Explorer view or index.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tag key and value pairs from an Amazon Web Services Resource Explorer view or index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the type of the index from one of the following types to the other. For more information about indexes
     * and the role they perform in Amazon Web Services Resource Explorer, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>AGGREGATOR</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources from all Amazon Web Services Regions in the Amazon Web Services
     * account in which you've created a Resource Explorer index. Resource information from all other Regions is
     * replicated to this Region's index.
     * </p>
     * <p>
     * When you change the index type to <code>AGGREGATOR</code>, Resource Explorer turns on replication of all
     * discovered resource information from the other Amazon Web Services Regions in your account to this index. You can
     * then, from this Region only, perform resource search queries that span all Amazon Web Services Regions in the
     * Amazon Web Services account. Turning on replication from all other Regions is performed by asynchronous
     * background tasks. You can check the status of the asynchronous tasks by using the <a>GetIndex</a> operation. When
     * the asynchronous tasks complete, the <code>Status</code> response of that operation changes from
     * <code>UPDATING</code> to <code>ACTIVE</code>. After that, you can start to see results from other Amazon Web
     * Services Regions in query results. However, it can take several hours for replication from all other Regions to
     * complete.
     * </p>
     * <important>
     * <p>
     * You can have only one aggregator index per Amazon Web Services account. Before you can promote a different index
     * to be the aggregator index for the account, you must first demote the existing aggregator index to type
     * <code>LOCAL</code>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b> <code>LOCAL</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources in only the Amazon Web Services Region in which the index exists.
     * If an aggregator index in another Region exists, then information in this local index is replicated to the
     * aggregator index.
     * </p>
     * <p>
     * When you change the index type to <code>LOCAL</code>, Resource Explorer turns off the replication of resource
     * information from all other Amazon Web Services Regions in the Amazon Web Services account to this Region. The
     * aggregator index remains in the <code>UPDATING</code> state until all replication with other Regions successfully
     * stops. You can check the status of the asynchronous task by using the <a>GetIndex</a> operation. When Resource
     * Explorer successfully stops all replication with other Regions, the <code>Status</code> response of that
     * operation changes from <code>UPDATING</code> to <code>ACTIVE</code>. Separately, the resource information from
     * other Regions that was previously stored in the index is deleted within 30 days by another background task. Until
     * that asynchronous task completes, some results from other Regions can continue to appear in search results.
     * </p>
     * <important>
     * <p>
     * After you demote an aggregator index to a local index, you must wait 24 hours before you can promote another
     * index to be the new aggregator index for the account.
     * </p>
     * </important></li>
     * </ul>
     *
     * @param updateIndexTypeRequest
     * @return Result of the UpdateIndexType operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UpdateIndexType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateIndexType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIndexTypeResponse updateIndexType(UpdateIndexTypeRequest updateIndexTypeRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ConflictException,
            ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the type of the index from one of the following types to the other. For more information about indexes
     * and the role they perform in Amazon Web Services Resource Explorer, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>AGGREGATOR</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources from all Amazon Web Services Regions in the Amazon Web Services
     * account in which you've created a Resource Explorer index. Resource information from all other Regions is
     * replicated to this Region's index.
     * </p>
     * <p>
     * When you change the index type to <code>AGGREGATOR</code>, Resource Explorer turns on replication of all
     * discovered resource information from the other Amazon Web Services Regions in your account to this index. You can
     * then, from this Region only, perform resource search queries that span all Amazon Web Services Regions in the
     * Amazon Web Services account. Turning on replication from all other Regions is performed by asynchronous
     * background tasks. You can check the status of the asynchronous tasks by using the <a>GetIndex</a> operation. When
     * the asynchronous tasks complete, the <code>Status</code> response of that operation changes from
     * <code>UPDATING</code> to <code>ACTIVE</code>. After that, you can start to see results from other Amazon Web
     * Services Regions in query results. However, it can take several hours for replication from all other Regions to
     * complete.
     * </p>
     * <important>
     * <p>
     * You can have only one aggregator index per Amazon Web Services account. Before you can promote a different index
     * to be the aggregator index for the account, you must first demote the existing aggregator index to type
     * <code>LOCAL</code>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b> <code>LOCAL</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources in only the Amazon Web Services Region in which the index exists.
     * If an aggregator index in another Region exists, then information in this local index is replicated to the
     * aggregator index.
     * </p>
     * <p>
     * When you change the index type to <code>LOCAL</code>, Resource Explorer turns off the replication of resource
     * information from all other Amazon Web Services Regions in the Amazon Web Services account to this Region. The
     * aggregator index remains in the <code>UPDATING</code> state until all replication with other Regions successfully
     * stops. You can check the status of the asynchronous task by using the <a>GetIndex</a> operation. When Resource
     * Explorer successfully stops all replication with other Regions, the <code>Status</code> response of that
     * operation changes from <code>UPDATING</code> to <code>ACTIVE</code>. Separately, the resource information from
     * other Regions that was previously stored in the index is deleted within 30 days by another background task. Until
     * that asynchronous task completes, some results from other Regions can continue to appear in search results.
     * </p>
     * <important>
     * <p>
     * After you demote an aggregator index to a local index, you must wait 24 hours before you can promote another
     * index to be the new aggregator index for the account.
     * </p>
     * </important></li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexTypeRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateIndexTypeRequest#builder()}
     * </p>
     *
     * @param updateIndexTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateIndexType operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         The request failed because either you specified parameters that didn’t match the original request, or you
     *         attempted to create a view with a name that already exists in this Amazon Web Services Region.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UpdateIndexType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateIndexType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIndexTypeResponse updateIndexType(Consumer<UpdateIndexTypeRequest.Builder> updateIndexTypeRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ConflictException,
            ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        return updateIndexType(UpdateIndexTypeRequest.builder().applyMutation(updateIndexTypeRequest).build());
    }

    /**
     * <p>
     * Modifies some of the details of a view. You can change the filter string and the list of included properties. You
     * can't change the name of the view.
     * </p>
     *
     * @param updateViewRequest
     * @return Result of the UpdateView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UpdateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateView"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateViewResponse updateView(UpdateViewRequest updateViewRequest) throws InternalServerException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies some of the details of a view. You can change the filter string and the list of included properties. You
     * can't change the name of the view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateViewRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateViewRequest#builder()}
     * </p>
     *
     * @param updateViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/arexug/mainline/quotas.html">Quotas for Resource Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UpdateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateView"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateViewResponse updateView(Consumer<UpdateViewRequest.Builder> updateViewRequest) throws InternalServerException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return updateView(UpdateViewRequest.builder().applyMutation(updateViewRequest).build());
    }

    /**
     * Create a {@link ResourceExplorer2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ResourceExplorer2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ResourceExplorer2Client}.
     */
    static ResourceExplorer2ClientBuilder builder() {
        return new DefaultResourceExplorer2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ResourceExplorer2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
