/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetViewResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<BatchGetViewResponse.Builder, BatchGetViewResponse> {
    private static final SdkField<List<BatchGetViewError>> ERRORS_FIELD = SdkField
            .<List<BatchGetViewError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetViewResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetViewError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetViewError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<View>> VIEWS_FIELD = SdkField
            .<List<View>> builder(MarshallingType.LIST)
            .memberName("Views")
            .getter(getter(BatchGetViewResponse::views))
            .setter(setter(Builder::views))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Views").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<View> builder(MarshallingType.SDK_POJO)
                                            .constructor(View::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, VIEWS_FIELD));

    private final List<BatchGetViewError> errors;

    private final List<View> views;

    private BatchGetViewResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.views = builder.views;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If any of the specified ARNs result in an error, then this structure describes the error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return If any of the specified ARNs result in an error, then this structure describes the error.
     */
    public final List<BatchGetViewError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Views property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasViews() {
        return views != null && !(views instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure with a list of objects with details for each of the specified views.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViews} method.
     * </p>
     * 
     * @return A structure with a list of objects with details for each of the specified views.
     */
    public final List<View> views() {
        return views;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasViews() ? views() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetViewResponse)) {
            return false;
        }
        BatchGetViewResponse other = (BatchGetViewResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors()) && hasViews() == other.hasViews()
                && Objects.equals(views(), other.views());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetViewResponse").add("Errors", hasErrors() ? errors() : null)
                .add("Views", hasViews() ? views() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Views":
            return Optional.ofNullable(clazz.cast(views()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetViewResponse, T> g) {
        return obj -> g.apply((BatchGetViewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetViewResponse> {
        /**
         * <p>
         * If any of the specified ARNs result in an error, then this structure describes the error.
         * </p>
         * 
         * @param errors
         *        If any of the specified ARNs result in an error, then this structure describes the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetViewError> errors);

        /**
         * <p>
         * If any of the specified ARNs result in an error, then this structure describes the error.
         * </p>
         * 
         * @param errors
         *        If any of the specified ARNs result in an error, then this structure describes the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetViewError... errors);

        /**
         * <p>
         * If any of the specified ARNs result in an error, then this structure describes the error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchGetViewError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetViewError>)
         */
        Builder errors(Consumer<BatchGetViewError.Builder>... errors);

        /**
         * <p>
         * A structure with a list of objects with details for each of the specified views.
         * </p>
         * 
         * @param views
         *        A structure with a list of objects with details for each of the specified views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder views(Collection<View> views);

        /**
         * <p>
         * A structure with a list of objects with details for each of the specified views.
         * </p>
         * 
         * @param views
         *        A structure with a list of objects with details for each of the specified views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder views(View... views);

        /**
         * <p>
         * A structure with a list of objects with details for each of the specified views.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.View.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.resourceexplorer2.model.View#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.View.Builder#build()} is called immediately
         * and its result is passed to {@link #views(List<View>)}.
         * 
         * @param views
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.View.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #views(java.util.Collection<View>)
         */
        Builder views(Consumer<View.Builder>... views);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private List<BatchGetViewError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<View> views = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetViewResponse model) {
            super(model);
            errors(model.errors);
            views(model.views);
        }

        public final List<BatchGetViewError.Builder> getErrors() {
            List<BatchGetViewError.Builder> result = BatchGetViewErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetViewError.BuilderImpl> errors) {
            this.errors = BatchGetViewErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetViewError> errors) {
            this.errors = BatchGetViewErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetViewError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetViewError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetViewError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<View.Builder> getViews() {
            List<View.Builder> result = ViewListCopier.copyToBuilder(this.views);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViews(Collection<View.BuilderImpl> views) {
            this.views = ViewListCopier.copyFromBuilder(views);
        }

        @Override
        public final Builder views(Collection<View> views) {
            this.views = ViewListCopier.copy(views);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder views(View... views) {
            views(Arrays.asList(views));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder views(Consumer<View.Builder>... views) {
            views(Stream.of(views).map(c -> View.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetViewResponse build() {
            return new BatchGetViewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
