/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.MemberIndex;
import software.amazon.awssdk.services.resourceexplorer2.model.MemberIndexListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndexesForMembersResponse
extends ResourceExplorer2Response
implements ToCopyableBuilder<Builder, ListIndexesForMembersResponse> {
    private static final SdkField<List<MemberIndex>> INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Indexes").getter(ListIndexesForMembersResponse.getter(ListIndexesForMembersResponse::indexes)).setter(ListIndexesForMembersResponse.setter(Builder::indexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Indexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIndexesForMembersResponse.getter(ListIndexesForMembersResponse::nextToken)).setter(ListIndexesForMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MemberIndex> indexes;
    private final String nextToken;

    private ListIndexesForMembersResponse(BuilderImpl builder) {
        super(builder);
        this.indexes = builder.indexes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIndexes() {
        return this.indexes != null && !(this.indexes instanceof SdkAutoConstructList);
    }

    public final List<MemberIndex> indexes() {
        return this.indexes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndexes() ? this.indexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexesForMembersResponse)) {
            return false;
        }
        ListIndexesForMembersResponse other = (ListIndexesForMembersResponse)((Object)obj);
        return this.hasIndexes() == other.hasIndexes() && Objects.equals(this.indexes(), other.indexes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIndexesForMembersResponse").add("Indexes", this.hasIndexes() ? this.indexes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Indexes": {
                return Optional.ofNullable(clazz.cast(this.indexes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndexesForMembersResponse, T> g) {
        return obj -> g.apply((ListIndexesForMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Response.BuilderImpl
    implements Builder {
        private List<MemberIndex> indexes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexesForMembersResponse model) {
            super(model);
            this.indexes(model.indexes);
            this.nextToken(model.nextToken);
        }

        public final List<MemberIndex.Builder> getIndexes() {
            List<MemberIndex.Builder> result = MemberIndexListCopier.copyToBuilder(this.indexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexes(Collection<MemberIndex.BuilderImpl> indexes) {
            this.indexes = MemberIndexListCopier.copyFromBuilder(indexes);
        }

        @Override
        public final Builder indexes(Collection<MemberIndex> indexes) {
            this.indexes = MemberIndexListCopier.copy(indexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(MemberIndex ... indexes) {
            this.indexes(Arrays.asList(indexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(Consumer<MemberIndex.Builder> ... indexes) {
            this.indexes(Stream.of(indexes).map(c -> (MemberIndex)((MemberIndex.Builder)MemberIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIndexesForMembersResponse build() {
            return new ListIndexesForMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceExplorer2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndexesForMembersResponse> {
        public Builder indexes(Collection<MemberIndex> var1);

        public Builder indexes(MemberIndex ... var1);

        public Builder indexes(Consumer<MemberIndex.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

