/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Response;
import software.amazon.awssdk.services.resourceexplorer2.model.ServiceViewArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceViewsResponse
extends ResourceExplorer2Response
implements ToCopyableBuilder<Builder, ListServiceViewsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceViewsResponse.getter(ListServiceViewsResponse::nextToken)).setter(ListServiceViewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> SERVICE_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceViews").getter(ListServiceViewsResponse.getter(ListServiceViewsResponse::serviceViews)).setter(ListServiceViewsResponse.setter(Builder::serviceViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICE_VIEWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceViewsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<String> serviceViews;

    private ListServiceViewsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceViews = builder.serviceViews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServiceViews() {
        return this.serviceViews != null && !(this.serviceViews instanceof SdkAutoConstructList);
    }

    public final List<String> serviceViews() {
        return this.serviceViews;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceViews() ? this.serviceViews() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceViewsResponse)) {
            return false;
        }
        ListServiceViewsResponse other = (ListServiceViewsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServiceViews() == other.hasServiceViews() && Objects.equals(this.serviceViews(), other.serviceViews());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceViewsResponse").add("NextToken", (Object)this.nextToken()).add("ServiceViews", this.hasServiceViews() ? this.serviceViews() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServiceViews": {
                return Optional.ofNullable(clazz.cast(this.serviceViews()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ServiceViews", SERVICE_VIEWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceViewsResponse, T> g) {
        return obj -> g.apply((ListServiceViewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> serviceViews = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceViewsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serviceViews(model.serviceViews);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getServiceViews() {
            if (this.serviceViews instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceViews;
        }

        public final void setServiceViews(Collection<String> serviceViews) {
            this.serviceViews = ServiceViewArnListCopier.copy(serviceViews);
        }

        @Override
        public final Builder serviceViews(Collection<String> serviceViews) {
            this.serviceViews = ServiceViewArnListCopier.copy(serviceViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceViews(String ... serviceViews) {
            this.serviceViews(Arrays.asList(serviceViews));
            return this;
        }

        @Override
        public ListServiceViewsResponse build() {
            return new ListServiceViewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResourceExplorer2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceViewsResponse> {
        public Builder nextToken(String var1);

        public Builder serviceViews(Collection<String> var1);

        public Builder serviceViews(String ... var1);
    }
}

