/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedPropertyListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceView
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceView> {
    private static final SdkField<String> SERVICE_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceViewArn").getter(ServiceView.getter(ServiceView::serviceViewArn)).setter(ServiceView.setter(Builder::serviceViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceViewArn").build()}).build();
    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(ServiceView.getter(ServiceView::filters)).setter(ServiceView.setter(Builder::filters)).constructor(SearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedProperties").getter(ServiceView.getter(ServiceView::includedProperties)).setter(ServiceView.setter(Builder::includedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncludedProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STREAMING_ACCESS_FOR_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamingAccessForService").getter(ServiceView.getter(ServiceView::streamingAccessForService)).setter(ServiceView.setter(Builder::streamingAccessForService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingAccessForService").build()}).build();
    private static final SdkField<String> SCOPE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScopeType").getter(ServiceView.getter(ServiceView::scopeType)).setter(ServiceView.setter(Builder::scopeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_VIEW_ARN_FIELD, FILTERS_FIELD, INCLUDED_PROPERTIES_FIELD, STREAMING_ACCESS_FOR_SERVICE_FIELD, SCOPE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceView.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceViewArn;
    private final SearchFilter filters;
    private final List<IncludedProperty> includedProperties;
    private final String streamingAccessForService;
    private final String scopeType;

    private ServiceView(BuilderImpl builder) {
        this.serviceViewArn = builder.serviceViewArn;
        this.filters = builder.filters;
        this.includedProperties = builder.includedProperties;
        this.streamingAccessForService = builder.streamingAccessForService;
        this.scopeType = builder.scopeType;
    }

    public final String serviceViewArn() {
        return this.serviceViewArn;
    }

    public final SearchFilter filters() {
        return this.filters;
    }

    public final boolean hasIncludedProperties() {
        return this.includedProperties != null && !(this.includedProperties instanceof SdkAutoConstructList);
    }

    public final List<IncludedProperty> includedProperties() {
        return this.includedProperties;
    }

    public final String streamingAccessForService() {
        return this.streamingAccessForService;
    }

    public final String scopeType() {
        return this.scopeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedProperties() ? this.includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingAccessForService());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceView)) {
            return false;
        }
        ServiceView other = (ServiceView)obj;
        return Objects.equals(this.serviceViewArn(), other.serviceViewArn()) && Objects.equals(this.filters(), other.filters()) && this.hasIncludedProperties() == other.hasIncludedProperties() && Objects.equals(this.includedProperties(), other.includedProperties()) && Objects.equals(this.streamingAccessForService(), other.streamingAccessForService()) && Objects.equals(this.scopeType(), other.scopeType());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceView").add("ServiceViewArn", (Object)this.serviceViewArn()).add("Filters", (Object)(this.filters() == null ? null : "*** Sensitive Data Redacted ***")).add("IncludedProperties", this.hasIncludedProperties() ? this.includedProperties() : null).add("StreamingAccessForService", (Object)this.streamingAccessForService()).add("ScopeType", (Object)this.scopeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceViewArn": {
                return Optional.ofNullable(clazz.cast(this.serviceViewArn()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "IncludedProperties": {
                return Optional.ofNullable(clazz.cast(this.includedProperties()));
            }
            case "StreamingAccessForService": {
                return Optional.ofNullable(clazz.cast(this.streamingAccessForService()));
            }
            case "ScopeType": {
                return Optional.ofNullable(clazz.cast(this.scopeType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceViewArn", SERVICE_VIEW_ARN_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("IncludedProperties", INCLUDED_PROPERTIES_FIELD);
        map.put("StreamingAccessForService", STREAMING_ACCESS_FOR_SERVICE_FIELD);
        map.put("ScopeType", SCOPE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceView, T> g) {
        return obj -> g.apply((ServiceView)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceViewArn;
        private SearchFilter filters;
        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();
        private String streamingAccessForService;
        private String scopeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceView model) {
            this.serviceViewArn(model.serviceViewArn);
            this.filters(model.filters);
            this.includedProperties(model.includedProperties);
            this.streamingAccessForService(model.streamingAccessForService);
            this.scopeType(model.scopeType);
        }

        public final String getServiceViewArn() {
            return this.serviceViewArn;
        }

        public final void setServiceViewArn(String serviceViewArn) {
            this.serviceViewArn = serviceViewArn;
        }

        @Override
        public final Builder serviceViewArn(String serviceViewArn) {
            this.serviceViewArn = serviceViewArn;
            return this;
        }

        public final SearchFilter.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty ... includedProperties) {
            this.includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder> ... includedProperties) {
            this.includedProperties(Stream.of(includedProperties).map(c -> (IncludedProperty)((IncludedProperty.Builder)IncludedProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStreamingAccessForService() {
            return this.streamingAccessForService;
        }

        public final void setStreamingAccessForService(String streamingAccessForService) {
            this.streamingAccessForService = streamingAccessForService;
        }

        @Override
        public final Builder streamingAccessForService(String streamingAccessForService) {
            this.streamingAccessForService = streamingAccessForService;
            return this;
        }

        public final String getScopeType() {
            return this.scopeType;
        }

        public final void setScopeType(String scopeType) {
            this.scopeType = scopeType;
        }

        @Override
        public final Builder scopeType(String scopeType) {
            this.scopeType = scopeType;
            return this;
        }

        public ServiceView build() {
            return new ServiceView(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceView> {
        public Builder serviceViewArn(String var1);

        public Builder filters(SearchFilter var1);

        default public Builder filters(Consumer<SearchFilter.Builder> filters) {
            return this.filters((SearchFilter)((SearchFilter.Builder)SearchFilter.builder().applyMutation(filters)).build());
        }

        public Builder includedProperties(Collection<IncludedProperty> var1);

        public Builder includedProperties(IncludedProperty ... var1);

        public Builder includedProperties(Consumer<IncludedProperty.Builder> ... var1);

        public Builder streamingAccessForService(String var1);

        public Builder scopeType(String var1);
    }
}

