/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGroupRequest
extends ResourceGroupsRequest
implements ToCopyableBuilder<Builder, GetGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(GetGroupRequest.getter(GetGroupRequest::groupName)).setter(GetGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(GetGroupRequest.getter(GetGroupRequest::group)).setter(GetGroupRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_FIELD));
    private final String groupName;
    private final String group;

    private GetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.group = builder.group;
    }

    @Deprecated
    public final String groupName() {
        return this.groupName;
    }

    public final String group() {
        return this.group;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupRequest)) {
            return false;
        }
        GetGroupRequest other = (GetGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.group(), other.group());
    }

    public final String toString() {
        return ToString.builder((String)"GetGroupRequest").add("GroupName", (Object)this.groupName()).add("Group", (Object)this.group()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupRequest, T> g) {
        return obj -> g.apply((GetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.group(model.group);
        }

        @Deprecated
        public final String getGroupName() {
            return this.groupName;
        }

        @Deprecated
        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Deprecated
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGroupRequest build() {
            return new GetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGroupRequest> {
        @Deprecated
        public Builder groupName(String var1);

        public Builder group(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

