/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentJobRequest extends RoboMakerRequest implements
        ToCopyableBuilder<CreateDeploymentJobRequest.Builder, CreateDeploymentJobRequest> {
    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("deploymentConfig")
            .getter(getter(CreateDeploymentJobRequest::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(DeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfig").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateDeploymentJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FLEET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fleet")
            .getter(getter(CreateDeploymentJobRequest::fleet)).setter(setter(Builder::fleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final SdkField<List<DeploymentApplicationConfig>> DEPLOYMENT_APPLICATION_CONFIGS_FIELD = SdkField
            .<List<DeploymentApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("deploymentApplicationConfigs")
            .getter(getter(CreateDeploymentJobRequest::deploymentApplicationConfigs))
            .setter(setter(Builder::deploymentApplicationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentApplicationConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDeploymentJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, FLEET_FIELD, DEPLOYMENT_APPLICATION_CONFIGS_FIELD, TAGS_FIELD));

    private final DeploymentConfig deploymentConfig;

    private final String clientRequestToken;

    private final String fleet;

    private final List<DeploymentApplicationConfig> deploymentApplicationConfigs;

    private final Map<String, String> tags;

    private CreateDeploymentJobRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentConfig = builder.deploymentConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.fleet = builder.fleet;
        this.deploymentApplicationConfigs = builder.deploymentApplicationConfigs;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The requested deployment configuration.
     * </p>
     * 
     * @return The requested deployment configuration.
     */
    public final DeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet to deploy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet to deploy.
     */
    public final String fleet() {
        return fleet;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentApplicationConfigs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeploymentApplicationConfigs() {
        return deploymentApplicationConfigs != null && !(deploymentApplicationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The deployment application configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentApplicationConfigs} method.
     * </p>
     * 
     * @return The deployment application configuration.
     */
    public final List<DeploymentApplicationConfig> deploymentApplicationConfigs() {
        return deploymentApplicationConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the deployment job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the deployment job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentApplicationConfigs() ? deploymentApplicationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentJobRequest)) {
            return false;
        }
        CreateDeploymentJobRequest other = (CreateDeploymentJobRequest) obj;
        return Objects.equals(deploymentConfig(), other.deploymentConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(fleet(), other.fleet())
                && hasDeploymentApplicationConfigs() == other.hasDeploymentApplicationConfigs()
                && Objects.equals(deploymentApplicationConfigs(), other.deploymentApplicationConfigs())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeploymentJobRequest").add("DeploymentConfig", deploymentConfig())
                .add("ClientRequestToken", clientRequestToken()).add("Fleet", fleet())
                .add("DeploymentApplicationConfigs", hasDeploymentApplicationConfigs() ? deploymentApplicationConfigs() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        case "deploymentApplicationConfigs":
            return Optional.ofNullable(clazz.cast(deploymentApplicationConfigs()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentJobRequest, T> g) {
        return obj -> g.apply((CreateDeploymentJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentJobRequest> {
        /**
         * <p>
         * The requested deployment configuration.
         * </p>
         * 
         * @param deploymentConfig
         *        The requested deployment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(DeploymentConfig deploymentConfig);

        /**
         * <p>
         * The requested deployment configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfig.Builder} avoiding the
         * need to create one manually via {@link DeploymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentConfig(DeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(DeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(DeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet to deploy.
         * </p>
         * 
         * @param fleet
         *        The Amazon Resource Name (ARN) of the fleet to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(String fleet);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #deploymentApplicationConfigs(List<DeploymentApplicationConfig>)}.
         * 
         * @param deploymentApplicationConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentApplicationConfigs(java.util.Collection<DeploymentApplicationConfig>)
         */
        Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the deployment job.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private DeploymentConfig deploymentConfig;

        private String clientRequestToken;

        private String fleet;

        private List<DeploymentApplicationConfig> deploymentApplicationConfigs = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentJobRequest model) {
            super(model);
            deploymentConfig(model.deploymentConfig);
            clientRequestToken(model.clientRequestToken);
            fleet(model.fleet);
            deploymentApplicationConfigs(model.deploymentApplicationConfigs);
            tags(model.tags);
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getFleet() {
            return fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final List<DeploymentApplicationConfig.Builder> getDeploymentApplicationConfigs() {
            List<DeploymentApplicationConfig.Builder> result = DeploymentApplicationConfigsCopier
                    .copyToBuilder(this.deploymentApplicationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentApplicationConfigs(
                Collection<DeploymentApplicationConfig.BuilderImpl> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copyFromBuilder(deploymentApplicationConfigs);
        }

        @Override
        public final Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copy(deploymentApplicationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Arrays.asList(deploymentApplicationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(
                Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Stream.of(deploymentApplicationConfigs)
                    .map(c -> DeploymentApplicationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentJobRequest build() {
            return new CreateDeploymentJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
