/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheckLastFailureReason</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHealthCheckLastFailureReasonResponse extends Route53Response implements
        ToCopyableBuilder<GetHealthCheckLastFailureReasonResponse.Builder, GetHealthCheckLastFailureReasonResponse> {
    private static final SdkField<List<HealthCheckObservation>> HEALTH_CHECK_OBSERVATIONS_FIELD = SdkField
            .<List<HealthCheckObservation>> builder(MarshallingType.LIST)
            .memberName("HealthCheckObservations")
            .getter(getter(GetHealthCheckLastFailureReasonResponse::healthCheckObservations))
            .setter(setter(Builder::healthCheckObservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckObservations")
                    .unmarshallLocationName("HealthCheckObservations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HealthCheckObservation")
                            .memberFieldInfo(
                                    SdkField.<HealthCheckObservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(HealthCheckObservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HealthCheckObservation")
                                                    .unmarshallLocationName("HealthCheckObservation").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HEALTH_CHECK_OBSERVATIONS_FIELD));

    private final List<HealthCheckObservation> healthCheckObservations;

    private GetHealthCheckLastFailureReasonResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheckObservations = builder.healthCheckObservations;
    }

    /**
     * For responses, this returns true if the service returned a value for the HealthCheckObservations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHealthCheckObservations() {
        return healthCheckObservations != null && !(healthCheckObservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
     * reporting a last failure reason.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHealthCheckObservations} method.
     * </p>
     * 
     * @return A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
     *         reporting a last failure reason.
     */
    public final List<HealthCheckObservation> healthCheckObservations() {
        return healthCheckObservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHealthCheckObservations() ? healthCheckObservations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckLastFailureReasonResponse)) {
            return false;
        }
        GetHealthCheckLastFailureReasonResponse other = (GetHealthCheckLastFailureReasonResponse) obj;
        return hasHealthCheckObservations() == other.hasHealthCheckObservations()
                && Objects.equals(healthCheckObservations(), other.healthCheckObservations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHealthCheckLastFailureReasonResponse")
                .add("HealthCheckObservations", hasHealthCheckObservations() ? healthCheckObservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckObservations":
            return Optional.ofNullable(clazz.cast(healthCheckObservations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHealthCheckLastFailureReasonResponse, T> g) {
        return obj -> g.apply((GetHealthCheckLastFailureReasonResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetHealthCheckLastFailureReasonResponse> {
        /**
         * <p>
         * A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
         * reporting a last failure reason.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that
         *        is reporting a last failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
         * reporting a last failure reason.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that
         *        is reporting a last failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
         * reporting a last failure reason.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.HealthCheckObservation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.route53.model.HealthCheckObservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.HealthCheckObservation.Builder#build()} is called
         * immediately and its result is passed to {@link #healthCheckObservations(List<HealthCheckObservation>)}.
         * 
         * @param healthCheckObservations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.HealthCheckObservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckObservations(java.util.Collection<HealthCheckObservation>)
         */
        Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder>... healthCheckObservations);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HealthCheckObservation> healthCheckObservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckLastFailureReasonResponse model) {
            super(model);
            healthCheckObservations(model.healthCheckObservations);
        }

        public final List<HealthCheckObservation.Builder> getHealthCheckObservations() {
            List<HealthCheckObservation.Builder> result = HealthCheckObservationsCopier
                    .copyToBuilder(this.healthCheckObservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHealthCheckObservations(Collection<HealthCheckObservation.BuilderImpl> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copyFromBuilder(healthCheckObservations);
        }

        @Override
        public final Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations) {
            healthCheckObservations(Arrays.asList(healthCheckObservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder>... healthCheckObservations) {
            healthCheckObservations(Stream.of(healthCheckObservations)
                    .map(c -> HealthCheckObservation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetHealthCheckLastFailureReasonResponse build() {
            return new GetHealthCheckLastFailureReasonResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
