/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ChangeAction;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Change
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Change> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(Change.getter(Change::actionAsString)).setter(Change.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").unmarshallLocationName("Action").build()}).build();
    private static final SdkField<ResourceRecordSet> RESOURCE_RECORD_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceRecordSet").getter(Change.getter(Change::resourceRecordSet)).setter(Change.setter(Builder::resourceRecordSet)).constructor(ResourceRecordSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecordSet").unmarshallLocationName("ResourceRecordSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, RESOURCE_RECORD_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Change.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final ResourceRecordSet resourceRecordSet;

    private Change(BuilderImpl builder) {
        this.action = builder.action;
        this.resourceRecordSet = builder.resourceRecordSet;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final ResourceRecordSet resourceRecordSet() {
        return this.resourceRecordSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecordSet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.resourceRecordSet(), other.resourceRecordSet());
    }

    public final String toString() {
        return ToString.builder((String)"Change").add("Action", (Object)this.actionAsString()).add("ResourceRecordSet", (Object)this.resourceRecordSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "ResourceRecordSet": {
                return Optional.ofNullable(clazz.cast(this.resourceRecordSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("ResourceRecordSet", RESOURCE_RECORD_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Change, T> g) {
        return obj -> g.apply((Change)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ResourceRecordSet resourceRecordSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            this.action(model.action);
            this.resourceRecordSet(model.resourceRecordSet);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final ResourceRecordSet.Builder getResourceRecordSet() {
            return this.resourceRecordSet != null ? this.resourceRecordSet.toBuilder() : null;
        }

        public final void setResourceRecordSet(ResourceRecordSet.BuilderImpl resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet != null ? resourceRecordSet.build() : null;
        }

        @Override
        public final Builder resourceRecordSet(ResourceRecordSet resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet;
            return this;
        }

        public Change build() {
            return new Change(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Change> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder resourceRecordSet(ResourceRecordSet var1);

        default public Builder resourceRecordSet(Consumer<ResourceRecordSet.Builder> resourceRecordSet) {
            return this.resourceRecordSet((ResourceRecordSet)((ResourceRecordSet.Builder)ResourceRecordSet.builder().applyMutation(resourceRecordSet)).build());
        }
    }
}

