/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.CidrBlockSummary;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse;

public class ListCidrBlocksIterable
implements SdkIterable<ListCidrBlocksResponse> {
    private final Route53Client client;
    private final ListCidrBlocksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCidrBlocksIterable(Route53Client client, ListCidrBlocksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCidrBlocksResponseFetcher();
    }

    public Iterator<ListCidrBlocksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CidrBlockSummary> cidrBlocks() {
        Function<ListCidrBlocksResponse, Iterator> getIterator = response -> {
            if (response != null && response.cidrBlocks() != null) {
                return response.cidrBlocks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCidrBlocksResponseFetcher
    implements SyncPageFetcher<ListCidrBlocksResponse> {
        private ListCidrBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListCidrBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCidrBlocksResponse nextPage(ListCidrBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListCidrBlocksIterable.this.client.listCidrBlocks(ListCidrBlocksIterable.this.firstRequest);
            }
            return ListCidrBlocksIterable.this.client.listCidrBlocks((ListCidrBlocksRequest)((Object)ListCidrBlocksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

