/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the domain price associated with a TLD.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainPrice implements SdkPojo, Serializable, ToCopyableBuilder<DomainPrice.Builder, DomainPrice> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DomainPrice::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PriceWithCurrency> REGISTRATION_PRICE_FIELD = SdkField
            .<PriceWithCurrency> builder(MarshallingType.SDK_POJO).memberName("RegistrationPrice")
            .getter(getter(DomainPrice::registrationPrice)).setter(setter(Builder::registrationPrice))
            .constructor(PriceWithCurrency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationPrice").build()).build();

    private static final SdkField<PriceWithCurrency> TRANSFER_PRICE_FIELD = SdkField
            .<PriceWithCurrency> builder(MarshallingType.SDK_POJO).memberName("TransferPrice")
            .getter(getter(DomainPrice::transferPrice)).setter(setter(Builder::transferPrice))
            .constructor(PriceWithCurrency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferPrice").build()).build();

    private static final SdkField<PriceWithCurrency> RENEWAL_PRICE_FIELD = SdkField
            .<PriceWithCurrency> builder(MarshallingType.SDK_POJO).memberName("RenewalPrice")
            .getter(getter(DomainPrice::renewalPrice)).setter(setter(Builder::renewalPrice))
            .constructor(PriceWithCurrency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalPrice").build()).build();

    private static final SdkField<PriceWithCurrency> CHANGE_OWNERSHIP_PRICE_FIELD = SdkField
            .<PriceWithCurrency> builder(MarshallingType.SDK_POJO).memberName("ChangeOwnershipPrice")
            .getter(getter(DomainPrice::changeOwnershipPrice)).setter(setter(Builder::changeOwnershipPrice))
            .constructor(PriceWithCurrency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeOwnershipPrice").build())
            .build();

    private static final SdkField<PriceWithCurrency> RESTORATION_PRICE_FIELD = SdkField
            .<PriceWithCurrency> builder(MarshallingType.SDK_POJO).memberName("RestorationPrice")
            .getter(getter(DomainPrice::restorationPrice)).setter(setter(Builder::restorationPrice))
            .constructor(PriceWithCurrency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorationPrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REGISTRATION_PRICE_FIELD, TRANSFER_PRICE_FIELD, RENEWAL_PRICE_FIELD, CHANGE_OWNERSHIP_PRICE_FIELD,
            RESTORATION_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final PriceWithCurrency registrationPrice;

    private final PriceWithCurrency transferPrice;

    private final PriceWithCurrency renewalPrice;

    private final PriceWithCurrency changeOwnershipPrice;

    private final PriceWithCurrency restorationPrice;

    private DomainPrice(BuilderImpl builder) {
        this.name = builder.name;
        this.registrationPrice = builder.registrationPrice;
        this.transferPrice = builder.transferPrice;
        this.renewalPrice = builder.renewalPrice;
        this.changeOwnershipPrice = builder.changeOwnershipPrice;
        this.restorationPrice = builder.restorationPrice;
    }

    /**
     * <p>
     * The name of the TLD for which the prices apply.
     * </p>
     * 
     * @return The name of the TLD for which the prices apply.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The price for domain registration with Route 53.
     * </p>
     * 
     * @return The price for domain registration with Route 53.
     */
    public final PriceWithCurrency registrationPrice() {
        return registrationPrice;
    }

    /**
     * <p>
     * The price for transferring the domain registration to Route 53.
     * </p>
     * 
     * @return The price for transferring the domain registration to Route 53.
     */
    public final PriceWithCurrency transferPrice() {
        return transferPrice;
    }

    /**
     * <p>
     * The price for renewing domain registration with Route 53.
     * </p>
     * 
     * @return The price for renewing domain registration with Route 53.
     */
    public final PriceWithCurrency renewalPrice() {
        return renewalPrice;
    }

    /**
     * <p>
     * The price for changing domain ownership.
     * </p>
     * 
     * @return The price for changing domain ownership.
     */
    public final PriceWithCurrency changeOwnershipPrice() {
        return changeOwnershipPrice;
    }

    /**
     * <p>
     * The price for restoring the domain with Route 53.
     * </p>
     * 
     * @return The price for restoring the domain with Route 53.
     */
    public final PriceWithCurrency restorationPrice() {
        return restorationPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(registrationPrice());
        hashCode = 31 * hashCode + Objects.hashCode(transferPrice());
        hashCode = 31 * hashCode + Objects.hashCode(renewalPrice());
        hashCode = 31 * hashCode + Objects.hashCode(changeOwnershipPrice());
        hashCode = 31 * hashCode + Objects.hashCode(restorationPrice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainPrice)) {
            return false;
        }
        DomainPrice other = (DomainPrice) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(registrationPrice(), other.registrationPrice())
                && Objects.equals(transferPrice(), other.transferPrice()) && Objects.equals(renewalPrice(), other.renewalPrice())
                && Objects.equals(changeOwnershipPrice(), other.changeOwnershipPrice())
                && Objects.equals(restorationPrice(), other.restorationPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainPrice").add("Name", name()).add("RegistrationPrice", registrationPrice())
                .add("TransferPrice", transferPrice()).add("RenewalPrice", renewalPrice())
                .add("ChangeOwnershipPrice", changeOwnershipPrice()).add("RestorationPrice", restorationPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RegistrationPrice":
            return Optional.ofNullable(clazz.cast(registrationPrice()));
        case "TransferPrice":
            return Optional.ofNullable(clazz.cast(transferPrice()));
        case "RenewalPrice":
            return Optional.ofNullable(clazz.cast(renewalPrice()));
        case "ChangeOwnershipPrice":
            return Optional.ofNullable(clazz.cast(changeOwnershipPrice()));
        case "RestorationPrice":
            return Optional.ofNullable(clazz.cast(restorationPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainPrice, T> g) {
        return obj -> g.apply((DomainPrice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainPrice> {
        /**
         * <p>
         * The name of the TLD for which the prices apply.
         * </p>
         * 
         * @param name
         *        The name of the TLD for which the prices apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The price for domain registration with Route 53.
         * </p>
         * 
         * @param registrationPrice
         *        The price for domain registration with Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationPrice(PriceWithCurrency registrationPrice);

        /**
         * <p>
         * The price for domain registration with Route 53.
         * </p>
         * This is a convenience method that creates an instance of the {@link PriceWithCurrency.Builder} avoiding the
         * need to create one manually via {@link PriceWithCurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PriceWithCurrency.Builder#build()} is called immediately and its
         * result is passed to {@link #registrationPrice(PriceWithCurrency)}.
         * 
         * @param registrationPrice
         *        a consumer that will call methods on {@link PriceWithCurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationPrice(PriceWithCurrency)
         */
        default Builder registrationPrice(Consumer<PriceWithCurrency.Builder> registrationPrice) {
            return registrationPrice(PriceWithCurrency.builder().applyMutation(registrationPrice).build());
        }

        /**
         * <p>
         * The price for transferring the domain registration to Route 53.
         * </p>
         * 
         * @param transferPrice
         *        The price for transferring the domain registration to Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferPrice(PriceWithCurrency transferPrice);

        /**
         * <p>
         * The price for transferring the domain registration to Route 53.
         * </p>
         * This is a convenience method that creates an instance of the {@link PriceWithCurrency.Builder} avoiding the
         * need to create one manually via {@link PriceWithCurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PriceWithCurrency.Builder#build()} is called immediately and its
         * result is passed to {@link #transferPrice(PriceWithCurrency)}.
         * 
         * @param transferPrice
         *        a consumer that will call methods on {@link PriceWithCurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transferPrice(PriceWithCurrency)
         */
        default Builder transferPrice(Consumer<PriceWithCurrency.Builder> transferPrice) {
            return transferPrice(PriceWithCurrency.builder().applyMutation(transferPrice).build());
        }

        /**
         * <p>
         * The price for renewing domain registration with Route 53.
         * </p>
         * 
         * @param renewalPrice
         *        The price for renewing domain registration with Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalPrice(PriceWithCurrency renewalPrice);

        /**
         * <p>
         * The price for renewing domain registration with Route 53.
         * </p>
         * This is a convenience method that creates an instance of the {@link PriceWithCurrency.Builder} avoiding the
         * need to create one manually via {@link PriceWithCurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PriceWithCurrency.Builder#build()} is called immediately and its
         * result is passed to {@link #renewalPrice(PriceWithCurrency)}.
         * 
         * @param renewalPrice
         *        a consumer that will call methods on {@link PriceWithCurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renewalPrice(PriceWithCurrency)
         */
        default Builder renewalPrice(Consumer<PriceWithCurrency.Builder> renewalPrice) {
            return renewalPrice(PriceWithCurrency.builder().applyMutation(renewalPrice).build());
        }

        /**
         * <p>
         * The price for changing domain ownership.
         * </p>
         * 
         * @param changeOwnershipPrice
         *        The price for changing domain ownership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeOwnershipPrice(PriceWithCurrency changeOwnershipPrice);

        /**
         * <p>
         * The price for changing domain ownership.
         * </p>
         * This is a convenience method that creates an instance of the {@link PriceWithCurrency.Builder} avoiding the
         * need to create one manually via {@link PriceWithCurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PriceWithCurrency.Builder#build()} is called immediately and its
         * result is passed to {@link #changeOwnershipPrice(PriceWithCurrency)}.
         * 
         * @param changeOwnershipPrice
         *        a consumer that will call methods on {@link PriceWithCurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeOwnershipPrice(PriceWithCurrency)
         */
        default Builder changeOwnershipPrice(Consumer<PriceWithCurrency.Builder> changeOwnershipPrice) {
            return changeOwnershipPrice(PriceWithCurrency.builder().applyMutation(changeOwnershipPrice).build());
        }

        /**
         * <p>
         * The price for restoring the domain with Route 53.
         * </p>
         * 
         * @param restorationPrice
         *        The price for restoring the domain with Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorationPrice(PriceWithCurrency restorationPrice);

        /**
         * <p>
         * The price for restoring the domain with Route 53.
         * </p>
         * This is a convenience method that creates an instance of the {@link PriceWithCurrency.Builder} avoiding the
         * need to create one manually via {@link PriceWithCurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PriceWithCurrency.Builder#build()} is called immediately and its
         * result is passed to {@link #restorationPrice(PriceWithCurrency)}.
         * 
         * @param restorationPrice
         *        a consumer that will call methods on {@link PriceWithCurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restorationPrice(PriceWithCurrency)
         */
        default Builder restorationPrice(Consumer<PriceWithCurrency.Builder> restorationPrice) {
            return restorationPrice(PriceWithCurrency.builder().applyMutation(restorationPrice).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private PriceWithCurrency registrationPrice;

        private PriceWithCurrency transferPrice;

        private PriceWithCurrency renewalPrice;

        private PriceWithCurrency changeOwnershipPrice;

        private PriceWithCurrency restorationPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainPrice model) {
            name(model.name);
            registrationPrice(model.registrationPrice);
            transferPrice(model.transferPrice);
            renewalPrice(model.renewalPrice);
            changeOwnershipPrice(model.changeOwnershipPrice);
            restorationPrice(model.restorationPrice);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PriceWithCurrency.Builder getRegistrationPrice() {
            return registrationPrice != null ? registrationPrice.toBuilder() : null;
        }

        public final void setRegistrationPrice(PriceWithCurrency.BuilderImpl registrationPrice) {
            this.registrationPrice = registrationPrice != null ? registrationPrice.build() : null;
        }

        @Override
        public final Builder registrationPrice(PriceWithCurrency registrationPrice) {
            this.registrationPrice = registrationPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getTransferPrice() {
            return transferPrice != null ? transferPrice.toBuilder() : null;
        }

        public final void setTransferPrice(PriceWithCurrency.BuilderImpl transferPrice) {
            this.transferPrice = transferPrice != null ? transferPrice.build() : null;
        }

        @Override
        public final Builder transferPrice(PriceWithCurrency transferPrice) {
            this.transferPrice = transferPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getRenewalPrice() {
            return renewalPrice != null ? renewalPrice.toBuilder() : null;
        }

        public final void setRenewalPrice(PriceWithCurrency.BuilderImpl renewalPrice) {
            this.renewalPrice = renewalPrice != null ? renewalPrice.build() : null;
        }

        @Override
        public final Builder renewalPrice(PriceWithCurrency renewalPrice) {
            this.renewalPrice = renewalPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getChangeOwnershipPrice() {
            return changeOwnershipPrice != null ? changeOwnershipPrice.toBuilder() : null;
        }

        public final void setChangeOwnershipPrice(PriceWithCurrency.BuilderImpl changeOwnershipPrice) {
            this.changeOwnershipPrice = changeOwnershipPrice != null ? changeOwnershipPrice.build() : null;
        }

        @Override
        public final Builder changeOwnershipPrice(PriceWithCurrency changeOwnershipPrice) {
            this.changeOwnershipPrice = changeOwnershipPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getRestorationPrice() {
            return restorationPrice != null ? restorationPrice.toBuilder() : null;
        }

        public final void setRestorationPrice(PriceWithCurrency.BuilderImpl restorationPrice) {
            this.restorationPrice = restorationPrice != null ? restorationPrice.build() : null;
        }

        @Override
        public final Builder restorationPrice(PriceWithCurrency restorationPrice) {
            this.restorationPrice = restorationPrice;
            return this;
        }

        @Override
        public DomainPrice build() {
            return new DomainPrice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
