/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DomainSummaryListCopier {
    static List<DomainSummary> copy(Collection<? extends DomainSummary> domainSummaryListParam) {
        List<DomainSummary> list;
        if (domainSummaryListParam == null || domainSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DomainSummary> modifiableList = new ArrayList<>();
            domainSummaryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DomainSummary> copyFromBuilder(Collection<? extends DomainSummary.Builder> domainSummaryListParam) {
        List<DomainSummary> list;
        if (domainSummaryListParam == null || domainSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DomainSummary> modifiableList = new ArrayList<>();
            domainSummaryListParam.forEach(entry -> {
                DomainSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DomainSummary.Builder> copyToBuilder(Collection<? extends DomainSummary> domainSummaryListParam) {
        List<DomainSummary.Builder> list;
        if (domainSummaryListParam == null || domainSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DomainSummary.Builder> modifiableList = new ArrayList<>();
            domainSummaryListParam.forEach(entry -> {
                DomainSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
