/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about whether the specified domain can be transferred to Route 53.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainTransferability implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainTransferability.Builder, DomainTransferability> {
    private static final SdkField<String> TRANSFERABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Transferable").getter(getter(DomainTransferability::transferableAsString))
            .setter(setter(Builder::transferable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transferable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFERABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transferable;

    private DomainTransferability(BuilderImpl builder) {
        this.transferable = builder.transferable;
    }

    /**
     * Returns the value of the Transferable property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferable} will
     * return {@link Transferable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferableAsString}.
     * </p>
     * 
     * @return The value of the Transferable property for this object.
     * @see Transferable
     */
    public final Transferable transferable() {
        return Transferable.fromValue(transferable);
    }

    /**
     * Returns the value of the Transferable property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferable} will
     * return {@link Transferable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferableAsString}.
     * </p>
     * 
     * @return The value of the Transferable property for this object.
     * @see Transferable
     */
    public final String transferableAsString() {
        return transferable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transferableAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainTransferability)) {
            return false;
        }
        DomainTransferability other = (DomainTransferability) obj;
        return Objects.equals(transferableAsString(), other.transferableAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainTransferability").add("Transferable", transferableAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transferable":
            return Optional.ofNullable(clazz.cast(transferableAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainTransferability, T> g) {
        return obj -> g.apply((DomainTransferability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainTransferability> {
        /**
         * Sets the value of the Transferable property for this object.
         *
         * @param transferable
         *        The new value for the Transferable property for this object.
         * @see Transferable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Transferable
         */
        Builder transferable(String transferable);

        /**
         * Sets the value of the Transferable property for this object.
         *
         * @param transferable
         *        The new value for the Transferable property for this object.
         * @see Transferable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Transferable
         */
        Builder transferable(Transferable transferable);
    }

    static final class BuilderImpl implements Builder {
        private String transferable;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainTransferability model) {
            transferable(model.transferable);
        }

        public final String getTransferable() {
            return transferable;
        }

        public final void setTransferable(String transferable) {
            this.transferable = transferable;
        }

        @Override
        public final Builder transferable(String transferable) {
            this.transferable = transferable;
            return this;
        }

        @Override
        public final Builder transferable(Transferable transferable) {
            this.transferable(transferable == null ? null : transferable.toString());
            return this;
        }

        @Override
        public DomainTransferability build() {
            return new DomainTransferability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
